/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap.wsdiscovery;

import com.google.common.primitives.UnsignedInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.somda.sdc.dpws.CommunicationLogContext;
import org.somda.sdc.dpws.DpwsTest;
import org.somda.sdc.dpws.helper.JaxbMarshalling;
import org.somda.sdc.dpws.soap.ApplicationInfo;
import org.somda.sdc.dpws.soap.CommunicationContext;
import org.somda.sdc.dpws.soap.NotificationSource;
import org.somda.sdc.dpws.soap.RequestResponseServer;
import org.somda.sdc.dpws.soap.SoapMarshalling;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.SoapUtil;
import org.somda.sdc.dpws.soap.TransportInfo;
import org.somda.sdc.dpws.soap.factory.NotificationSourceFactory;
import org.somda.sdc.dpws.soap.factory.SoapMessageFactory;
import org.somda.sdc.dpws.soap.interception.Interceptor;
import org.somda.sdc.dpws.soap.model.Envelope;
import org.somda.sdc.dpws.soap.wsaddressing.model.AttributedURIType;
import org.somda.sdc.dpws.soap.wsaddressing.model.EndpointReferenceType;
import org.somda.sdc.dpws.soap.wsaddressing.model.ObjectFactory;
import org.somda.sdc.dpws.soap.wsdiscovery.WsDiscoveryTargetService;
import org.somda.sdc.dpws.soap.wsdiscovery.factory.WsDiscoveryTargetServiceFactory;
import org.somda.sdc.dpws.soap.wsdiscovery.model.ByeType;
import org.somda.sdc.dpws.soap.wsdiscovery.model.HelloType;

class WsDiscoveryDiscoveryAccessInterceptorTest
extends DpwsTest {
    private List<SoapMessage> sentSoapMessages;
    private WsDiscoveryTargetService wsDiscoveryTargetService;
    private QName expectedType;
    private String expectedScope;
    private String expectedXAddr;
    private List<QName> expectedTypes;
    private List<String> expectedScopes;
    private List<String> expectedXAddrs;
    private SoapUtil soapUtil;
    private SoapMarshalling unmarshaller;
    private RequestResponseServer reqResServer;
    private SoapMessageFactory soapMessageFactory;
    private CommunicationContext mockCommunicationContext;

    WsDiscoveryDiscoveryAccessInterceptorTest() {
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.mockCommunicationContext = new CommunicationContext(new ApplicationInfo(), new TransportInfo("mock.scheme", "localhost", Integer.valueOf(123), "remotehost", Integer.valueOf(456), Collections.emptyList()), new CommunicationLogContext("txetnoCgoLnoitacinummoC"));
        this.sentSoapMessages = new ArrayList<SoapMessage>();
        this.soapMessageFactory = (SoapMessageFactory)this.getInjector().getInstance(SoapMessageFactory.class);
        NotificationSourceFactory nSourceFactory = (NotificationSourceFactory)this.getInjector().getInstance(NotificationSourceFactory.class);
        NotificationSource notificationSource = nSourceFactory.createNotificationSource(notification -> this.sentSoapMessages.add(notification));
        WsDiscoveryTargetServiceFactory wsdTargetServiceFactory = (WsDiscoveryTargetServiceFactory)this.getInjector().getInstance(WsDiscoveryTargetServiceFactory.class);
        this.soapUtil = (SoapUtil)this.getInjector().getInstance(SoapUtil.class);
        ObjectFactory wsaFactory = (ObjectFactory)this.getInjector().getInstance(ObjectFactory.class);
        EndpointReferenceType expectedEpr = wsaFactory.createEndpointReferenceType();
        AttributedURIType eprUri = wsaFactory.createAttributedURIType();
        eprUri.setValue("http://expectedEpr-uri");
        expectedEpr.setAddress(eprUri);
        this.wsDiscoveryTargetService = wsdTargetServiceFactory.createWsDiscoveryTargetService(expectedEpr, notificationSource);
        this.expectedType = new QName("http://namespace", "type");
        this.expectedScope = "http://namespace/scope";
        this.expectedXAddr = "http://1.2.3.4";
        this.expectedTypes = new ArrayList<QName>();
        this.expectedTypes.add(this.expectedType);
        this.wsDiscoveryTargetService.setTypes(this.expectedTypes);
        this.expectedScopes = new ArrayList<String>();
        this.expectedScopes.add(this.expectedScope);
        this.wsDiscoveryTargetService.setScopes(this.expectedScopes);
        this.expectedXAddrs = new ArrayList<String>();
        this.expectedXAddrs.add(this.expectedXAddr);
        this.wsDiscoveryTargetService.setXAddrs(this.expectedXAddrs);
        this.reqResServer = (RequestResponseServer)this.getInjector().getInstance(RequestResponseServer.class);
        this.reqResServer.register((Interceptor)this.wsDiscoveryTargetService);
        ((JaxbMarshalling)this.getInjector().getInstance(JaxbMarshalling.class)).startAsync().awaitRunning();
        this.unmarshaller = (SoapMarshalling)this.getInjector().getInstance(SoapMarshalling.class);
        this.unmarshaller.startAsync().awaitRunning();
    }

    @Test
    void sendHello() throws Exception {
        UnsignedInteger version1 = this.wsDiscoveryTargetService.getMetadataVersion();
        UnsignedInteger version2 = this.wsDiscoveryTargetService.sendHello();
        Assertions.assertNotEquals((long)version1.longValue(), (long)version2.longValue());
        UnsignedInteger version3 = this.wsDiscoveryTargetService.sendHello();
        Assertions.assertEquals((Object)version2, (Object)version3);
        UnsignedInteger version4 = this.wsDiscoveryTargetService.sendHello(true);
        Assertions.assertNotEquals((Object)version2, (Object)version4);
        Assertions.assertEquals((int)3, (int)this.sentSoapMessages.size());
        this.sentSoapMessages.forEach(message -> {
            Optional body = this.soapUtil.getBody(message, HelloType.class);
            HelloType actualHello = (HelloType)body.orElseThrow(() -> new RuntimeException("SOAP message body malformed"));
            Assertions.assertEquals((int)this.expectedTypes.size(), (int)actualHello.getTypes().size());
            Assertions.assertEquals((Object)this.expectedType, actualHello.getTypes().get(0));
            Assertions.assertEquals((int)this.expectedScopes.size(), (int)actualHello.getScopes().getValue().size());
            Assertions.assertEquals((Object)this.expectedScope, actualHello.getScopes().getValue().get(0));
            Assertions.assertEquals((int)this.expectedXAddrs.size(), (int)actualHello.getXAddrs().size());
            Assertions.assertEquals((Object)this.expectedXAddr, actualHello.getXAddrs().get(0));
        });
    }

    @Test
    void sendBye() throws Exception {
        this.wsDiscoveryTargetService.sendBye();
        Assertions.assertEquals((int)1, (int)this.sentSoapMessages.size());
        Optional body = this.soapUtil.getBody(this.sentSoapMessages.get(0), ByeType.class);
        ByeType actualBye = (ByeType)body.orElseThrow(() -> new RuntimeException("SOAP message body malformed"));
        Assertions.assertEquals((int)this.expectedTypes.size(), (int)actualBye.getTypes().size());
        Assertions.assertEquals((Object)this.expectedType, actualBye.getTypes().get(0));
        Assertions.assertEquals((int)this.expectedScopes.size(), (int)actualBye.getScopes().getValue().size());
        Assertions.assertEquals((Object)this.expectedScope, actualBye.getScopes().getValue().get(0));
        Assertions.assertEquals((int)this.expectedXAddrs.size(), (int)actualBye.getXAddrs().size());
        Assertions.assertEquals((Object)this.expectedXAddr, actualBye.getXAddrs().get(0));
    }

    @Test
    void processProbe() throws Exception {
        Envelope soapEnv = this.unmarshaller.unmarshal(this.getClass().getResourceAsStream("probe-message.xml"));
        SoapMessage probe = this.soapMessageFactory.createSoapMessage(soapEnv);
        SoapMessage response = this.soapUtil.createMessage();
        Assertions.assertEquals((int)0, (int)response.getOriginalEnvelope().getBody().getAny().size());
        this.reqResServer.receiveRequestResponse(probe, response, this.mockCommunicationContext);
        Assertions.assertEquals((int)1, (int)response.getOriginalEnvelope().getBody().getAny().size());
    }

    @Test
    void processResolve() throws Exception {
        Envelope soapEnv = this.unmarshaller.unmarshal(this.getClass().getResourceAsStream("resolve-message.xml"));
        SoapMessage resolve = this.soapMessageFactory.createSoapMessage(soapEnv);
        SoapMessage response = this.soapUtil.createMessage();
        Assertions.assertEquals((int)0, (int)response.getOriginalEnvelope().getBody().getAny().size());
        this.reqResServer.receiveRequestResponse(resolve, response, this.mockCommunicationContext);
        Assertions.assertEquals((int)1, (int)response.getOriginalEnvelope().getBody().getAny().size());
    }
}

