/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap.wsdiscovery;

import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.somda.sdc.dpws.DpwsTest;
import org.somda.sdc.dpws.soap.wsdiscovery.MatchBy;
import org.somda.sdc.dpws.soap.wsdiscovery.WsDiscoveryUtil;

class WsDiscoveryUtilTest
extends DpwsTest {
    private WsDiscoveryUtil wsDiscoveryUtil;
    private static final String DEFAULT_SUPERSET = "http://a.de/abc/d//e";

    WsDiscoveryUtilTest() {
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.wsDiscoveryUtil = (WsDiscoveryUtil)this.getInjector().getInstance(WsDiscoveryUtil.class);
    }

    @Test
    void isScopesMatchingStrcmpRegressionTest() {
        List<String> superset = List.of("http://a.de", "http://b.de");
        List<String> subset = List.of("http://b.de");
        Assertions.assertTrue((boolean)this.wsDiscoveryUtil.isScopesMatching(superset, subset, MatchBy.STRCMP0));
    }

    @Test
    void isScopesMatchingDefaultSupersetRfc3986Test() {
        List<String> matchingSubsets = List.of(DEFAULT_SUPERSET, "HTTP://a.de/abc/d//e", "http://A.dE/abc/d//e", "http://a.de/abc", "http://a.de/abc/d", "http://a.de/abc/d/", "http://a.de/abc/d//", "http://a.de", "http://a.de/abc?a=x&b=y", "http://a.de/abc#fragement1");
        matchingSubsets.forEach(subset -> Assertions.assertTrue((boolean)this.doesMatchDefault((String)subset), (String)String.format("%s did not match %s", subset, DEFAULT_SUPERSET)));
        List<String> notMatchingSubsets = List.of("http://a.de/Abc/d//e", "http%3A%2F%2Fa.de%2Fabc%2Fd%2F%2Fe", "http://a.de/ab", "http://a.de/abc/d//e/f", "http://a.de/abc/./d", "http://a.de/abc/../d");
        notMatchingSubsets.forEach(subset -> Assertions.assertFalse((boolean)this.doesMatchDefault((String)subset), (String)String.format("%s matched %s", subset, DEFAULT_SUPERSET)));
    }

    @Test
    void isScopesMatchingCustomSupersetRfc3986Test() {
        Map<String, String> matchingSubsets = Map.of("https://127.0.0.1:46581", "https://127.0.0.1:46581", "https://127.0.0.1:46581/a/b", "https://127.0.0.1:46581/a", "sdc.mds.pkp:1.2.840.10004.20701.1.1", "sdc.mds.pkp:1.2.840.10004.20701.1.1", "urn:oid:2.5.4.3", "urn:oid:2.5.4.3", "urn:oid", "uRn:oid", "urn:uuid:6e4f8cf7-39a2-48eb-866b-0f92b9d17b97", "urn:uuid:6e4f8cf7-39a2-48eb-866b-0f92b9d17b97", "my-scheme:abc", "my-schemE:abc", "http://a/b", "http://a", "http://f:fifty-two/c", "http://f:fifty-two/c", "non-special://f:999999/c", "NoN-special://f:999999/c");
        matchingSubsets.forEach((superset, subset) -> Assertions.assertTrue((boolean)this.doesMatch((String)superset, (String)subset)));
        Map<String, String> notMatchingSubsets = Map.of("urn:oid", "urs:oid", "http://a.de/abc/./d", "http://a.de/abc/./d", "http://a.de", "http://a.de/a", "https://127.0.0.1:46581", "https://127.0.0.1:465", "sdc.mds.pkp:1.2.840", "sdc.mds.pkp:a.2.840", "sdc.mds.pkp:2.2.840.10004.20701.1.1", "sdc.mds.pkp", "sdc.mds.pkp:a.2.840", "sdc.mds.pkp:A.2.840", "http://user:pass@a.de/abc", "http://a.de/abc", "http://f:fifty-two/c", "http://f:fifty-two/C");
        notMatchingSubsets.forEach((superset, subset) -> Assertions.assertFalse((boolean)this.doesMatch((String)superset, (String)subset)));
    }

    private boolean doesMatchDefault(String subset) {
        return this.doesMatch(DEFAULT_SUPERSET, subset);
    }

    private boolean doesMatch(String superset, String subset) {
        return this.wsDiscoveryUtil.isScopesMatching(List.of(superset), List.of(subset), MatchBy.RFC3986);
    }
}

