/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap.wseventing;

import com.google.inject.Injector;
import java.io.InputStream;
import java.io.OutputStream;
import org.somda.sdc.dpws.http.HttpException;
import org.somda.sdc.dpws.soap.CommunicationContext;
import org.somda.sdc.dpws.soap.MarshallingService;
import org.somda.sdc.dpws.soap.RequestResponseServer;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.SoapUtil;
import org.somda.sdc.dpws.soap.exception.MarshallingException;
import org.somda.sdc.dpws.soap.exception.SoapFaultException;

class MarshallingHelper {
    MarshallingHelper() {
    }

    static void handleRequestResponse(Injector injector, RequestResponseServer srv, InputStream is, OutputStream os, CommunicationContext communicationContext) throws HttpException {
        try {
            SoapMessage responseMessage = ((SoapUtil)injector.getInstance(SoapUtil.class)).createMessage();
            MarshallingService marshallingService = (MarshallingService)injector.getInstance(MarshallingService.class);
            try {
                srv.receiveRequestResponse(marshallingService.unmarshal(is), responseMessage, communicationContext);
            }
            catch (SoapFaultException e) {
                marshallingService.marshal(e.getFaultMessage(), os);
                return;
            }
            marshallingService.marshal(responseMessage, os);
        }
        catch (MarshallingException e) {
            throw new HttpException(500, e.getMessage());
        }
    }
}

