/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.http.jetty;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.eclipse.jetty.server.HttpInput;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.Request;
import org.somda.sdc.dpws.CommunicationLog;
import org.somda.sdc.dpws.CommunicationLogContext;
import org.somda.sdc.dpws.http.jetty.CommunicationLogInputInterceptor;
import org.somda.sdc.dpws.http.jetty.CommunicationLogOutputInterceptor;
import org.somda.sdc.dpws.http.jetty.JettyHttpServerHandler;
import org.somda.sdc.dpws.soap.ApplicationInfo;
import org.somda.sdc.dpws.soap.CommunicationContext;
import org.somda.sdc.dpws.soap.TransportInfo;

public class JettyUtil {
    static ListMultimap<String, String> getRequestHeaders(HttpServletRequest request) {
        ArrayListMultimap requestHeaderMap = ArrayListMultimap.create();
        Iterator nameIter = request.getHeaderNames().asIterator();
        Stream.generate(() -> null).takeWhile(x -> nameIter.hasNext()).map(n -> ((String)nameIter.next()).toLowerCase()).distinct().forEach(arg_0 -> JettyUtil.lambda$getRequestHeaders$4(request, (ListMultimap)requestHeaderMap, arg_0));
        return requestHeaderMap;
    }

    static void handleCommlog(@Nullable CommunicationLog communicationLog, Request baseRequest, HttpServletRequest request, @Nullable CommunicationLogContext communicationLogContext, ApplicationInfo requestHttpApplicationInfo, String frameworkIdentifier, HttpOutput.Interceptor previousInterceptor, HttpOutput out, String transactionId) throws IOException {
        if (communicationLog != null) {
            List<X509Certificate> requestCertificates = JettyHttpServerHandler.getX509Certificates(request, baseRequest.isSecure());
            TransportInfo transportInfo = new TransportInfo(request.getScheme(), request.getLocalAddr(), request.getLocalPort(), request.getRemoteAddr(), request.getRemotePort(), requestCertificates);
            CommunicationContext requestCommContext = new CommunicationContext(requestHttpApplicationInfo, transportInfo, communicationLogContext);
            OutputStream commlogInput = communicationLog.logMessage(CommunicationLog.Direction.INBOUND, CommunicationLog.TransportType.HTTP, CommunicationLog.MessageType.REQUEST, requestCommContext);
            baseRequest.getHttpInput().addInterceptor((HttpInput.Interceptor)new CommunicationLogInputInterceptor(commlogInput, frameworkIdentifier));
            CommunicationLogOutputInterceptor outInterceptor = new CommunicationLogOutputInterceptor(baseRequest.getHttpChannel(), previousInterceptor, communicationLog, communicationLogContext, transportInfo, frameworkIdentifier, transactionId);
            out.setInterceptor((HttpOutput.Interceptor)outInterceptor);
        }
    }

    private static /* synthetic */ void lambda$getRequestHeaders$4(HttpServletRequest request, ListMultimap requestHeaderMap, String headerName) {
        Enumeration headers = request.getHeaders(headerName);
        headers.asIterator().forEachRemaining(header -> requestHeaderMap.put((Object)headerName, header));
    }
}

