/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap;

import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

public class TransportInfo {
    private final String scheme;
    private final String localAddress;
    private final Integer localPort;
    private final String remoteAddress;
    private final Integer remotePort;
    private final List<X509Certificate> x509Certificates;

    public TransportInfo(String scheme, @Nullable String localAddress, @Nullable Integer localPort, @Nullable String remoteAddress, @Nullable Integer remotePort, List<X509Certificate> x509Certificates) {
        this.scheme = scheme;
        this.localAddress = localAddress;
        this.localPort = localPort;
        this.remoteAddress = remoteAddress;
        this.remotePort = remotePort;
        this.x509Certificates = x509Certificates;
    }

    public String getScheme() {
        return this.scheme;
    }

    public Optional<String> getLocalAddress() {
        return Optional.ofNullable(this.localAddress);
    }

    public Optional<Integer> getLocalPort() {
        return Optional.ofNullable(this.localPort);
    }

    public Optional<String> getRemoteAddress() {
        return Optional.ofNullable(this.remoteAddress);
    }

    public Optional<Integer> getRemotePort() {
        return Optional.ofNullable(this.remotePort);
    }

    public List<X509Certificate> getX509Certificates() {
        return this.x509Certificates;
    }

    public String getRemoteNodeInfo() {
        return String.format("%s://%s:%s", this.scheme, this.remoteAddress != null ? this.remoteAddress : "<unknown-addr>", this.remotePort != null ? this.remotePort : "<unknown-port>");
    }
}

