/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.Service;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.common.util.ExecutorWrapperService;
import org.somda.sdc.dpws.DpwsFramework;
import org.somda.sdc.dpws.FrameworkMetadata;
import org.somda.sdc.dpws.guice.AppDelayExecutor;
import org.somda.sdc.dpws.guice.DiscoveryUdpQueue;
import org.somda.sdc.dpws.guice.NetworkJobThreadPool;
import org.somda.sdc.dpws.guice.ResolverThreadPool;
import org.somda.sdc.dpws.guice.WsDiscovery;
import org.somda.sdc.dpws.helper.JaxbMarshalling;
import org.somda.sdc.dpws.http.HttpServerRegistry;
import org.somda.sdc.dpws.http.helper.HttpServerClientSelfTest;
import org.somda.sdc.dpws.soap.SoapMarshalling;
import org.somda.sdc.dpws.udp.UdpBindingService;
import org.somda.sdc.dpws.udp.UdpMessageQueueService;
import org.somda.sdc.dpws.udp.factory.UdpBindingServiceFactory;
import org.somda.sdc.dpws.wsdl.WsdlMarshalling;

public class DpwsFrameworkImpl
extends AbstractIdleService
implements DpwsFramework {
    private static final Logger LOG = LogManager.getLogger(DpwsFrameworkImpl.class);
    private NetworkInterface networkInterface;
    private final Logger instanceLogger;
    private final UdpMessageQueueService udpMessageQueueService;
    private final UdpBindingServiceFactory udpBindingServiceFactory;
    private final FrameworkMetadata metadata;
    private final List<Service> registeredServices;
    private UdpBindingService udpBindingService;
    private final HttpServerClientSelfTest httpServerClientSelfTest;

    @Inject
    DpwsFrameworkImpl(@DiscoveryUdpQueue UdpMessageQueueService udpMessageQueueService, UdpBindingServiceFactory udpBindingServiceFactory, HttpServerRegistry httpServerRegistry, JaxbMarshalling jaxbMarshalling, SoapMarshalling soapMarshalling, WsdlMarshalling wsdlMarshalling, @AppDelayExecutor ExecutorWrapperService<ScheduledExecutorService> appDelayExecutor, @NetworkJobThreadPool ExecutorWrapperService<ListeningExecutorService> networkJobExecutor, @WsDiscovery ExecutorWrapperService<ListeningExecutorService> wsDiscoveryExecutor, @ResolverThreadPool ExecutorWrapperService<ListeningExecutorService> resolveExecutor, FrameworkMetadata metadata, @Named(value="Common.InstanceIdentifier") String frameworkIdentifier, HttpServerClientSelfTest httpServerClientSelfTest) {
        this.instanceLogger = InstanceLogger.wrapLogger((Logger)LOG, (String)frameworkIdentifier);
        this.udpMessageQueueService = udpMessageQueueService;
        this.udpBindingServiceFactory = udpBindingServiceFactory;
        this.metadata = metadata;
        this.registeredServices = new ArrayList<Service>();
        this.registeredServices.addAll(List.of(appDelayExecutor, networkJobExecutor, wsDiscoveryExecutor, resolveExecutor, jaxbMarshalling, soapMarshalling, wsdlMarshalling, httpServerRegistry));
        this.httpServerClientSelfTest = httpServerClientSelfTest;
    }

    protected void startUp() throws SocketException, UnknownHostException {
        this.instanceLogger.info("Start SDCri DPWS framework");
        this.logMetadata();
        if (this.networkInterface == null) {
            this.networkInterface = NetworkInterface.getByInetAddress(InetAddress.getLoopbackAddress());
            this.instanceLogger.info("Initializing dpws framework with loopback interface {}", (Object)this.networkInterface);
        }
        if (this.instanceLogger.isDebugEnabled()) {
            this.printNetworkInterfaceInformation();
        }
        this.configureDiscovery();
        this.registeredServices.addAll(List.of(this.udpBindingService, this.udpMessageQueueService));
        this.registeredServices.forEach(service -> service.startAsync().awaitRunning());
        this.httpServerClientSelfTest.testConnection();
        this.instanceLogger.info("SDCri DPWS framework is ready for use");
    }

    private void printNetworkInterfaceInformation() throws SocketException {
        Iterator<NetworkInterface> networkInterfaceIterator = NetworkInterface.getNetworkInterfaces().asIterator();
        while (networkInterfaceIterator.hasNext()) {
            NetworkInterface netInterface = networkInterfaceIterator.next();
            this.instanceLogger.debug("Found network interface: [{};isUp={};isLoopBack={},supportsMulticast={},MTU={},isVirtual={}]", (Object)netInterface, (Object)netInterface.isUp(), (Object)netInterface.isLoopback(), (Object)netInterface.supportsMulticast(), (Object)netInterface.getMTU(), (Object)netInterface.isVirtual());
            Iterator<InetAddress> inetAddressIterator = netInterface.getInetAddresses().asIterator();
            int i = 0;
            while (inetAddressIterator.hasNext()) {
                this.instanceLogger.debug("{}.address[{}]: {}", (Object)netInterface.getName(), (Object)i++, (Object)inetAddressIterator.next());
            }
        }
    }

    protected void shutDown() {
        this.instanceLogger.info("Shutting down SDCri DPWS framework");
        Lists.reverse(this.registeredServices).forEach(service -> service.stopAsync().awaitTerminated());
        this.instanceLogger.info("SDCri DPWS framework shut down");
    }

    private void configureDiscovery() throws UnknownHostException, SocketException {
        InetAddress wsdMulticastAddress;
        try {
            wsdMulticastAddress = InetAddress.getByName("239.255.255.250");
        }
        catch (UnknownHostException e) {
            this.instanceLogger.warn("WS-Discovery multicast port could not be retrieved as InetAddress: {}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        this.udpBindingService = this.udpBindingServiceFactory.createUdpBindingService(this.networkInterface, wsdMulticastAddress, 3702, 4096);
        this.udpMessageQueueService.setUdpBinding(this.udpBindingService);
        this.udpBindingService.setMessageReceiver(this.udpMessageQueueService);
    }

    @Override
    public void setNetworkInterface(NetworkInterface networkInterface) {
        if (this.isRunning()) {
            this.instanceLogger.warn("Framework is already running, cannot change network interface");
            return;
        }
        this.networkInterface = networkInterface;
    }

    @Override
    public synchronized void registerService(Collection<Service> services) {
        services.forEach(service -> {
            if (!this.registeredServices.contains(service)) {
                this.registeredServices.add((Service)service);
            }
        });
        if (this.isRunning() || this.state() == Service.State.STARTING) {
            services.forEach(service -> {
                if (service.state() == Service.State.NEW) {
                    this.instanceLogger.info("Delayed start of service {}", service);
                    service.startAsync().awaitRunning();
                } else {
                    service.awaitRunning();
                }
            });
        }
    }

    private void logMetadata() {
        this.instanceLogger.info("SDCri version:\t{}", (Object)this.metadata.getFrameworkVersion());
        this.instanceLogger.info("Java vendor:\t\t{}", (Object)this.metadata.getJavaVendor());
        this.instanceLogger.info("Java version:\t{}", (Object)this.metadata.getJavaVersion());
        this.instanceLogger.info("OS version:\t\t{}", (Object)this.metadata.getOsVersion());
    }
}

