/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.crypto;

import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.Nullable;
import org.somda.sdc.dpws.crypto.CachingCryptoSettings;
import org.somda.sdc.dpws.crypto.CryptoSettings;

public class CryptoConfigurator {
    private static final Logger LOG = LogManager.getLogger(CryptoConfigurator.class);

    @Inject
    CryptoConfigurator() {
    }

    public SSLContext createSslContextFromCryptoConfig(CachingCryptoSettings cryptoSettings) throws KeyStoreException, UnrecoverableKeyException, CertificateException, NoSuchAlgorithmException, IOException, KeyManagementException {
        Optional<SSLContext> contextOpt = cryptoSettings.getSslContext();
        if (contextOpt.isPresent()) {
            LOG.debug("Retrieved cached SSLContext");
            return contextOpt.orElseThrow();
        }
        LOG.debug("Creating new SSLContext");
        SSLContext context = CryptoConfigurator.createSslContextFromCryptoConfigInternal(cryptoSettings);
        cryptoSettings.setSslContext(context);
        return context;
    }

    public SSLContext createSslContextFromCryptoConfig(CryptoSettings cryptoSettings) throws KeyStoreException, UnrecoverableKeyException, CertificateException, NoSuchAlgorithmException, IOException, KeyManagementException {
        if (cryptoSettings instanceof CachingCryptoSettings) {
            CachingCryptoSettings cachingCryptoSettings = (CachingCryptoSettings)cryptoSettings;
            return this.createSslContextFromCryptoConfig(cachingCryptoSettings);
        }
        return CryptoConfigurator.createSslContextFromCryptoConfigInternal(cryptoSettings);
    }

    private static SSLContext createSslContextFromCryptoConfigInternal(CryptoSettings cryptoSettings) throws KeyStoreException, UnrecoverableKeyException, CertificateException, NoSuchAlgorithmException, IOException, KeyManagementException {
        SSLContextBuilder sslContextBuilder = SSLContexts.custom();
        Optional<InputStream> keyStoreStreamOpt = cryptoSettings.getKeyStoreStream();
        if (!keyStoreStreamOpt.isPresent()) {
            throw new IOException("Expected key store, but none found");
        }
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(keyStoreStreamOpt.get(), cryptoSettings.getKeyStorePassword().toCharArray());
        sslContextBuilder.loadKeyMaterial(ks, cryptoSettings.getKeyStorePassword().toCharArray());
        Optional<InputStream> trustStoreStreamOpt = cryptoSettings.getTrustStoreStream();
        if (!trustStoreStreamOpt.isPresent()) {
            throw new IOException("Expected trust store, but none found");
        }
        KeyStore ts = KeyStore.getInstance(KeyStore.getDefaultType());
        ts.load(trustStoreStreamOpt.get(), cryptoSettings.getTrustStorePassword().toCharArray());
        sslContextBuilder.loadTrustMaterial(ts, null);
        return sslContextBuilder.build();
    }

    public static List<X509Certificate> getCertificates(@Nullable CryptoSettings cryptoSettings) {
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        if (cryptoSettings == null) {
            return certificates;
        }
        try {
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            Optional<InputStream> keyStoreStreamOpt = cryptoSettings.getKeyStoreStream();
            if (!keyStoreStreamOpt.isPresent()) {
                return certificates;
            }
            ks.load(keyStoreStreamOpt.get(), cryptoSettings.getKeyStorePassword().toCharArray());
            Iterator<String> aliases = ks.aliases().asIterator();
            while (aliases.hasNext()) {
                Certificate cert = ks.getCertificate(aliases.next());
                if (!(cert instanceof X509Certificate)) continue;
                X509Certificate x509Certificate = (X509Certificate)cert;
                certificates.add(x509Certificate);
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            LOG.error("Error retrieving certificates from keystore", (Throwable)e);
        }
        return certificates;
    }

    public static SSLContext createSslContextFromSystemProperties() {
        return SSLContexts.createSystemDefault();
    }
}

