/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.device;

import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.Service;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.inject.name.Named;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.Nullable;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.dpws.DpwsConstants;
import org.somda.sdc.dpws.device.Device;
import org.somda.sdc.dpws.device.DeviceSettings;
import org.somda.sdc.dpws.device.DiscoveryAccess;
import org.somda.sdc.dpws.device.HostingServiceAccess;
import org.somda.sdc.dpws.device.helper.DiscoveryDeviceUdpMessageProcessor;
import org.somda.sdc.dpws.device.helper.RequestResponseServerHttpHandler;
import org.somda.sdc.dpws.device.helper.UriBaseContextPath;
import org.somda.sdc.dpws.device.helper.factory.DeviceHelperFactory;
import org.somda.sdc.dpws.guice.DiscoveryUdpQueue;
import org.somda.sdc.dpws.helper.factory.DpwsHelperFactory;
import org.somda.sdc.dpws.http.HttpServerRegistry;
import org.somda.sdc.dpws.http.HttpUriBuilder;
import org.somda.sdc.dpws.model.ThisDeviceType;
import org.somda.sdc.dpws.model.ThisModelType;
import org.somda.sdc.dpws.network.NetworkInterfaceUtil;
import org.somda.sdc.dpws.service.HostedService;
import org.somda.sdc.dpws.service.HostedServiceInterceptor;
import org.somda.sdc.dpws.service.HostingService;
import org.somda.sdc.dpws.service.factory.HostedServiceFactory;
import org.somda.sdc.dpws.service.factory.HostedServiceInterceptorFactory;
import org.somda.sdc.dpws.service.factory.HostingServiceFactory;
import org.somda.sdc.dpws.soap.NotificationSource;
import org.somda.sdc.dpws.soap.RequestResponseServer;
import org.somda.sdc.dpws.soap.exception.MarshallingException;
import org.somda.sdc.dpws.soap.exception.TransportException;
import org.somda.sdc.dpws.soap.factory.NotificationSourceFactory;
import org.somda.sdc.dpws.soap.interception.InterceptorException;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingUtil;
import org.somda.sdc.dpws.soap.wsaddressing.model.EndpointReferenceType;
import org.somda.sdc.dpws.soap.wsdiscovery.WsDiscoveryTargetService;
import org.somda.sdc.dpws.soap.wsdiscovery.factory.WsDiscoveryTargetServiceFactory;
import org.somda.sdc.dpws.soap.wseventing.EventSourceInterceptorDispatcher;
import org.somda.sdc.dpws.soap.wseventing.SubscriptionManager;
import org.somda.sdc.dpws.soap.wseventing.factory.EventSourceInterceptorDispatcherFactory;
import org.somda.sdc.dpws.udp.UdpMessageQueueService;

public class DeviceImpl
extends AbstractIdleService
implements Device,
Service,
DiscoveryAccess,
HostingServiceAccess {
    private static final Logger LOG = LogManager.getLogger(DeviceImpl.class);
    private final DeviceSettings deviceSettings;
    private final WsDiscoveryTargetServiceFactory targetServiceFactory;
    private final WsAddressingUtil wsaUtil;
    private final NotificationSourceFactory notificationSourceFactory;
    private final DeviceHelperFactory deviceHelperFactory;
    private final DpwsHelperFactory dpwsHelperFactory;
    private final HostingServiceFactory hostingServiceFactory;
    private final HttpServerRegistry httpServerRegistry;
    private final RequestResponseServer wsdRequestResponseInterceptorChain;
    private final UdpMessageQueueService discoveryMessageQueue;
    private final Provider<RequestResponseServerHttpHandler> reqResHandlerProvider;
    private final HostedServiceFactory hostedServiceFactory;
    private final HostedServiceInterceptorFactory hostedServiceInterceptorFactory;
    private final String eprAddress;
    private final EventSourceInterceptorDispatcherFactory eventSourceInterceptorDispatcherFactory;
    private final Logger instanceLogger;
    private final NetworkInterfaceUtil networkInterfaceUtil;
    private final HttpUriBuilder httpUriBuilder;
    private final boolean enableHttps;
    private final boolean enableHttp;
    private final List<HostedService> hostedServicesOnStartup;
    private WsDiscoveryTargetService wsdTargetService;
    private HostingService hostingService;
    private Collection<String> scopesOnStartup;
    private List<QName> typesOnStartup;
    private ThisDeviceType thisDeviceOnStartup;
    private ThisModelType thisModelOnStartup;
    private DiscoveryDeviceUdpMessageProcessor udpMsgProcessor;
    private final List<EventSourceInterceptorDispatcher> eventSourceDispatchers;

    @AssistedInject
    DeviceImpl(@Assisted DeviceSettings deviceSettings, WsDiscoveryTargetServiceFactory targetServiceFactory, WsAddressingUtil wsaUtil, NotificationSourceFactory notificationSourceFactory, DeviceHelperFactory deviceHelperFactory, DpwsHelperFactory dpwsHelperFactory, RequestResponseServer wsdRequestResponseInterceptorChain, HostingServiceFactory hostingServiceFactory, HttpServerRegistry httpServerRegistry, Provider<RequestResponseServerHttpHandler> reqResHandlerProvider, @DiscoveryUdpQueue UdpMessageQueueService discoveryMessageQueue, HostedServiceFactory hostedServiceFactory, HostedServiceInterceptorFactory hostedServiceInterceptorFactory, NetworkInterfaceUtil networkInterfaceUtil, HttpUriBuilder httpUriBuilder, EventSourceInterceptorDispatcherFactory eventSourceInterceptorDispatcherFactory, @Named(value="Dpws.EnableHttps") boolean enableHttps, @Named(value="Dpws.EnableHttp") boolean enableHttp, @Named(value="Common.InstanceIdentifier") String frameworkIdentifier) {
        this.eventSourceInterceptorDispatcherFactory = eventSourceInterceptorDispatcherFactory;
        this.instanceLogger = InstanceLogger.wrapLogger((Logger)LOG, (String)frameworkIdentifier);
        this.deviceSettings = deviceSettings;
        this.targetServiceFactory = targetServiceFactory;
        this.wsaUtil = wsaUtil;
        this.notificationSourceFactory = notificationSourceFactory;
        this.deviceHelperFactory = deviceHelperFactory;
        this.dpwsHelperFactory = dpwsHelperFactory;
        this.hostingServiceFactory = hostingServiceFactory;
        this.httpServerRegistry = httpServerRegistry;
        this.wsdRequestResponseInterceptorChain = wsdRequestResponseInterceptorChain;
        this.discoveryMessageQueue = discoveryMessageQueue;
        this.reqResHandlerProvider = reqResHandlerProvider;
        this.hostedServiceFactory = hostedServiceFactory;
        this.hostedServiceInterceptorFactory = hostedServiceInterceptorFactory;
        this.networkInterfaceUtil = networkInterfaceUtil;
        this.httpUriBuilder = httpUriBuilder;
        this.enableHttps = enableHttps;
        this.enableHttp = enableHttp;
        this.hostedServicesOnStartup = new ArrayList<HostedService>();
        this.eventSourceDispatchers = new ArrayList<EventSourceInterceptorDispatcher>();
        this.eprAddress = wsaUtil.getAddressUri(deviceSettings.getEndpointReference()).orElseThrow(() -> new RuntimeException("No valid endpoint reference found in device deviceSettings"));
    }

    protected void startUp() throws Exception {
        EndpointReferenceType deviceEpr = this.deviceSettings.getEndpointReference();
        this.instanceLogger.info("Start device with EPR address '{}'", (Object)deviceEpr.getAddress().getValue());
        String hostingServerCtxtPath = this.buildContextPathBase(this.eprAddress);
        List actualHostingServiceBindings = this.resolveHostingServiceBindings().stream().map(addr -> this.httpServerRegistry.initHttpServer((String)addr, false)).flatMap(uri -> {
            URI baseUri = URI.create(uri);
            ArrayList<String> resultUris = new ArrayList<String>(2);
            if (this.enableHttps) {
                try {
                    resultUris.add(this.replaceScheme(baseUri, "https"));
                }
                catch (URISyntaxException e) {
                    this.instanceLogger.error("Error while creating https URI", (Throwable)e);
                }
            }
            if (this.enableHttp) {
                try {
                    resultUris.add(this.replaceScheme(baseUri, "http"));
                }
                catch (URISyntaxException e) {
                    this.instanceLogger.error("Error while creating http URI", (Throwable)e);
                }
            }
            return resultUris.stream();
        }).toList();
        NotificationSource wsdNotificationSource = this.notificationSourceFactory.createNotificationSource(this.dpwsHelperFactory.createNotificationSourceUdpCallback(this.discoveryMessageQueue));
        this.wsdTargetService = this.targetServiceFactory.createWsDiscoveryTargetService(deviceEpr, wsdNotificationSource);
        this.wsdTargetService.setXAddrs(actualHostingServiceBindings.stream().map(uriString -> uriString + hostingServerCtxtPath).collect(Collectors.toList()));
        this.wsdRequestResponseInterceptorChain.register(this.wsdTargetService);
        this.udpMsgProcessor = this.deviceHelperFactory.createDiscoveryDeviceUdpMessageProcessor(this.wsdRequestResponseInterceptorChain, this.discoveryMessageQueue);
        this.discoveryMessageQueue.registerUdpMessageQueueObserver(this.udpMsgProcessor);
        RequestResponseServerHttpHandler reqResHandler = (RequestResponseServerHttpHandler)this.reqResHandlerProvider.get();
        actualHostingServiceBindings.forEach(uri -> this.httpServerRegistry.registerContext((String)uri, true, hostingServerCtxtPath, null, null, reqResHandler));
        this.hostingService = this.hostingServiceFactory.createHostingService(this.wsdTargetService);
        reqResHandler.register(this.hostingService);
        reqResHandler.register(this.wsdTargetService);
        this.hostedServicesOnStartup.forEach(this::addHostedServiceToHostingService);
        this.eventSourceDispatchers.forEach(dispatcher -> dispatcher.startAsync().awaitRunning());
        this.hostingService.getHostedServices().forEach(hostedService -> hostedService.getWebService().startAsync().awaitRunning());
        Optional.ofNullable(this.thisDeviceOnStartup).ifPresent(thisDeviceType -> this.hostingService.setThisDevice((ThisDeviceType)thisDeviceType));
        Optional.ofNullable(this.thisModelOnStartup).ifPresent(thisModelType -> this.hostingService.setThisModel((ThisModelType)thisModelType));
        this.wsdTargetService.setTypes(this.appendDpwsType(this.typesOnStartup));
        this.wsdTargetService.setScopes(this.scopesAsStrs(this.scopesOnStartup));
        this.instanceLogger.info("Device {} is running", (Object)this.hostingService);
        this.wsdTargetService.sendHello();
    }

    private List<String> resolveHostingServiceBindings() {
        InetAddress address = this.networkInterfaceUtil.getFirstIpV4Address(this.deviceSettings.getNetworkInterface()).orElseThrow(() -> new RuntimeException(String.format("No required IPv4 address found in configured network interface %s", this.deviceSettings.getNetworkInterface())));
        ArrayList<String> hostingServiceBindings = new ArrayList<String>();
        if (this.enableHttps) {
            hostingServiceBindings.add(this.httpUriBuilder.buildSecuredUri(address.getHostAddress(), 0));
        } else {
            hostingServiceBindings.add(this.httpUriBuilder.buildUri(address.getHostAddress(), 0));
        }
        return hostingServiceBindings;
    }

    protected void shutDown() throws Exception {
        this.instanceLogger.info("Shut down device {}", (Object)this.hostingService);
        this.wsdTargetService.sendBye();
        this.eventSourceDispatchers.forEach(it -> it.stopAsync().awaitTerminated());
        this.hostingService.getHostedServices().forEach(hostedService -> hostedService.getWebService().stopAsync().awaitTerminated());
        this.httpServerRegistry.stopAsync().awaitTerminated();
        this.discoveryMessageQueue.unregisterUdpMessageQueueObserver(this.udpMsgProcessor);
        this.instanceLogger.info("Device {} shut down", (Object)this.hostingService);
    }

    @Override
    public Map<String, SubscriptionManager> getActiveSubscriptions() {
        return this.eventSourceDispatchers.stream().flatMap(source -> source.getActiveSubscriptions().entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public DiscoveryAccess getDiscoveryAccess() {
        return this;
    }

    @Override
    public HostingServiceAccess getHostingServiceAccess() {
        return this;
    }

    @Override
    public String getEprAddress() {
        return this.eprAddress;
    }

    @Override
    public void setTypes(Collection<QName> types) {
        List<QName> typesWithDpwsQName = this.appendDpwsType(types);
        if (this.isRunning()) {
            this.wsdTargetService.setTypes(typesWithDpwsQName);
        } else {
            this.typesOnStartup = typesWithDpwsQName;
        }
    }

    private List<QName> appendDpwsType(@Nullable Collection<QName> types) {
        Collection<QName> copyTypes = types;
        if (copyTypes == null) {
            copyTypes = Collections.emptyList();
        }
        ArrayList<QName> tmpTypes = new ArrayList<QName>(copyTypes.size() + 1);
        if (copyTypes.stream().filter(qName -> qName.equals(DpwsConstants.DEVICE_TYPE)).findAny().isEmpty()) {
            tmpTypes.add(DpwsConstants.DEVICE_TYPE);
        }
        tmpTypes.addAll(copyTypes);
        return tmpTypes;
    }

    @Override
    public void setScopes(Collection<String> scopes) {
        if (this.isRunning()) {
            this.wsdTargetService.setScopes(this.scopesAsStrs(scopes));
        } else {
            this.scopesOnStartup = scopes;
        }
    }

    @Override
    public void sendHello() {
        if (this.isRunning()) {
            try {
                this.wsdTargetService.sendHello(false);
            }
            catch (MarshallingException | TransportException | InterceptorException e) {
                this.instanceLogger.warn("Send Hello failed.", (Throwable)e);
            }
        }
    }

    private List<String> scopesAsStrs(@Nullable Collection<String> scopes) {
        Collection<String> copyScopes = scopes;
        if (copyScopes == null) {
            copyScopes = Collections.emptyList();
        }
        return new ArrayList<String>(copyScopes);
    }

    @Override
    public void setThisDevice(ThisDeviceType thisDevice) {
        if (this.isRunning()) {
            this.hostingService.setThisDevice(thisDevice);
        } else {
            this.thisDeviceOnStartup = thisDevice;
        }
    }

    @Override
    public void setThisModel(ThisModelType thisModel) {
        if (this.isRunning()) {
            this.hostingService.setThisModel(thisModel);
        } else {
            this.thisModelOnStartup = thisModel;
        }
    }

    @Override
    public void addHostedService(HostedService hostedService) {
        if (this.isRunning()) {
            this.addHostedServiceToHostingService(hostedService);
        } else {
            this.hostedServicesOnStartup.add(hostedService);
        }
    }

    private void addHostedServiceToHostingService(HostedService hostedService) {
        HostedService copyHostedService = hostedService;
        EventSourceInterceptorDispatcher dispatcher = this.eventSourceInterceptorDispatcherFactory.create(copyHostedService.getWebService().getEventSources());
        this.eventSourceDispatchers.add(dispatcher);
        RequestResponseServerHttpHandler hsReqResHandler = (RequestResponseServerHttpHandler)this.reqResHandlerProvider.get();
        hsReqResHandler.register(dispatcher);
        String contextPathPart = this.buildContextPathPart(copyHostedService.getType().getServiceId());
        if (copyHostedService.getType().getEndpointReference().isEmpty()) {
            List<String> uris = this.hostingService.getXAddrs().stream().map(uri -> uri + contextPathPart).collect(Collectors.toList());
            copyHostedService = this.hostedServiceFactory.createHostedService(copyHostedService.getType().getServiceId(), copyHostedService.getType().getTypes(), uris, copyHostedService.getWebService(), copyHostedService.getWsdlDocument());
        }
        String contextPath = this.buildContextPathBase(this.hostingService.getEndpointReferenceAddress()) + contextPathPart;
        for (EndpointReferenceType epr : copyHostedService.getType().getEndpointReference()) {
            String uri2 = this.wsaUtil.getAddressUri(epr).orElseThrow(() -> new RuntimeException("Invalid EPR detected when trying to add hosted service"));
            this.httpServerRegistry.registerContext(uri2, true, contextPath, null, null, hsReqResHandler);
        }
        HostedServiceInterceptor hsInterceptor = this.hostedServiceInterceptorFactory.createHostedServiceInterceptor(copyHostedService, this.wsdTargetService);
        hsReqResHandler.register(hsInterceptor);
        hsReqResHandler.register(copyHostedService.getWebService());
        this.hostingService.addHostedService(copyHostedService);
    }

    private String buildContextPathPart(String serviceId) {
        return "/" + serviceId;
    }

    private String buildContextPathBase(String uri) {
        String basePath = new UriBaseContextPath(uri).get();
        return basePath.isEmpty() ? "" : "/" + basePath;
    }

    private String replaceScheme(URI baseUri, String scheme) throws URISyntaxException {
        return new URI(scheme, baseUri.getUserInfo(), baseUri.getHost(), baseUri.getPort(), baseUri.getPath(), baseUri.getQuery(), baseUri.getFragment()).toString();
    }
}

