/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.guice;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.name.Named;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.somda.sdc.common.util.ExecutorWrapperService;
import org.somda.sdc.dpws.CommunicationLog;
import org.somda.sdc.dpws.CommunicationLogDummyImpl;
import org.somda.sdc.dpws.CommunicationLogSink;
import org.somda.sdc.dpws.CommunicationLogSinkImpl;
import org.somda.sdc.dpws.DpwsFramework;
import org.somda.sdc.dpws.DpwsFrameworkImpl;
import org.somda.sdc.dpws.client.Client;
import org.somda.sdc.dpws.client.ClientImpl;
import org.somda.sdc.dpws.client.helper.DiscoveredDeviceResolver;
import org.somda.sdc.dpws.client.helper.DiscoveryClientUdpProcessor;
import org.somda.sdc.dpws.client.helper.HelloByeAndProbeMatchesObserverImpl;
import org.somda.sdc.dpws.client.helper.factory.ClientHelperFactory;
import org.somda.sdc.dpws.device.Device;
import org.somda.sdc.dpws.device.DeviceImpl;
import org.somda.sdc.dpws.device.factory.DeviceFactory;
import org.somda.sdc.dpws.device.helper.DiscoveryDeviceUdpMessageProcessor;
import org.somda.sdc.dpws.device.helper.factory.DeviceHelperFactory;
import org.somda.sdc.dpws.factory.CommunicationLogFactory;
import org.somda.sdc.dpws.factory.TransportBindingFactory;
import org.somda.sdc.dpws.guice.AppDelayExecutor;
import org.somda.sdc.dpws.guice.ClientSpecific;
import org.somda.sdc.dpws.guice.DeviceSpecific;
import org.somda.sdc.dpws.guice.DiscoveryUdpQueue;
import org.somda.sdc.dpws.guice.NetworkJobThreadPool;
import org.somda.sdc.dpws.guice.ResolverThreadPool;
import org.somda.sdc.dpws.guice.WsDiscovery;
import org.somda.sdc.dpws.helper.JaxbMarshalling;
import org.somda.sdc.dpws.helper.NotificationSourceUdpCallback;
import org.somda.sdc.dpws.helper.factory.DpwsHelperFactory;
import org.somda.sdc.dpws.http.HttpServerRegistry;
import org.somda.sdc.dpws.http.apache.ApacheTransportBindingFactoryImpl;
import org.somda.sdc.dpws.http.apache.ClientTransportBindingFactory;
import org.somda.sdc.dpws.http.factory.HttpClientFactory;
import org.somda.sdc.dpws.http.jetty.JettyHttpServerRegistry;
import org.somda.sdc.dpws.http.jetty.factory.JettyHttpServerHandlerFactory;
import org.somda.sdc.dpws.network.LocalAddressResolver;
import org.somda.sdc.dpws.network.LocalAddressResolverImpl;
import org.somda.sdc.dpws.service.HostedService;
import org.somda.sdc.dpws.service.HostedServiceImpl;
import org.somda.sdc.dpws.service.HostedServiceInterceptor;
import org.somda.sdc.dpws.service.HostedServiceProxy;
import org.somda.sdc.dpws.service.HostedServiceProxyImpl;
import org.somda.sdc.dpws.service.HostedServiceTransportBinding;
import org.somda.sdc.dpws.service.HostingService;
import org.somda.sdc.dpws.service.HostingServiceInterceptor;
import org.somda.sdc.dpws.service.HostingServiceProxy;
import org.somda.sdc.dpws.service.HostingServiceProxyImpl;
import org.somda.sdc.dpws.service.factory.HostedServiceFactory;
import org.somda.sdc.dpws.service.factory.HostedServiceInterceptorFactory;
import org.somda.sdc.dpws.service.factory.HostedServiceTransportBindingFactory;
import org.somda.sdc.dpws.service.factory.HostingServiceFactory;
import org.somda.sdc.dpws.soap.JaxbSoapMarshalling;
import org.somda.sdc.dpws.soap.NotificationSink;
import org.somda.sdc.dpws.soap.NotificationSinkImpl;
import org.somda.sdc.dpws.soap.NotificationSource;
import org.somda.sdc.dpws.soap.NotificationSourceImpl;
import org.somda.sdc.dpws.soap.RequestResponseClient;
import org.somda.sdc.dpws.soap.RequestResponseClientImpl;
import org.somda.sdc.dpws.soap.RequestResponseServer;
import org.somda.sdc.dpws.soap.RequestResponseServerImpl;
import org.somda.sdc.dpws.soap.SoapMarshalling;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.factory.NotificationSinkFactory;
import org.somda.sdc.dpws.soap.factory.NotificationSourceFactory;
import org.somda.sdc.dpws.soap.factory.RequestResponseClientFactory;
import org.somda.sdc.dpws.soap.factory.SoapMessageFactory;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingClientInterceptor;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingServerInterceptor;
import org.somda.sdc.dpws.soap.wsdiscovery.WsDiscoveryClient;
import org.somda.sdc.dpws.soap.wsdiscovery.WsDiscoveryClientInterceptor;
import org.somda.sdc.dpws.soap.wsdiscovery.WsDiscoveryTargetService;
import org.somda.sdc.dpws.soap.wsdiscovery.WsDiscoveryTargetServiceInterceptor;
import org.somda.sdc.dpws.soap.wsdiscovery.factory.WsDiscoveryClientFactory;
import org.somda.sdc.dpws.soap.wsdiscovery.factory.WsDiscoveryTargetServiceFactory;
import org.somda.sdc.dpws.soap.wseventing.EventSink;
import org.somda.sdc.dpws.soap.wseventing.EventSinkImpl;
import org.somda.sdc.dpws.soap.wseventing.EventSourceInterceptorDispatcher;
import org.somda.sdc.dpws.soap.wseventing.GenericEventSource;
import org.somda.sdc.dpws.soap.wseventing.SinkSubscriptionManager;
import org.somda.sdc.dpws.soap.wseventing.SinkSubscriptionManagerImpl;
import org.somda.sdc.dpws.soap.wseventing.SourceSubscriptionManager;
import org.somda.sdc.dpws.soap.wseventing.SourceSubscriptionManagerImpl;
import org.somda.sdc.dpws.soap.wseventing.factory.EventSourceInterceptorDispatcherFactory;
import org.somda.sdc.dpws.soap.wseventing.factory.GenericEventSourceInterceptorFactory;
import org.somda.sdc.dpws.soap.wseventing.factory.SubscriptionManagerFactory;
import org.somda.sdc.dpws.soap.wseventing.factory.SubscriptionRegistryFactory;
import org.somda.sdc.dpws.soap.wseventing.factory.WsEventingEventSinkFactory;
import org.somda.sdc.dpws.soap.wseventing.helper.SubscriptionRegistry;
import org.somda.sdc.dpws.soap.wsmetadataexchange.GetMetadataClient;
import org.somda.sdc.dpws.soap.wsmetadataexchange.GetMetadataClientImpl;
import org.somda.sdc.dpws.soap.wstransfer.TransferGetClient;
import org.somda.sdc.dpws.soap.wstransfer.TransferGetClientImpl;
import org.somda.sdc.dpws.udp.UdpBindingService;
import org.somda.sdc.dpws.udp.UdpBindingServiceImpl;
import org.somda.sdc.dpws.udp.UdpMessageQueueService;
import org.somda.sdc.dpws.udp.UdpMessageQueueServiceImpl;
import org.somda.sdc.dpws.udp.factory.UdpBindingServiceFactory;
import org.somda.sdc.dpws.wsdl.JaxbWsdlMarshalling;
import org.somda.sdc.dpws.wsdl.WsdlMarshalling;

public class DefaultDpwsModule
extends AbstractModule {
    private ExecutorWrapperService<ScheduledExecutorService> appDelayExecutor = null;
    private ExecutorWrapperService<ListeningExecutorService> networkJobThreadPoolExecutor = null;
    private ExecutorWrapperService<ListeningExecutorService> wsDiscoveryExecutor = null;
    private ExecutorWrapperService<ListeningExecutorService> resolveExecutor = null;

    protected void configure() {
        this.configureMarshalling();
        this.configureUdp();
        this.configureHttpServer();
        this.configureSoapEngine();
        this.configureWsAddressing();
        this.configureWsDiscovery();
        this.configureWsEventing();
        this.configureWsMetadataExchange();
        this.configureWsTransfer();
        this.configureDevice();
        this.configureClient();
        this.configureService();
        this.install(new FactoryModuleBuilder().implement(NotificationSourceUdpCallback.class, NotificationSourceUdpCallback.class).build(DpwsHelperFactory.class));
        this.bind(DpwsFramework.class).to(DpwsFrameworkImpl.class).in(Singleton.class);
        this.bind(TransportBindingFactory.class).to(ApacheTransportBindingFactoryImpl.class).asEagerSingleton();
        this.bind(HttpClientFactory.class).to(ApacheTransportBindingFactoryImpl.class).asEagerSingleton();
        this.install(new FactoryModuleBuilder().implement(UdpBindingService.class, UdpBindingServiceImpl.class).build(UdpBindingServiceFactory.class));
        this.install(new FactoryModuleBuilder().build(JettyHttpServerHandlerFactory.class));
        this.install(new FactoryModuleBuilder().build(ClientTransportBindingFactory.class));
        this.bind(CommunicationLogSink.class).to(CommunicationLogSinkImpl.class).asEagerSingleton();
        this.install(new FactoryModuleBuilder().implement(CommunicationLog.class, CommunicationLogDummyImpl.class).build(CommunicationLogFactory.class));
    }

    private void configureService() {
        this.install(new FactoryModuleBuilder().implement(HostingService.class, HostingServiceInterceptor.class).implement(HostingServiceProxy.class, HostingServiceProxyImpl.class).build(HostingServiceFactory.class));
        this.install(new FactoryModuleBuilder().implement(HostedService.class, HostedServiceImpl.class).implement(HostedServiceProxy.class, HostedServiceProxyImpl.class).build(HostedServiceFactory.class));
        this.install(new FactoryModuleBuilder().implement(HostedServiceInterceptor.class, HostedServiceInterceptor.class).build(HostedServiceInterceptorFactory.class));
        this.install(new FactoryModuleBuilder().implement(HostedServiceTransportBinding.class, HostedServiceTransportBinding.class).build(HostedServiceTransportBindingFactory.class));
    }

    private void configureClient() {
        this.bind(Client.class).to(ClientImpl.class);
        this.install(new FactoryModuleBuilder().implement(DiscoveryClientUdpProcessor.class, DiscoveryClientUdpProcessor.class).implement(DiscoveredDeviceResolver.class, DiscoveredDeviceResolver.class).implement(HelloByeAndProbeMatchesObserverImpl.class, HelloByeAndProbeMatchesObserverImpl.class).build(ClientHelperFactory.class));
    }

    private void configureDevice() {
        this.install(new FactoryModuleBuilder().implement(DiscoveryDeviceUdpMessageProcessor.class, DiscoveryDeviceUdpMessageProcessor.class).build(DeviceHelperFactory.class));
        this.install(new FactoryModuleBuilder().implement(Device.class, DeviceImpl.class).build(DeviceFactory.class));
    }

    private void configureWsMetadataExchange() {
        this.bind(GetMetadataClient.class).to(GetMetadataClientImpl.class);
    }

    private void configureWsTransfer() {
        this.bind(TransferGetClient.class).to(TransferGetClientImpl.class);
    }

    private void configureMarshalling() {
        this.bind(JaxbMarshalling.class).asEagerSingleton();
        this.bind(SoapMarshalling.class).to(JaxbSoapMarshalling.class).asEagerSingleton();
        this.bind(WsdlMarshalling.class).to(JaxbWsdlMarshalling.class).asEagerSingleton();
    }

    private void configureUdp() {
        this.install(new FactoryModuleBuilder().implement(UdpBindingService.class, UdpBindingServiceImpl.class).build(UdpBindingServiceFactory.class));
    }

    private void configureWsDiscovery() {
        this.bind(UdpMessageQueueService.class).annotatedWith(DiscoveryUdpQueue.class).to(UdpMessageQueueServiceImpl.class).asEagerSingleton();
        this.install(new FactoryModuleBuilder().implement(WsDiscoveryTargetService.class, WsDiscoveryTargetServiceInterceptor.class).build(WsDiscoveryTargetServiceFactory.class));
        this.install(new FactoryModuleBuilder().implement(WsDiscoveryClient.class, WsDiscoveryClientInterceptor.class).build(WsDiscoveryClientFactory.class));
    }

    private void configureSoapEngine() {
        this.bind(RequestResponseServer.class).to(RequestResponseServerImpl.class);
        this.install(new FactoryModuleBuilder().implement(NotificationSink.class, NotificationSinkImpl.class).build(NotificationSinkFactory.class));
        this.install(new FactoryModuleBuilder().implement(SoapMessage.class, SoapMessage.class).build(SoapMessageFactory.class));
        this.install(new FactoryModuleBuilder().implement(RequestResponseClient.class, RequestResponseClientImpl.class).build(RequestResponseClientFactory.class));
        this.install(new FactoryModuleBuilder().implement(NotificationSource.class, NotificationSourceImpl.class).build(NotificationSourceFactory.class));
    }

    private void configureWsAddressing() {
        this.bind(WsAddressingClientInterceptor.class).asEagerSingleton();
        this.bind(WsAddressingServerInterceptor.class).annotatedWith(DeviceSpecific.class).to(WsAddressingServerInterceptor.class).asEagerSingleton();
        this.bind(WsAddressingServerInterceptor.class).annotatedWith(ClientSpecific.class).to(WsAddressingServerInterceptor.class).asEagerSingleton();
    }

    private void configureWsEventing() {
        this.bind(LocalAddressResolver.class).to(LocalAddressResolverImpl.class);
        this.install(new FactoryModuleBuilder().implement(SubscriptionRegistry.class, SubscriptionRegistry.class).build(SubscriptionRegistryFactory.class));
        this.install(new FactoryModuleBuilder().implement(EventSourceInterceptorDispatcher.class, EventSourceInterceptorDispatcher.class).build(EventSourceInterceptorDispatcherFactory.class));
        this.install(new FactoryModuleBuilder().implement(GenericEventSource.class, GenericEventSource.class).build(GenericEventSourceInterceptorFactory.class));
        this.install(new FactoryModuleBuilder().implement(EventSink.class, EventSinkImpl.class).build(WsEventingEventSinkFactory.class));
        this.install(new FactoryModuleBuilder().implement(SourceSubscriptionManager.class, SourceSubscriptionManagerImpl.class).implement(SinkSubscriptionManager.class, SinkSubscriptionManagerImpl.class).build(SubscriptionManagerFactory.class));
    }

    private void configureHttpServer() {
        this.bind(HttpServerRegistry.class).to(JettyHttpServerRegistry.class).asEagerSingleton();
    }

    @Provides
    @AppDelayExecutor
    ExecutorWrapperService<ScheduledExecutorService> getAppDelayExecutor(@Named(value="Common.InstanceIdentifier") String frameworkIdentifier) {
        if (this.appDelayExecutor == null) {
            Callable<ScheduledExecutorService> executor = () -> Executors.newScheduledThreadPool(10, new ThreadFactoryBuilder().setNameFormat("AppDelayExecutor-thread-%d").setDaemon(true).build());
            this.appDelayExecutor = new ExecutorWrapperService(executor, "AppDelayExecutor", frameworkIdentifier);
        }
        return this.appDelayExecutor;
    }

    @Provides
    @NetworkJobThreadPool
    ExecutorWrapperService<ListeningExecutorService> getNetworkJobThreadPool(@Named(value="Common.InstanceIdentifier") String frameworkIdentifier) {
        if (this.networkJobThreadPoolExecutor == null) {
            Callable<ListeningExecutorService> executor = () -> MoreExecutors.listeningDecorator((ExecutorService)new ThreadPoolExecutor(10, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("NetworkJobThreadPool-thread-%d").setDaemon(true).build()));
            this.networkJobThreadPoolExecutor = new ExecutorWrapperService(executor, "NetworkJobThreadPool", frameworkIdentifier);
        }
        return this.networkJobThreadPoolExecutor;
    }

    @Provides
    @WsDiscovery
    ExecutorWrapperService<ListeningExecutorService> getWsDiscoveryExecutor(@Named(value="Common.InstanceIdentifier") String frameworkIdentifier) {
        if (this.wsDiscoveryExecutor == null) {
            Callable<ListeningExecutorService> executor = () -> MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(10, new ThreadFactoryBuilder().setNameFormat("WsDiscovery-thread-%d").setDaemon(true).build()));
            this.wsDiscoveryExecutor = new ExecutorWrapperService(executor, "WsDiscovery", frameworkIdentifier);
        }
        return this.wsDiscoveryExecutor;
    }

    @Provides
    @ResolverThreadPool
    ExecutorWrapperService<ListeningExecutorService> getResolverThreadPool(@Named(value="Common.InstanceIdentifier") String frameworkIdentifier) {
        if (this.resolveExecutor == null) {
            Callable<ListeningExecutorService> executor = () -> MoreExecutors.listeningDecorator((ExecutorService)new ThreadPoolExecutor(10, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("ResolverThreadPool-thread-%d").setDaemon(true).build()));
            this.resolveExecutor = new ExecutorWrapperService(executor, "ResolverThreadPool", frameworkIdentifier);
        }
        return this.resolveExecutor;
    }
}

