/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.helper;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.somda.sdc.dpws.helper.CommunicationLogFileName;
import org.somda.sdc.dpws.helper.CommunicationLogSoapXmlUtils;

public class CommunicationLogFileOutputStream
extends OutputStream {
    private final File targetDirectory;
    private final boolean prettyPrint;
    private final String fileNamePrefix;
    private final ByteArrayOutputStream outputStream;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public CommunicationLogFileOutputStream(File targetDirectory, String fileNamePrefix, boolean prettyPrint) {
        this.fileNamePrefix = fileNamePrefix;
        this.targetDirectory = targetDirectory;
        this.prettyPrint = prettyPrint;
        this.outputStream = new ByteArrayOutputStream();
    }

    @Override
    public void write(int b) {
        this.outputStream.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.outputStream.writeBytes(Arrays.copyOfRange(b, off, off + len));
    }

    @Override
    public void flush() throws IOException {
        this.outputStream.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.closed.getAndSet(true)) {
            return;
        }
        this.outputStream.close();
        byte[] xmlDoc = this.prettyPrint ? CommunicationLogSoapXmlUtils.prettyPrint(this.outputStream.toByteArray()) : this.outputStream.toByteArray();
        String name = CommunicationLogSoapXmlUtils.makeNameElement(xmlDoc);
        Path commLogFile = Path.of(this.targetDirectory.getAbsolutePath(), CommunicationLogFileName.appendSoapSuffix(CommunicationLogFileName.append(this.fileNamePrefix, name)));
        try (FileOutputStream fileOutputStream = new FileOutputStream(commLogFile.toFile());){
            fileOutputStream.write(xmlDoc);
        }
    }
}

