/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.service;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.jspecify.annotations.Nullable;
import org.jvnet.jaxb.lang.CopyTo;
import org.somda.sdc.common.model.ObjectStringifier;
import org.somda.sdc.common.model.Stringified;
import org.somda.sdc.common.util.JaxbCopyingKt;
import org.somda.sdc.dpws.model.ThisDeviceType;
import org.somda.sdc.dpws.model.ThisModelType;
import org.somda.sdc.dpws.service.HostedServiceProxy;
import org.somda.sdc.dpws.service.HostingServiceProxy;
import org.somda.sdc.dpws.soap.RequestResponseClient;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.exception.MarshallingException;
import org.somda.sdc.dpws.soap.exception.SoapFaultException;
import org.somda.sdc.dpws.soap.exception.TransportException;
import org.somda.sdc.dpws.soap.interception.Interceptor;
import org.somda.sdc.dpws.soap.interception.InterceptorException;

public class HostingServiceProxyImpl
implements HostingServiceProxy {
    private final RequestResponseClient requestResponseClient;
    @Stringified
    private final String activeXAddr;
    @Stringified
    private final String endpointReferenceAddress;
    private final List<QName> types;
    private final ThisDeviceType thisDevice;
    private final ThisModelType thisModel;
    private final Map<String, HostedServiceProxy> hostedServices;

    @AssistedInject
    HostingServiceProxyImpl(@Assisted(value="eprAddress") String endpointReferenceAddress, @Assisted List<QName> types, @Assisted @Nullable ThisDeviceType thisDevice, @Assisted @Nullable ThisModelType thisModel, @Assisted Map<String, HostedServiceProxy> hostedServices, @Assisted RequestResponseClient requestResponseClient, @Assisted(value="activeXAddr") String activeXAddr) {
        this.requestResponseClient = requestResponseClient;
        this.activeXAddr = activeXAddr;
        this.hostedServices = new HashMap<String, HostedServiceProxy>(hostedServices);
        this.endpointReferenceAddress = endpointReferenceAddress;
        this.types = this.cloneQNames(types);
        this.thisDevice = thisDevice != null ? (ThisDeviceType)JaxbCopyingKt.copyTyped((CopyTo)thisDevice) : null;
        this.thisModel = thisModel != null ? (ThisModelType)JaxbCopyingKt.copyTyped((CopyTo)thisModel) : null;
    }

    @Override
    public synchronized String getEndpointReferenceAddress() {
        return this.endpointReferenceAddress;
    }

    @Override
    public List<QName> getTypes() {
        return this.cloneQNames(this.types);
    }

    @Override
    public synchronized Optional<ThisModelType> getThisModel() {
        return Optional.ofNullable(this.thisModel != null ? (ThisModelType)JaxbCopyingKt.copyTyped((CopyTo)this.thisModel) : null);
    }

    @Override
    public synchronized Optional<ThisDeviceType> getThisDevice() {
        return Optional.ofNullable(this.thisDevice != null ? (ThisDeviceType)JaxbCopyingKt.copyTyped((CopyTo)this.thisDevice) : null);
    }

    @Override
    public Map<String, HostedServiceProxy> getHostedServices() {
        return Collections.unmodifiableMap(this.hostedServices);
    }

    @Override
    public String getActiveXAddr() {
        return this.activeXAddr;
    }

    @Override
    public RequestResponseClient getRequestResponseClient() {
        return this.requestResponseClient;
    }

    @Override
    public synchronized void register(Interceptor interceptor) {
        this.requestResponseClient.register(interceptor);
    }

    @Override
    public synchronized SoapMessage sendRequestResponse(SoapMessage request) throws SoapFaultException, MarshallingException, TransportException, InterceptorException {
        return this.requestResponseClient.sendRequestResponse(request);
    }

    public String toString() {
        return ObjectStringifier.stringify((Object)this);
    }

    private List<QName> cloneQNames(List<QName> qNames) {
        return qNames.stream().map(qName -> new QName(qName.getNamespaceURI(), qName.getLocalPart(), qName.getPrefix())).collect(Collectors.toList());
    }
}

