/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.service.helper;

import com.google.inject.Inject;
import java.util.List;
import javax.xml.namespace.QName;
import org.somda.sdc.dpws.model.HostServiceType;
import org.somda.sdc.dpws.model.ObjectFactory;
import org.somda.sdc.dpws.model.Relationship;
import org.somda.sdc.dpws.service.HostedService;
import org.somda.sdc.dpws.soap.wsaddressing.model.EndpointReferenceType;
import org.somda.sdc.dpws.soap.wsmetadataexchange.model.MetadataSection;

public class MetadataSectionUtil {
    private final org.somda.sdc.dpws.soap.wsmetadataexchange.model.ObjectFactory mexFactory;
    private final ObjectFactory dpwsFactory;

    @Inject
    MetadataSectionUtil(org.somda.sdc.dpws.soap.wsmetadataexchange.model.ObjectFactory mexFactory, ObjectFactory dpwsFactory) {
        this.mexFactory = mexFactory;
        this.dpwsFactory = dpwsFactory;
    }

    public MetadataSection createRelationship(EndpointReferenceType hostingServiceEpr, List<QName> hostingServiceTypes, List<HostedService> hostedServices) {
        MetadataSection metadataSection = this.mexFactory.createMetadataSection();
        metadataSection.setDialect("http://docs.oasis-open.org/ws-dd/ns/dpws/2009/01/Relationship");
        Relationship relationship = this.dpwsFactory.createRelationship();
        relationship.setType("http://docs.oasis-open.org/ws-dd/ns/dpws/2009/01/host");
        HostServiceType hostServiceType = this.dpwsFactory.createHostServiceType();
        hostServiceType.setEndpointReference(hostingServiceEpr);
        hostServiceType.setTypes(hostingServiceTypes);
        relationship.getAny().add(this.dpwsFactory.createHost(hostServiceType));
        hostedServices.forEach(hostedService -> relationship.getAny().add(this.dpwsFactory.createHosted(hostedService.getType())));
        metadataSection.setAny((Object)relationship);
        return metadataSection;
    }
}

