/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap;

import com.google.inject.Inject;
import jakarta.xml.bind.JAXBException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import org.somda.sdc.dpws.soap.SoapMarshalling;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.SoapUtil;
import org.somda.sdc.dpws.soap.exception.MarshallingException;
import org.somda.sdc.dpws.soap.model.Envelope;

public class MarshallingService {
    private final SoapMarshalling soapMarshalling;
    private final SoapUtil soapUtil;

    @Inject
    MarshallingService(SoapUtil soapUtil, SoapMarshalling soapMarshalling) {
        this.soapUtil = soapUtil;
        this.soapMarshalling = soapMarshalling;
    }

    public void marshal(SoapMessage msg, OutputStream os) throws MarshallingException {
        try {
            this.soapMarshalling.marshal(msg.getEnvelopeWithMappedHeaders(), os);
        }
        catch (JAXBException e) {
            throw new MarshallingException(e);
        }
    }

    public SoapMessage unmarshal(InputStream is) throws MarshallingException {
        try {
            Envelope env = this.soapMarshalling.unmarshal(is);
            return this.soapUtil.createMessage(env);
        }
        catch (Exception e) {
            throw new MarshallingException(e);
        }
    }

    public SoapMessage unmarshal(Reader reader) throws MarshallingException {
        try {
            Envelope env = this.soapMarshalling.unmarshal(reader);
            return this.soapUtil.createMessage(env);
        }
        catch (Exception e) {
            throw new MarshallingException(e);
        }
    }
}

