/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap.wsaddressing;

import com.google.inject.Inject;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.SoapUtil;
import org.somda.sdc.dpws.soap.interception.Direction;
import org.somda.sdc.dpws.soap.interception.Interceptor;
import org.somda.sdc.dpws.soap.interception.MessageInterceptor;
import org.somda.sdc.dpws.soap.interception.NotificationObject;
import org.somda.sdc.dpws.soap.interception.RequestObject;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingUtil;

public class WsAddressingClientInterceptor
implements Interceptor {
    private final WsAddressingUtil wsaUtil;
    private final SoapUtil soapUtil;

    @Inject
    WsAddressingClientInterceptor(WsAddressingUtil wsaUtil, SoapUtil soapUtil) {
        this.wsaUtil = wsaUtil;
        this.soapUtil = soapUtil;
    }

    @MessageInterceptor(direction=Direction.REQUEST)
    void processMessage(RequestObject rInfo) {
        this.processMessage(rInfo.getRequest());
    }

    @MessageInterceptor(direction=Direction.NOTIFICATION)
    void processMessage(NotificationObject nInfo) {
        this.processMessage(nInfo.getNotification());
    }

    private void processMessage(SoapMessage msg) {
        this.processMessageId(msg);
    }

    private void processMessageId(SoapMessage msg) {
        if (msg.getWsAddressingHeader().getMessageId().isEmpty()) {
            msg.getWsAddressingHeader().setMessageId(this.wsaUtil.createAttributedURIType(this.soapUtil.createRandomUuidUri()));
        }
    }
}

