/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.udp;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.somda.sdc.dpws.soap.ApplicationInfo;
import org.somda.sdc.dpws.soap.CommunicationContext;
import org.somda.sdc.dpws.soap.TransportInfo;

public class UdpMessage {
    private final int length;
    private final byte[] data;
    private final CommunicationContext communicationContext;

    public UdpMessage(byte[] data, int length, CommunicationContext communicationContext) {
        this.data = data;
        this.length = length;
        this.communicationContext = communicationContext;
    }

    public UdpMessage(byte[] data, int length) {
        this.data = data;
        this.length = length;
        this.communicationContext = new CommunicationContext(new ApplicationInfo(), new TransportInfo("soap.udp", null, null, null, null, Collections.emptyList()), null);
    }

    public boolean hasTransportData() {
        return this.getHost() != null && this.getPort() != null;
    }

    public Integer getPort() {
        return this.communicationContext.getTransportInfo().getRemotePort().orElse(null);
    }

    public String getHost() {
        return this.communicationContext.getTransportInfo().getRemoteAddress().orElse(null);
    }

    public int getLength() {
        return this.length;
    }

    public byte[] getData() {
        return this.data;
    }

    public CommunicationContext getCommunicationContext() {
        return this.communicationContext;
    }

    public String toString() {
        return new String(this.data, 0, this.length, StandardCharsets.UTF_8);
    }
}

