/*
 * Decompiled with CFR 0.152.
 */
package it.org.somda.sdc.dpws.soap;

import it.org.somda.sdc.dpws.SslMetadata;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Optional;
import javax.net.ssl.HttpsURLConnection;
import org.somda.sdc.dpws.crypto.CryptoSettings;

public class Ssl {
    private static final SslMetadata SSL_METADATA = new SslMetadata();

    public static CryptoSettings setupServer() {
        return Ssl.setup(SSL_METADATA.getServerKeySet());
    }

    public static CryptoSettings setupClient() {
        return Ssl.setup(SSL_METADATA.getClientKeySet());
    }

    public static X509Certificate getServerCertificate() {
        return SSL_METADATA.getServerKeySet().getCertificate();
    }

    public static X509Certificate getClientCertificate() {
        return SSL_METADATA.getClientKeySet().getCertificate();
    }

    private static CryptoSettings setup(final SslMetadata.KeySet keySet) {
        byte[] keyStoreBytes = null;
        byte[] trustStoreBytes = null;
        try {
            keyStoreBytes = Ssl.convertToByteArray(keySet.getKeyStore(), keySet.getKeyStorePassword());
            trustStoreBytes = Ssl.convertToByteArray(keySet.getTrustStore(), keySet.getTrustStorePassword());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        final byte[] finalKeyStoreBytes = keyStoreBytes;
        final byte[] finalTrustStoreBytes = trustStoreBytes;
        return new CryptoSettings(){

            public Optional<InputStream> getKeyStoreStream() {
                if (finalKeyStoreBytes == null) {
                    return Optional.empty();
                }
                return Optional.of(new ByteArrayInputStream(finalKeyStoreBytes));
            }

            public String getKeyStorePassword() {
                return keySet.getKeyStorePassword();
            }

            public Optional<InputStream> getTrustStoreStream() {
                if (finalTrustStoreBytes == null) {
                    return Optional.empty();
                }
                return Optional.of(new ByteArrayInputStream(finalTrustStoreBytes));
            }

            public String getTrustStorePassword() {
                return keySet.getTrustStorePassword();
            }
        };
    }

    private static byte[] convertToByteArray(KeyStore keyStore, String password) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        keyStore.store(bos, password.toCharArray());
        return bos.toByteArray();
    }

    static {
        SSL_METADATA.startAsync().awaitRunning();
        HttpsURLConnection.setDefaultHostnameVerifier((hostname, session) -> true);
    }
}

