/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.common.logging.InstanceLogger;

@Singleton
public class FrameworkMetadata {
    private static final Logger LOG = LogManager.getLogger(FrameworkMetadata.class);
    private final Logger instanceLogger;
    private final String frameworkVersion;
    private final String javaVersion;
    private final String javaVendor;
    private final String osVersion;

    @Inject
    FrameworkMetadata(@Named(value="Common.InstanceIdentifier") String frameworkIdentifier) {
        this.instanceLogger = InstanceLogger.wrapLogger((Logger)LOG, (String)frameworkIdentifier);
        String implementationVersion = this.getClass().getPackage().getImplementationVersion();
        this.frameworkVersion = implementationVersion != null ? implementationVersion : "DEVELOPMENT VERSION" + this.determineGitRevision();
        this.javaVersion = System.getProperty("java.version");
        this.javaVendor = System.getProperty("java.vendor");
        this.osVersion = System.getProperty("os.name");
    }

    public String getFrameworkVersion() {
        return this.frameworkVersion;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public String getJavaVendor() {
        return this.javaVendor;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    private String determineGitRevision() {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command("git", "rev-parse", "HEAD");
        try {
            Process process = processBuilder.start();
            StringBuilder output = this.readProcessOutput(process);
            int exitVal = process.waitFor();
            if (exitVal == 0) {
                return " " + String.valueOf(output);
            }
            this.instanceLogger.error("Could not call git to determine revision, exit code was {}", (Object)exitVal);
        }
        catch (IOException | InterruptedException e) {
            this.instanceLogger.error("Could not call git to determine revision", (Throwable)e);
        }
        return " unknown revision";
    }

    private StringBuilder readProcessOutput(Process process) throws IOException {
        StringBuilder output = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                output.append(line);
            }
            StringBuilder stringBuilder = output;
            return stringBuilder;
        }
    }
}

