/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.http.apache;

import java.io.IOException;
import java.net.InetSocketAddress;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.http.HttpHost;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.protocol.HttpContext;
import org.jetbrains.annotations.NotNull;
import org.somda.sdc.dpws.http.HttpConnectionInterceptor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/somda/sdc/dpws/http/apache/CustomHttpRetryHandler;", "Lorg/apache/http/impl/client/DefaultHttpRequestRetryHandler;", "retries", "", "retryNonIdempotent", "", "httpConnectionInterceptor", "Lorg/somda/sdc/dpws/http/HttpConnectionInterceptor;", "(IZLorg/somda/sdc/dpws/http/HttpConnectionInterceptor;)V", "retryRequest", "exception", "Ljava/io/IOException;", "executionCount", "context", "Lorg/apache/http/protocol/HttpContext;", "dpws"})
public final class CustomHttpRetryHandler
extends DefaultHttpRequestRetryHandler {
    @NotNull
    private final HttpConnectionInterceptor httpConnectionInterceptor;

    public CustomHttpRetryHandler(int retries, boolean retryNonIdempotent, @NotNull HttpConnectionInterceptor httpConnectionInterceptor) {
        Intrinsics.checkNotNullParameter((Object)httpConnectionInterceptor, (String)"httpConnectionInterceptor");
        super(retries, retryNonIdempotent);
        this.httpConnectionInterceptor = httpConnectionInterceptor;
    }

    public boolean retryRequest(@NotNull IOException exception, int executionCount, @NotNull HttpContext context) {
        InetSocketAddress inetSocketAddress;
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
        HttpHost httpHost = clientContext.getTargetHost();
        if (httpHost != null) {
            HttpHost it = httpHost;
            boolean bl = false;
            inetSocketAddress = new InetSocketAddress(it.getAddress(), it.getPort());
        } else {
            inetSocketAddress = null;
        }
        InetSocketAddress peerAddress = inetSocketAddress;
        this.httpConnectionInterceptor.onClientRequestFailure(exception, peerAddress, executionCount);
        return super.retryRequest(exception, executionCount, context);
    }
}

