/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.http.apache;

import com.google.common.util.concurrent.AbstractIdleService;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.lang.ref.WeakReference;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlin.time.TimeSource;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.apache.logging.log4j.kotlin.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.somda.sdc.dpws.guice.DaemonTimer;
import org.somda.sdc.dpws.http.apache.PoolCleaner;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Singleton
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB%\b\u0001\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bJ\u001a\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0014\u0010\u0015J\b\u0010\u0016\u001a\u00020\u000fH\u0002J\"\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u000fH\u0014J\b\u0010\u001c\u001a\u00020\u000fH\u0014R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u001e"}, d2={"Lorg/somda/sdc/dpws/http/apache/PoolCleaner;", "Lcom/google/common/util/concurrent/AbstractIdleService;", "poolIdleTimeout", "Ljava/time/Duration;", "cleanupPeriod", "timer", "Ljava/util/Timer;", "(Ljava/time/Duration;Ljava/time/Duration;Ljava/util/Timer;)V", "knownPools", "", "Ljava/lang/ref/WeakReference;", "Lorg/apache/http/conn/HttpClientConnectionManager;", "timerTask", "Ljava/util/TimerTask;", "addPool", "", "pool", "clean", "idleTimeout", "Lkotlin/time/Duration;", "clean-LRDsOJo", "(J)V", "cleanDeadPools", "scheduledClean", "period", "scheduledClean-QTBD994", "(JJ)V", "shutDown", "startUp", "Companion", "dpws"})
@SourceDebugExtension(value={"SMAP\nPoolCleaner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PoolCleaner.kt\norg/somda/sdc/dpws/http/apache/PoolCleaner\n+ 2 measureTime.kt\nkotlin/time/MeasureTimeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n18#2,4:91\n50#2,6:95\n56#2:103\n1855#3,2:101\n*S KotlinDebug\n*F\n+ 1 PoolCleaner.kt\norg/somda/sdc/dpws/http/apache/PoolCleaner\n*L\n66#1:91,4\n66#1:95,6\n66#1:103\n71#1:101,2\n*E\n"})
public final class PoolCleaner
extends AbstractIdleService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final java.time.Duration poolIdleTimeout;
    @NotNull
    private final java.time.Duration cleanupPeriod;
    @NotNull
    private final Timer timer;
    @NotNull
    private final Set<WeakReference<HttpClientConnectionManager>> knownPools;
    private TimerTask timerTask;

    @Inject
    public PoolCleaner(@Named(value="Dpws.HttpClientPoolIdleTimeout") @NotNull java.time.Duration poolIdleTimeout, @Named(value="Dpws.HttpClientPoolCleanupPeriod") @NotNull java.time.Duration cleanupPeriod, @DaemonTimer @NotNull Timer timer) {
        Intrinsics.checkNotNullParameter((Object)poolIdleTimeout, (String)"poolIdleTimeout");
        Intrinsics.checkNotNullParameter((Object)cleanupPeriod, (String)"cleanupPeriod");
        Intrinsics.checkNotNullParameter((Object)timer, (String)"timer");
        this.poolIdleTimeout = poolIdleTimeout;
        this.cleanupPeriod = cleanupPeriod;
        this.timer = timer;
        this.knownPools = new LinkedHashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPool(@NotNull HttpClientConnectionManager pool) {
        Intrinsics.checkNotNullParameter((Object)pool, (String)"pool");
        PoolCleaner poolCleaner = this;
        synchronized (poolCleaner) {
            boolean bl = false;
            boolean bl2 = this.knownPools.add(new WeakReference<HttpClientConnectionManager>(pool));
        }
    }

    protected void startUp() {
        Companion.getLogger().info((Function0)new Function0<Object>(this){
            final /* synthetic */ PoolCleaner this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Starting pool cleaner with a cleanup period of " + PoolCleaner.access$getCleanupPeriod$p(this.this$0) + " and an idle timeout of " + PoolCleaner.access$getPoolIdleTimeout$p(this.this$0) + ".";
            }
        });
        java.time.Duration duration = this.cleanupPeriod;
        long l = Duration.plus-LRDsOJo((long)DurationKt.toDuration((long)duration.getSeconds(), (DurationUnit)DurationUnit.SECONDS), (long)DurationKt.toDuration((int)duration.getNano(), (DurationUnit)DurationUnit.NANOSECONDS));
        duration = this.poolIdleTimeout;
        this.scheduledClean-QTBD994(l, Duration.plus-LRDsOJo((long)DurationKt.toDuration((long)duration.getSeconds(), (DurationUnit)DurationUnit.SECONDS), (long)DurationKt.toDuration((int)duration.getNano(), (DurationUnit)DurationUnit.NANOSECONDS)));
    }

    protected void shutDown() {
        Companion.getLogger().info((Function0)shutDown.1.INSTANCE);
        TimerTask timerTask = this.timerTask;
        if (timerTask == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"timerTask");
            timerTask = null;
        }
        timerTask.cancel();
    }

    private final void scheduledClean-QTBD994(long period, long idleTimeout) {
        Timer timer = this.timer;
        long l = Duration.getInWholeMilliseconds-impl((long)period);
        long l2 = Duration.getInWholeMilliseconds-impl((long)period);
        TimerTask timerTask = new TimerTask(this, idleTimeout){
            final /* synthetic */ PoolCleaner this$0;
            final /* synthetic */ long $idleTimeout$inlined;
            {
                this.this$0 = poolCleaner;
                this.$idleTimeout$inlined = l;
            }

            public void run() {
                TimerTask $this$scheduledClean_QTBD994_u24lambda_u241 = this;
                boolean bl = false;
                PoolCleaner.access$clean-LRDsOJo(this.this$0, this.$idleTimeout$inlined);
            }
        };
        timer.scheduleAtFixedRate(timerTask, l, l2);
        this.timerTask = timerTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void clean-LRDsOJo(long idleTimeout) {
        Companion.getLogger().debug((Function0)clean.1.INSTANCE);
        boolean $i$f$measureTime = false;
        TimeSource.Monotonic $this$measureTime$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTime2 = false;
        long mark$iv$iv = $this$measureTime$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        PoolCleaner poolCleaner = this;
        synchronized (poolCleaner) {
            boolean bl2 = false;
            this.cleanDeadPools();
            Iterable $this$forEach$iv = this.knownPools;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                HttpClientConnectionManager pool;
                WeakReference it = (WeakReference)element$iv;
                boolean bl3 = false;
                if ((HttpClientConnectionManager)it.get() == null) continue;
                boolean bl4 = false;
                pool.closeExpiredConnections();
                pool.closeIdleConnections(Duration.getInWholeMilliseconds-impl((long)idleTimeout), TimeUnit.MILLISECONDS);
            }
            Unit unit = Unit.INSTANCE;
        }
        long elapsed = TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv);
        Companion.getLogger().debug((Function0)new Function0<Object>(elapsed){
            final /* synthetic */ long $elapsed;
            {
                this.$elapsed = $elapsed;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Pool cleaning took '" + Duration.toString-impl((long)this.$elapsed) + "'.";
            }
        });
    }

    private final void cleanDeadPools() {
        this.knownPools.removeIf(arg_0 -> PoolCleaner.cleanDeadPools$lambda$6(cleanDeadPools.1.INSTANCE, arg_0));
    }

    private static final boolean cleanDeadPools$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ java.time.Duration access$getCleanupPeriod$p(PoolCleaner $this) {
        return $this.cleanupPeriod;
    }

    public static final /* synthetic */ java.time.Duration access$getPoolIdleTimeout$p(PoolCleaner $this) {
        return $this.poolIdleTimeout;
    }

    public static final /* synthetic */ void access$clean-LRDsOJo(PoolCleaner $this, long idleTimeout) {
        $this.clean-LRDsOJo(idleTimeout);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/somda/sdc/dpws/http/apache/PoolCleaner$Companion;", "Lorg/apache/logging/log4j/kotlin/Logging;", "()V", "dpws"})
    public static final class Companion
    implements Logging {
        private Companion() {
        }

        @NotNull
        public KotlinLogger getLogger() {
            return Logging.DefaultImpls.getLogger((Logging)this);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

