/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.http.jetty;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.jspecify.annotations.Nullable;
import org.somda.sdc.dpws.CommunicationLog;
import org.somda.sdc.dpws.http.jetty.JettyUtil;
import org.somda.sdc.dpws.soap.HttpApplicationInfo;

public class CommunicationLogHandlerWrapper
extends HandlerWrapper {
    private static final String TRANSACTION_ID_PREFIX_SERVER = "rrId:server:" + String.valueOf(UUID.randomUUID()) + ":";
    private static final AtomicLong TRANSACTION_ID = new AtomicLong(-1L);
    private final @Nullable CommunicationLog commLog;
    private final String frameworkIdentifier;

    CommunicationLogHandlerWrapper(@Nullable CommunicationLog commLog, String frameworkIdentifier) {
        this.frameworkIdentifier = frameworkIdentifier;
        this.commLog = commLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String currentTransactionId = TRANSACTION_ID_PREFIX_SERVER + TRANSACTION_ID.incrementAndGet();
        baseRequest.setAttribute(CommunicationLog.MessageType.REQUEST.name(), (Object)currentTransactionId);
        HttpOutput out = baseRequest.getResponse().getHttpOutput();
        HttpOutput.Interceptor previousInterceptor = out.getInterceptor();
        HttpApplicationInfo requestHttpApplicationInfo = new HttpApplicationInfo(JettyUtil.getRequestHeaders(request), currentTransactionId, baseRequest.getRequestURI());
        JettyUtil.handleCommlog(this.commLog, baseRequest, request, null, requestHttpApplicationInfo, this.frameworkIdentifier, previousInterceptor, out, currentTransactionId);
        try {
            super.handle(target, baseRequest, request, response);
        }
        finally {
            if (!baseRequest.isHandled() && !baseRequest.isAsyncStarted() && this.commLog != null) {
                out.setInterceptor(previousInterceptor);
            }
        }
    }
}

