/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.service;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.time.Duration;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.jvnet.jaxb.lang.CopyTo;
import org.somda.sdc.common.util.JaxbCopyingKt;
import org.somda.sdc.dpws.guice.ClientSpecific;
import org.somda.sdc.dpws.model.HostedServiceType;
import org.somda.sdc.dpws.service.EventSinkAccess;
import org.somda.sdc.dpws.service.HostedServiceProxy;
import org.somda.sdc.dpws.soap.NotificationSink;
import org.somda.sdc.dpws.soap.RequestResponseClient;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.exception.MarshallingException;
import org.somda.sdc.dpws.soap.exception.SoapFaultException;
import org.somda.sdc.dpws.soap.exception.TransportException;
import org.somda.sdc.dpws.soap.factory.NotificationSinkFactory;
import org.somda.sdc.dpws.soap.interception.Interceptor;
import org.somda.sdc.dpws.soap.interception.InterceptorException;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingServerInterceptor;
import org.somda.sdc.dpws.soap.wseventing.EventSink;
import org.somda.sdc.dpws.soap.wseventing.SubscribeResult;

public class HostedServiceProxyImpl
implements HostedServiceProxy,
EventSinkAccess {
    private final EventSink eventSink;
    private final NotificationSinkFactory notificationSinkFactory;
    private final WsAddressingServerInterceptor wsAddressingServerInterceptor;
    private final HostedServiceType hostedServiceType;
    private final RequestResponseClient requestResponseClient;
    private final String activeEprAddress;

    @AssistedInject
    HostedServiceProxyImpl(@Assisted HostedServiceType hostedServiceType, @Assisted RequestResponseClient requestResponseClient, @Assisted String activeEprAddress, @Assisted EventSink eventSink, NotificationSinkFactory notificationSinkFactory, @ClientSpecific WsAddressingServerInterceptor wsAddressingServerInterceptor) {
        this.eventSink = eventSink;
        this.notificationSinkFactory = notificationSinkFactory;
        this.wsAddressingServerInterceptor = wsAddressingServerInterceptor;
        this.hostedServiceType = (HostedServiceType)JaxbCopyingKt.copyTyped((CopyTo)hostedServiceType);
        this.requestResponseClient = requestResponseClient;
        this.activeEprAddress = activeEprAddress;
    }

    @Override
    public HostedServiceType getType() {
        return (HostedServiceType)JaxbCopyingKt.copyTyped((CopyTo)this.hostedServiceType);
    }

    @Override
    public RequestResponseClient getRequestResponseClient() {
        return this.requestResponseClient;
    }

    @Override
    public EventSinkAccess getEventSinkAccess() {
        return this;
    }

    @Override
    public String getActiveEprAddress() {
        return this.activeEprAddress;
    }

    @Override
    public synchronized void register(Interceptor interceptor) {
        this.requestResponseClient.register(interceptor);
    }

    @Override
    public synchronized SoapMessage sendRequestResponse(SoapMessage request) throws SoapFaultException, MarshallingException, TransportException, InterceptorException {
        return this.requestResponseClient.sendRequestResponse(request);
    }

    @Override
    public ListenableFuture<SubscribeResult> subscribe(List<String> actions, @Nullable Duration expires, Interceptor notificationSink) {
        NotificationSink notifications = this.notificationSinkFactory.createNotificationSink(this.wsAddressingServerInterceptor);
        notifications.register(notificationSink);
        return this.eventSink.subscribe("http://docs.oasis-open.org/ws-dd/ns/dpws/2009/01/Action", List.of(this.implodeUriList(actions)), expires, notifications);
    }

    private String implodeUriList(List<String> actionUris) {
        StringBuilder sb = new StringBuilder();
        actionUris.forEach(s -> {
            sb.append((String)s);
            sb.append(" ");
        });
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    @Override
    public ListenableFuture<SubscribeResult> subscribe(String filterDialect, List<Object> filters, @Nullable Duration expires, Interceptor notificationSink) {
        NotificationSink notifications = this.notificationSinkFactory.createNotificationSink(this.wsAddressingServerInterceptor);
        notifications.register(notificationSink);
        return this.eventSink.subscribe(filterDialect, filters, expires, notifications);
    }

    @Override
    public ListenableFuture<Duration> renew(String subscriptionId, Duration expires) {
        return this.eventSink.renew(subscriptionId, expires);
    }

    @Override
    public ListenableFuture<Duration> getStatus(String subscriptionId) {
        return this.eventSink.getStatus(subscriptionId);
    }

    public ListenableFuture<?> unsubscribe(String subscriptionId) {
        return this.eventSink.unsubscribe(subscriptionId);
    }

    @Override
    public void unsubscribeAll() {
        this.eventSink.unsubscribeAll();
    }
}

