/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap.exception;

import jakarta.xml.bind.JAXBElement;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.model.Fault;
import org.somda.sdc.dpws.soap.model.Reasontext;
import org.somda.sdc.dpws.soap.wsaddressing.model.AttributedURIType;
import org.somda.sdc.dpws.soap.wsaddressing.model.RelatesToType;

public class SoapFaultException
extends Exception {
    private final SoapMessage faultMessage;
    private final Fault fault;

    public SoapFaultException(SoapMessage faultMessage, @Nullable AttributedURIType messageId) {
        this.faultMessage = faultMessage;
        this.fault = (Fault)((JAXBElement)faultMessage.getOriginalEnvelope().getBody().getAny().get(0)).getValue();
        this.setRelatesTo(messageId);
    }

    public SoapFaultException(SoapMessage faultMessage) {
        this(faultMessage, (AttributedURIType)null);
    }

    public SoapFaultException(SoapMessage faultMessage, Throwable throwable, @Nullable AttributedURIType messageId) {
        super(throwable);
        this.faultMessage = faultMessage;
        this.fault = (Fault)((JAXBElement)faultMessage.getOriginalEnvelope().getBody().getAny().get(0)).getValue();
        this.setRelatesTo(messageId);
    }

    public SoapFaultException(SoapMessage faultMessage, Throwable throwable) {
        this(faultMessage, throwable, null);
    }

    private void setRelatesTo(@Nullable AttributedURIType messageId) {
        if (this.faultMessage.getWsAddressingHeader().getRelatesTo().isEmpty()) {
            RelatesToType unspecifiedMessageUri = new RelatesToType();
            if (messageId != null) {
                unspecifiedMessageUri.setValue(messageId.getValue());
            } else {
                unspecifiedMessageUri.setValue("http://www.w3.org/2005/08/addressing/unspecified");
            }
            this.faultMessage.getWsAddressingHeader().setRelatesTo(unspecifiedMessageUri);
        }
    }

    public SoapMessage getFaultMessage() {
        return this.faultMessage;
    }

    public Fault getFault() {
        return this.fault;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getFault().getCode().getValue().toString());
        List text = this.getFault().getReason().getText();
        if (!text.isEmpty()) {
            sb.append(": ");
            sb.append(((Reasontext)text.get(0)).getValue());
        }
        return sb.toString();
    }
}

