/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap.wseventing;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.HashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.wseventing.EventSource;
import org.somda.sdc.dpws.soap.wseventing.EventSourceDialectHandler;
import org.somda.sdc.dpws.soap.wseventing.IndividualSubscriptionHandler;
import org.somda.sdc.dpws.soap.wseventing.SourceSubscriptionManager;
import org.somda.sdc.dpws.soap.wseventing.SubscriptionManager;
import org.somda.sdc.dpws.soap.wseventing.Subscriptions;
import org.somda.sdc.dpws.soap.wseventing.helper.EventSourceUtil;
import org.somda.sdc.dpws.soap.wseventing.helper.SubscriptionRegistry;
import org.somda.sdc.dpws.soap.wseventing.model.Notification;
import org.somda.sdc.dpws.soap.wseventing.model.WsEventingStatus;

public class GenericEventSource
implements EventSource,
EventSourceDialectHandler {
    private Subscriptions subscriptions;
    private final String filterDialect;
    private final EventSourceUtil eventSourceUtil;
    private final IndividualSubscriptionHandler handler;

    @AssistedInject
    GenericEventSource(@Assisted String filterDialect, @Assisted @Nullable IndividualSubscriptionHandler handler, SubscriptionRegistry subscriptions, EventSourceUtil eventSourceUtil) {
        this.filterDialect = filterDialect;
        this.handler = handler;
        this.subscriptions = subscriptions;
        this.eventSourceUtil = eventSourceUtil;
    }

    @AssistedInject
    GenericEventSource(@Assisted String filterDialect, SubscriptionRegistry subscriptions, EventSourceUtil eventSourceUtil) {
        this(filterDialect, null, subscriptions, eventSourceUtil);
    }

    @Override
    public void sendNotification(String action, Object payload) {
        this.subscriptions.getAll().forEach((uri, subscriptionManager) -> {
            SoapMessage notifyTo = this.eventSourceUtil.createForNotifyTo(action, payload, (SourceSubscriptionManager)subscriptionManager);
            subscriptionManager.offerNotification(new Notification(notifyTo));
        });
    }

    @Override
    public void subscriptionEndToAll(WsEventingStatus status) {
        this.subscriptions.getAll().forEach((uri, subscriptionManager) -> subscriptionManager.offerEndTo(status));
    }

    public void sendNotificationFor(String subscriptionId, String action, Object payload) {
        this.subscriptions.get(subscriptionId).ifPresent(subscriptionManager -> {
            SoapMessage notifyTo = this.eventSourceUtil.createForNotifyTo(action, payload, (SourceSubscriptionManager)subscriptionManager);
            subscriptionManager.offerNotification(new Notification(notifyTo));
        });
    }

    public void endSubscriptionFor(String subscriptionId) {
        this.subscriptions.get(subscriptionId).ifPresent(subscriptionManager -> subscriptionManager.offerEndTo(WsEventingStatus.STATUS_SOURCE_CANCELLING));
    }

    @Override
    public Map<String, SubscriptionManager> getActiveSubscriptions() {
        return new HashMap<String, SubscriptionManager>(this.subscriptions.getAll());
    }

    @Override
    public void init(Subscriptions subscriptions) {
        this.subscriptions = subscriptions;
    }

    @Override
    public void subscribe(SourceSubscriptionManager subscriptionManager) {
        if (this.handler != null) {
            this.handler.startStream(subscriptionManager);
        }
    }

    @Override
    public void unsubscribe(SourceSubscriptionManager subscriptionManager) {
        if (this.handler != null) {
            this.handler.endStream(subscriptionManager);
        }
    }

    @Override
    public void setStale(SourceSubscriptionManager subscriptionManager) {
        this.unsubscribe(subscriptionManager);
    }

    @Override
    public String getDialect() {
        return this.filterDialect;
    }
}

