/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap.wseventing;

import com.google.common.util.concurrent.AbstractExecutionThreadService;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.inject.name.Named;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.Nullable;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.dpws.factory.TransportBindingFactory;
import org.somda.sdc.dpws.soap.NotificationSource;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.SoapUtil;
import org.somda.sdc.dpws.soap.factory.NotificationSourceFactory;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingUtil;
import org.somda.sdc.dpws.soap.wsaddressing.model.EndpointReferenceType;
import org.somda.sdc.dpws.soap.wseventing.SourceSubscriptionManager;
import org.somda.sdc.dpws.soap.wseventing.helper.SubscriptionManagerBase;
import org.somda.sdc.dpws.soap.wseventing.model.Notification;
import org.somda.sdc.dpws.soap.wseventing.model.ObjectFactory;
import org.somda.sdc.dpws.soap.wseventing.model.SubscriptionEnd;
import org.somda.sdc.dpws.soap.wseventing.model.WsEventingStatus;

public class SourceSubscriptionManagerImpl
extends AbstractExecutionThreadService
implements SourceSubscriptionManager {
    private static final Logger LOG = LogManager.getLogger(SourceSubscriptionManagerImpl.class);
    private final BlockingQueue<QueueItem> notificationQueue;
    private final SubscriptionManagerBase delegate;
    private final NotificationSourceFactory notificationSourceFactory;
    private final TransportBindingFactory transportBindingFactory;
    private final WsAddressingUtil wsaUtil;
    private final Logger instanceLogger;
    private final ObjectFactory wseFactory;
    private final SoapUtil soapUtil;
    private NotificationSource notifyToSender;
    private NotificationSource endToSender;
    private String subscriptionId;
    private String notifyToUri;
    private final @Nullable String callerId;

    @AssistedInject
    SourceSubscriptionManagerImpl(@Assisted(value="SubscriptionManager") EndpointReferenceType subscriptionManagerEpr, @Assisted Duration expires, @Assisted(value="NotifyTo") EndpointReferenceType notifyTo, @Assisted(value="EndTo") @Nullable EndpointReferenceType endTo, @Assisted(value="SubscriptionId") String subscriptionId, @Assisted(value="Filters") List<Object> filters, @Assisted(value="FilterDialect") String filterDialect, @Assisted(value="callerId") @Nullable String callerId, @Named(value="SoapConfig.NotificationQueueCapacity") Integer notificationQueueCapacity, NotificationSourceFactory notificationSourceFactory, TransportBindingFactory transportBindingFactory, WsAddressingUtil wsaUtil, ObjectFactory wseFactory, SoapUtil soapUtil, @Named(value="Common.InstanceIdentifier") String frameworkIdentifier) {
        this.instanceLogger = InstanceLogger.wrapLogger((Logger)LOG, (String)frameworkIdentifier);
        this.notificationSourceFactory = notificationSourceFactory;
        this.transportBindingFactory = transportBindingFactory;
        this.wsaUtil = wsaUtil;
        this.subscriptionId = UUID.randomUUID().toString();
        this.delegate = new SubscriptionManagerBase(notifyTo, endTo, subscriptionId, expires, subscriptionManagerEpr, filters, filterDialect);
        this.notificationQueue = new ArrayBlockingQueue<QueueItem>(notificationQueueCapacity);
        this.wseFactory = wseFactory;
        this.soapUtil = soapUtil;
        this.notifyToSender = null;
        this.endToSender = null;
        this.notifyToUri = "";
        this.callerId = callerId;
    }

    @Override
    public String getSubscriptionId() {
        return this.delegate.getSubscriptionId();
    }

    @Override
    public Instant getExpiresTimeout() {
        return this.delegate.getExpiresTimeout();
    }

    @Override
    public EndpointReferenceType getNotifyTo() {
        return this.delegate.getNotifyTo();
    }

    @Override
    public Optional<EndpointReferenceType> getEndTo() {
        return this.delegate.getEndTo();
    }

    @Override
    public Duration getExpires() {
        return this.delegate.getExpires();
    }

    @Override
    public EndpointReferenceType getSubscriptionManagerEpr() {
        return this.delegate.getSubscriptionManagerEpr();
    }

    @Override
    public List<Object> getFilters() {
        return this.delegate.getFilters();
    }

    @Override
    public String getFilterDialect() {
        return this.delegate.getFilterDialect();
    }

    @Override
    public void renew(Duration expires) {
        this.delegate.renew(expires);
    }

    @Override
    public Optional<String> getCallerId() {
        return Optional.ofNullable(this.callerId);
    }

    @Override
    public void offerNotification(Notification notification) {
        if (!this.isRunning()) {
            return;
        }
        if (!this.notificationQueue.offer(new NotificationItem(notification))) {
            this.stopAsync().awaitTerminated();
        }
    }

    @Override
    public void offerEndTo(SoapMessage endToMessage) {
        if (!this.isRunning() || this.endToSender == null) {
            return;
        }
        if (!this.notificationQueue.offer(new SubscriptionEndItem(new Notification(endToMessage)))) {
            this.stopAsync().awaitTerminated();
        }
    }

    @Override
    public void offerEndTo(WsEventingStatus status) {
        this.createEndToMessage(status).ifPresent(this::offerEndTo);
    }

    protected void startUp() {
        this.notifyToUri = this.wsaUtil.getAddressUri(this.getNotifyTo()).orElseThrow(() -> new RuntimeException("Invalid notify-to EPR"));
        this.notifyToSender = this.notificationSourceFactory.createNotificationSource(this.transportBindingFactory.createTransportBinding(this.notifyToUri, null));
        if (this.getEndTo().isPresent()) {
            Optional<String> addressUriAsString = this.wsaUtil.getAddressUri(this.getEndTo().get());
            addressUriAsString.ifPresent(s -> {
                this.endToSender = this.notificationSourceFactory.createNotificationSource(this.transportBindingFactory.createTransportBinding((String)s, null));
            });
        }
        this.subscriptionId = this.wsaUtil.getAddressUri(this.delegate.getSubscriptionManagerEpr()).orElseThrow(() -> new NoSuchElementException("Subscription manager id could not be resolved"));
        this.instanceLogger.info("Source subscription manager '{}' started. Start delivering notifications to '{}'", (Object)this.subscriptionId, (Object)this.notifyToUri);
    }

    protected void run() {
        while (this.isRunning()) {
            try {
                NotificationItem subEnd;
                QueueItem queueItem = this.notificationQueue.take();
                if (queueItem instanceof ShutdownItem) break;
                if (queueItem instanceof SubscriptionEndItem) {
                    subEnd = (SubscriptionEndItem)queueItem;
                    this.instanceLogger.info("Source subscription manager '{}' received stop signal and is about to shut down", (Object)this.subscriptionId);
                    this.endToSender.sendNotification(subEnd.getNotification().getPayload());
                    break;
                }
                subEnd = (NotificationItem)queueItem;
                this.instanceLogger.debug("Sending notification to {} - {}", (Object)this.notifyToUri, (Object)subEnd.getNotification().getPayload());
                this.notifyToSender.sendNotification(subEnd.getNotification().getPayload());
            }
            catch (Exception e) {
                this.instanceLogger.info("Source subscription manager '{}' ended unexpectedly", (Object)this.subscriptionId);
                this.instanceLogger.trace("Source subscription manager '{}' ended unexpectedly", (Object)this.subscriptionId, (Object)e);
                break;
            }
        }
    }

    protected void triggerShutdown() {
        this.notificationQueue.clear();
        this.notificationQueue.offer(new ShutdownItem());
        this.instanceLogger.info("Source subscription manager '{}' shut down. Delivery to '{}' stopped.", (Object)this.subscriptionId, (Object)this.notifyToUri);
    }

    private Optional<SoapMessage> createEndToMessage(WsEventingStatus status) {
        return this.getEndTo().map(endTo -> {
            SubscriptionEnd subscriptionEnd = this.wseFactory.createSubscriptionEnd();
            subscriptionEnd.setSubscriptionManager(this.getSubscriptionManagerEpr());
            subscriptionEnd.setStatus(status.getUri());
            SoapMessage msg = this.soapUtil.createMessage("http://schemas.xmlsoap.org/ws/2004/08/eventing/SubscriptionEnd", subscriptionEnd);
            Optional<String> optionalWsaTo = this.wsaUtil.getAddressUri((EndpointReferenceType)endTo);
            optionalWsaTo.ifPresent(wsaTo -> msg.getWsAddressingHeader().setTo(this.wsaUtil.createAttributedURIType((String)wsaTo)));
            return msg;
        });
    }

    private static class NotificationItem
    implements QueueItem {
        private final Notification notification;

        NotificationItem(@Nullable Notification notification) {
            this.notification = notification;
        }

        public Notification getNotification() {
            return this.notification;
        }
    }

    private static class SubscriptionEndItem
    extends NotificationItem {
        SubscriptionEndItem(Notification notification) {
            super(notification);
        }
    }

    private static interface QueueItem {
    }

    private static class ShutdownItem
    implements QueueItem {
        private ShutdownItem() {
        }
    }
}

