/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.EnumMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.dpws.CommunicationLog;
import org.somda.sdc.dpws.CommunicationLogSink;
import org.somda.sdc.dpws.helper.CommunicationLogFileName;
import org.somda.sdc.dpws.helper.CommunicationLogFileOutputStream;
import org.somda.sdc.dpws.soap.ApplicationInfo;
import org.somda.sdc.dpws.soap.CommunicationContext;
import org.somda.sdc.dpws.soap.HttpApplicationInfo;

public class CommunicationLogSinkImpl
implements CommunicationLogSink {
    private static final Logger LOG = LogManager.getLogger(CommunicationLogSinkImpl.class);
    private final Boolean createHttpHeaders;
    private final Boolean createHttpRequestResponseId;
    private final Boolean prettyPrintXml;
    private final Logger instanceLogger;
    private final EnumMap<CommunicationLog.TransportType, File> dirMapping;

    @Inject
    CommunicationLogSinkImpl(@Named(value="Dpws.CommunicationLogSinkDirectory") File logDirectory, @Named(value="Dpws.CommunicationLogWithHttpHeaders") Boolean createHttpHeaders, @Named(value="Dpws.CommunicationLogWithRequestResponseId") Boolean createHttpRequestResponseId, @Named(value="Dpws.CommunicationLogPrettyPrintXml") Boolean prettyPrintXml, @Named(value="Common.InstanceIdentifier") String frameworkIdentifier) {
        this.createHttpRequestResponseId = createHttpRequestResponseId;
        this.prettyPrintXml = prettyPrintXml;
        this.instanceLogger = InstanceLogger.wrapLogger((Logger)LOG, (String)frameworkIdentifier);
        this.createHttpHeaders = createHttpHeaders;
        this.dirMapping = new EnumMap(CommunicationLog.TransportType.class);
        for (CommunicationLog.TransportType transportType : CommunicationLog.TransportType.values()) {
            File subDirFile = new File(logDirectory, transportType.toString());
            if (!subDirFile.exists() && !subDirFile.mkdirs()) {
                this.dirMapping.put(transportType, null);
                this.instanceLogger.warn("Could not create the communication log directory '{}{}{}'", (Object)logDirectory.getAbsolutePath(), (Object)File.separator, (Object)subDirFile.getName());
                continue;
            }
            this.dirMapping.put(transportType, subDirFile);
        }
    }

    @Override
    public OutputStream createTargetStream(CommunicationLog.TransportType transportType, CommunicationLog.Direction direction, CommunicationLog.MessageType messageType, CommunicationContext communicationContext) {
        OutputStream outputStream = OutputStream.nullOutputStream();
        File dir = this.dirMapping.get((Object)transportType);
        if (dir == null) {
            this.instanceLogger.warn("The directory for the given transport type was not configured.");
            return outputStream;
        }
        String fileNamePrefix = CommunicationLogFileName.create(direction.toString(), communicationContext);
        ApplicationInfo applicationInfo = communicationContext.getApplicationInfo();
        if (applicationInfo instanceof HttpApplicationInfo) {
            HttpApplicationInfo appInfo = (HttpApplicationInfo)applicationInfo;
            if (this.createHttpHeaders.booleanValue()) {
                String headerPath = CommunicationLogFileName.appendHttpHeaderSuffix(dir.getAbsolutePath() + File.separator + fileNamePrefix);
                try (BufferedOutputStream headerFile = new BufferedOutputStream(new FileOutputStream(headerPath));){
                    for (Map.Entry entry : appInfo.getHeaders().entries()) {
                        String targetString = entry.getValue() == null ? String.format("%s%n", entry.getKey()) : String.format("%s = %s%n", entry.getKey(), entry.getValue());
                        ((OutputStream)headerFile).write(targetString.getBytes(StandardCharsets.UTF_8));
                    }
                }
                catch (IOException e) {
                    this.instanceLogger.error("Could not write headers to header file {}", (Object)CommunicationLogFileName.appendHttpHeaderSuffix(headerPath));
                }
            }
            if (this.createHttpRequestResponseId.booleanValue()) {
                String requestResponseIdFilePath = dir.getAbsolutePath() + File.separator + CommunicationLogFileName.append(fileNamePrefix, CommunicationLogSinkImpl.validFilenameOfTransactionId(appInfo.getTransactionId()));
                try {
                    if (!new File(requestResponseIdFilePath).createNewFile()) {
                        this.instanceLogger.warn("File {} could not be created as it was existing already", (Object)requestResponseIdFilePath);
                    }
                }
                catch (IOException e) {
                    this.instanceLogger.error("Could not write headers to header file {}", (Object)requestResponseIdFilePath);
                }
            }
        }
        return new CommunicationLogFileOutputStream(dir, fileNamePrefix, this.prettyPrintXml);
    }

    private static String validFilenameOfTransactionId(String transactionId) {
        return transactionId.replace(':', '_');
    }
}

