/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.client.helper;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.inject.name.Named;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.xml.namespace.QName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.dpws.client.DiscoveredDevice;
import org.somda.sdc.dpws.soap.exception.MarshallingException;
import org.somda.sdc.dpws.soap.exception.TransportException;
import org.somda.sdc.dpws.soap.interception.InterceptorException;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingUtil;
import org.somda.sdc.dpws.soap.wsaddressing.model.EndpointReferenceType;
import org.somda.sdc.dpws.soap.wsdiscovery.WsDiscoveryClient;
import org.somda.sdc.dpws.soap.wsdiscovery.event.HelloMessage;
import org.somda.sdc.dpws.soap.wsdiscovery.event.ProbeMatchesMessage;
import org.somda.sdc.dpws.soap.wsdiscovery.model.HelloType;
import org.somda.sdc.dpws.soap.wsdiscovery.model.ProbeMatchType;
import org.somda.sdc.dpws.soap.wsdiscovery.model.ProbeMatchesType;
import org.somda.sdc.dpws.soap.wsdiscovery.model.ResolveMatchesType;

public class DiscoveredDeviceResolver {
    private static final Logger LOG = LogManager.getLogger(DiscoveredDeviceResolver.class);
    private final WsDiscoveryClient wsDiscoveryClient;
    private final Duration maxWaitForResolveMatches;
    private final WsAddressingUtil wsaUtil;
    private final Boolean autoResolve;
    private final Logger instanceLogger;

    @AssistedInject
    DiscoveredDeviceResolver(@Assisted WsDiscoveryClient wsDiscoveryClient, @Named(value="Dpws.Client.MaxWaitForResolveMatches") Duration maxWaitForResolveMatches, @Named(value="Dpws.Client.AutoResolve") Boolean autoResolve, WsAddressingUtil wsaUtil, @Named(value="Common.InstanceIdentifier") String frameworkIdentifier) {
        this.instanceLogger = InstanceLogger.wrapLogger((Logger)LOG, (String)frameworkIdentifier);
        this.wsDiscoveryClient = wsDiscoveryClient;
        this.maxWaitForResolveMatches = maxWaitForResolveMatches;
        this.autoResolve = autoResolve;
        this.wsaUtil = wsaUtil;
    }

    public Optional<DiscoveredDevice> resolve(HelloMessage helloMessage) {
        HelloType hm = (HelloType)helloMessage.getPayload();
        return this.resolve(hm.getEndpointReference(), hm.getTypes(), hm.getScopes().getValue(), hm.getXAddrs(), hm.getMetadataVersion());
    }

    public Optional<DiscoveredDevice> resolve(ProbeMatchesMessage probeMatchesMessage) {
        ProbeMatchesType probe = (ProbeMatchesType)probeMatchesMessage.getPayload();
        if (probe.getProbeMatch().size() != 1) {
            return Optional.empty();
        }
        ProbeMatchType pm = (ProbeMatchType)probe.getProbeMatch().get(0);
        List scopes = Collections.emptyList();
        if (pm.getScopes() != null) {
            scopes = pm.getScopes().getValue();
        }
        return this.resolve(pm.getEndpointReference(), pm.getTypes(), scopes, pm.getXAddrs(), pm.getMetadataVersion());
    }

    private Optional<DiscoveredDevice> resolve(EndpointReferenceType epr, List<QName> types, List<String> scopes, List<String> xAddrs, long metadataVersion) {
        if (this.wsaUtil.getAddressUri(epr).isEmpty()) {
            this.instanceLogger.info("Empty device endpoint reference found. Skip resolve");
            return Optional.empty();
        }
        if (xAddrs.isEmpty() && this.autoResolve.booleanValue()) {
            return this.sendResolve(epr).flatMap(rms -> Optional.ofNullable(rms.getResolveMatch()).map(rm -> this.wsaUtil.getAddressUri(rm.getEndpointReference()).map(uri -> {
                List rmScopes = Collections.emptyList();
                if (rm.getScopes() != null) {
                    rmScopes = rm.getScopes().getValue();
                }
                return Optional.of(new DiscoveredDevice((String)uri, rm.getTypes(), rmScopes, rm.getXAddrs()));
            }).orElse(Optional.empty())).orElse(Optional.empty()));
        }
        return this.wsaUtil.getAddressUri(epr).map(uri -> new DiscoveredDevice((String)uri, types, scopes, xAddrs));
    }

    private Optional<ResolveMatchesType> sendResolve(EndpointReferenceType epr) {
        ListenableFuture<ResolveMatchesType> resolveMatches = null;
        try {
            resolveMatches = this.wsDiscoveryClient.sendResolve(epr);
        }
        catch (MarshallingException e) {
            this.instanceLogger.info("Resolve of '{}' failed due to marshalling exception", (Object)epr, (Object)e.getCause());
        }
        catch (TransportException e) {
            this.instanceLogger.info("Transmission of resolve request to '{}' failed", (Object)epr, (Object)e.getCause());
        }
        catch (InterceptorException e) {
            this.instanceLogger.info(e.getMessage(), (Object)e.getCause(), (Object)e);
        }
        if (resolveMatches != null) {
            try {
                return Optional.ofNullable((ResolveMatchesType)resolveMatches.get(this.maxWaitForResolveMatches.toMillis(), TimeUnit.MILLISECONDS));
            }
            catch (InterruptedException e) {
                this.instanceLogger.info("Resolve of '{}' failed due to thread interruption", (Object)epr, (Object)e.getCause());
            }
            catch (ExecutionException e) {
                this.instanceLogger.info("Resolve of '{}' failed", (Object)epr, (Object)e.getCause());
            }
            catch (TimeoutException e) {
                resolveMatches.cancel(true);
                this.instanceLogger.debug("Did not get resolve answer from '{}' within {} ms", this.wsaUtil.getAddressUri(epr), (Object)this.maxWaitForResolveMatches.toMillis());
            }
        }
        return Optional.empty();
    }
}

