/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.device.helper;

import java.net.URI;
import java.util.Optional;
import org.somda.sdc.dpws.device.helper.SupportedEprUriScheme;

public class UriBaseContextPath {
    private final String basePath;

    public UriBaseContextPath(String uri) {
        this.basePath = this.deriveFrom(uri);
    }

    public String get() {
        return this.basePath;
    }

    private String deriveFrom(String uri) {
        URI parsedUri = URI.create(uri);
        Optional<SupportedEprUriScheme> supportedUriScheme = this.getSupportedScheme(parsedUri.getScheme(), parsedUri.getSchemeSpecificPart());
        if (supportedUriScheme.isEmpty()) {
            return "";
        }
        return switch (supportedUriScheme.get()) {
            case SupportedEprUriScheme.HTTP, SupportedEprUriScheme.HTTPS -> parsedUri.getPath().substring(1);
            case SupportedEprUriScheme.URN_UUID, SupportedEprUriScheme.URN_OID -> parsedUri.getSchemeSpecificPart().substring(supportedUriScheme.get().getSpecificPart().length() + 1);
            default -> "";
        };
    }

    private Optional<SupportedEprUriScheme> getSupportedScheme(String scheme, String schemeSpecificPart) {
        for (SupportedEprUriScheme supportedScheme : SupportedEprUriScheme.values()) {
            if (!supportedScheme.getSchemeName().equalsIgnoreCase(scheme)) continue;
            if (supportedScheme.getSpecificPart().isEmpty()) {
                return Optional.of(supportedScheme);
            }
            if (!schemeSpecificPart.toLowerCase().startsWith(supportedScheme.getSpecificPart())) continue;
            return Optional.of(supportedScheme);
        }
        return Optional.empty();
    }
}

