/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.network;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.net.Socket;
import java.net.URI;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.dpws.network.LocalAddressResolver;

public class LocalAddressResolverImpl
implements LocalAddressResolver {
    private static final Logger LOG = LogManager.getLogger(LocalAddressResolverImpl.class);
    private final Logger instanceLogger;

    @Inject
    LocalAddressResolverImpl(@Named(value="Common.InstanceIdentifier") String frameworkIdentifier) {
        this.instanceLogger = InstanceLogger.wrapLogger((Logger)LOG, (String)frameworkIdentifier);
    }

    @Override
    public Optional<String> getLocalAddress(String remoteUri) {
        Optional<String> optional;
        URI parsedUri = URI.create(remoteUri);
        Socket socket = new Socket(parsedUri.getHost(), parsedUri.getPort());
        try {
            optional = Optional.of(socket.getLocalAddress().getHostAddress());
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                this.instanceLogger.info("Could not access remote URI {} and resolve local address. Reason: {}", (Object)remoteUri, (Object)e.getMessage());
                return Optional.empty();
            }
        }
        socket.close();
        return optional;
    }
}

