/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap;

import jakarta.xml.bind.JAXBElement;
import java.util.Optional;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.wsaddressing.model.AttributedURIType;
import org.somda.sdc.dpws.soap.wsaddressing.model.RelatesToType;

public class SoapDebug {
    public static String get(SoapMessage msg) {
        StringBuilder sb = new StringBuilder();
        sb.append("SoapMsg(");
        SoapDebug.appendAction(sb, msg);
        SoapDebug.appendMsgId(sb, msg);
        SoapDebug.appendMsgType(sb, msg);
        sb.append(")");
        return sb.toString();
    }

    public static String getBrief(SoapMessage msg) {
        StringBuilder sb = new StringBuilder();
        sb.append("SoapMsg(");
        Optional<AttributedURIType> uri = msg.getWsAddressingHeader().getMessageId();
        if (uri.isPresent()) {
            sb.append(uri.get().getValue());
        } else {
            sb.append("<unknown>");
        }
        Optional<RelatesToType> relatesToOptional = msg.getWsAddressingHeader().getRelatesTo();
        relatesToOptional.ifPresent(relatesTo -> sb.append(" --> ").append(relatesTo.getValue()));
        sb.append(")");
        return sb.toString();
    }

    private static void appendAction(StringBuilder sb, SoapMessage msg) {
        msg.getWsAddressingHeader().getAction().ifPresent(uri -> sb.append(String.format("action=[%s];", uri.getValue())));
    }

    private static void appendMsgId(StringBuilder sb, SoapMessage msg) {
        msg.getWsAddressingHeader().getMessageId().ifPresent(uri -> sb.append(String.format("msgId=[%s];", uri.getValue())));
    }

    private static void appendMsgType(StringBuilder sb, SoapMessage msg) {
        if (msg.getOriginalEnvelope().getBody().getAny().size() == 0) {
            sb.append("bodyType=[n/a];");
        } else {
            Object obj = msg.getOriginalEnvelope().getBody().getAny().get(0);
            String name = obj.getClass().getSimpleName();
            if (obj instanceof JAXBElement) {
                JAXBElement jaxbElement = (JAXBElement)obj;
                name = jaxbElement.getName().toString();
            }
            sb.append(String.format("bodyType=[%s];", name));
        }
    }
}

