/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap.wsdiscovery;

import com.google.common.primitives.UnsignedInteger;
import com.google.inject.Inject;
import java.net.URI;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.somda.sdc.dpws.soap.wsdiscovery.MatchBy;
import org.somda.sdc.dpws.soap.wsdiscovery.model.AppSequenceType;
import org.somda.sdc.dpws.soap.wsdiscovery.model.ObjectFactory;

public class WsDiscoveryUtil {
    private final ObjectFactory wsdFactory;
    private final AtomicInteger messageIdCounter;

    @Inject
    WsDiscoveryUtil(ObjectFactory wsdFactory) {
        this.wsdFactory = wsdFactory;
        this.messageIdCounter = new AtomicInteger(0);
    }

    public boolean isTypesMatching(List<QName> superset, List<QName> subset) {
        return this.isMatching(superset, subset, (o1, o2) -> o1.equals(o2) ? 0 : 1);
    }

    public boolean isScopesMatching(List<String> superset, List<String> subset, MatchBy matchBy) {
        return switch (matchBy) {
            default -> throw new IncompatibleClassChangeError();
            case MatchBy.RFC3986 -> this.isMatching(superset, subset, (o1, o2) -> this.uriCompare((String)o1, (String)o2) ? 0 : 1);
            case MatchBy.STRCMP0 -> this.isMatching(superset, subset, (o1, o2) -> o1.equals(o2) ? 0 : 1);
        };
    }

    public AppSequenceType createAppSequence(UnsignedInteger instanceId) {
        UnsignedInteger messageId = UnsignedInteger.valueOf((long)this.messageIdCounter.addAndGet(1));
        AppSequenceType appSequence = this.wsdFactory.createAppSequenceType();
        appSequence.setInstanceId(instanceId.longValue());
        appSequence.setMessageNumber(messageId.longValue());
        return appSequence;
    }

    private <T> boolean isMatching(List<T> superset, List<T> subset, Comparator<T> comp) {
        return superset.size() >= subset.size() && superset.stream().filter(qName1 -> subset.stream().anyMatch(qName2 -> comp.compare(qName1, qName2) == 0)).count() == (long)subset.size();
    }

    private boolean uriCompare(String o1, String o2) {
        String[] subsetSegments;
        URI supersetUri = URI.create(o1);
        URI subsetUri = URI.create(o2);
        Pattern pattern = Pattern.compile("/\\./|/\\.\\./");
        String supersetPath = supersetUri.getPath();
        String subsetPath = subsetUri.getPath();
        if (StringUtils.isNotBlank((CharSequence)supersetPath) && pattern.matcher(supersetPath).find() || StringUtils.isNotBlank((CharSequence)subsetPath) && pattern.matcher(subsetPath).find()) {
            return false;
        }
        if (supersetUri.toString().equals(subsetUri.toString())) {
            return true;
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)supersetUri.getScheme(), (CharSequence)subsetUri.getScheme())) {
            return false;
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)supersetUri.getAuthority(), (CharSequence)subsetUri.getAuthority())) {
            return false;
        }
        String[] supersetSegments = supersetPath != null ? supersetPath.split("/") : new String[]{};
        String[] stringArray = subsetSegments = subsetPath != null ? subsetPath.split("/") : new String[]{};
        if (subsetSegments.length > supersetSegments.length) {
            return false;
        }
        for (int i = 0; i < supersetSegments.length; ++i) {
            if (subsetSegments.length <= i || supersetSegments[i].equals(subsetSegments[i])) continue;
            return false;
        }
        return supersetUri.getAuthority() != null || subsetUri.getAuthority() != null || StringUtils.equals((CharSequence)supersetUri.getSchemeSpecificPart(), (CharSequence)subsetUri.getSchemeSpecificPart());
    }
}

