/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap.wseventing;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.common.util.AutoLock;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.wseventing.EventSource;
import org.somda.sdc.dpws.soap.wseventing.EventSourceDialectHandler;
import org.somda.sdc.dpws.soap.wseventing.SourceSubscriptionManager;
import org.somda.sdc.dpws.soap.wseventing.SubscriptionManager;
import org.somda.sdc.dpws.soap.wseventing.Subscriptions;
import org.somda.sdc.dpws.soap.wseventing.helper.EventSourceUtil;
import org.somda.sdc.dpws.soap.wseventing.model.Notification;
import org.somda.sdc.dpws.soap.wseventing.model.WsEventingStatus;

public class ActionBasedEventSource
extends AbstractIdleService
implements EventSource,
EventSourceDialectHandler {
    private static final Logger LOG = LogManager.getLogger(ActionBasedEventSource.class);
    private Subscriptions subscriptions;
    private final Multimap<String, String> subscribedActionsToSubManIds;
    private final Lock subscribedActionsLock;
    private final EventSourceUtil eventSourceUtil;
    private final Logger instanceLogger;

    @Inject
    ActionBasedEventSource(EventSourceUtil eventSourceUtil, @Named(value="Common.InstanceIdentifier") String frameworkIdentifier) {
        this.eventSourceUtil = eventSourceUtil;
        this.instanceLogger = InstanceLogger.wrapLogger((Logger)LOG, (String)frameworkIdentifier);
        this.subscriptions = new Subscriptions(){};
        this.subscribedActionsToSubManIds = LinkedListMultimap.create();
        this.subscribedActionsLock = new ReentrantLock();
    }

    @Override
    public void sendNotification(String action, Object payload) {
        HashSet affectedSubscriptionIds;
        try (AutoLock ignored = AutoLock.lock((Lock)this.subscribedActionsLock);){
            affectedSubscriptionIds = new HashSet(this.subscribedActionsToSubManIds.get((Object)action));
            if (affectedSubscriptionIds.isEmpty()) {
                this.instanceLogger.debug("SendNotification: no recipient found for action {}", (Object)action);
                return;
            }
        }
        for (String subId : affectedSubscriptionIds) {
            this.subscriptions.get(subId).ifPresent(subscriptionManager -> {
                SoapMessage notifyTo = this.eventSourceUtil.createForNotifyTo(action, payload, (SourceSubscriptionManager)subscriptionManager);
                subscriptionManager.offerNotification(new Notification(notifyTo));
            });
        }
    }

    @Override
    public void subscriptionEndToAll(WsEventingStatus status) {
        this.subscriptions.getAll().forEach((uri, subMan) -> subMan.offerEndTo(status));
    }

    @Override
    public Map<String, SubscriptionManager> getActiveSubscriptions() {
        return new HashMap<String, SubscriptionManager>(this.subscriptions.getAll());
    }

    @Override
    public void init(Subscriptions subscriptions) {
        this.subscriptions = subscriptions;
    }

    @Override
    public void subscribe(SourceSubscriptionManager subscriptionManager) {
        List<String> uris = ActionBasedEventSource.parseUriList(subscriptionManager.getFilters());
        try (AutoLock ignored = AutoLock.lock((Lock)this.subscribedActionsLock);){
            uris.forEach(uri -> this.subscribedActionsToSubManIds.put(uri, (Object)subscriptionManager.getSubscriptionId()));
        }
    }

    @Override
    public void unsubscribe(SourceSubscriptionManager subscriptionManager) {
        try (AutoLock ignored = AutoLock.lock((Lock)this.subscribedActionsLock);){
            HashSet uris = new HashSet(this.subscribedActionsToSubManIds.keySet());
            uris.forEach(uri -> this.subscribedActionsToSubManIds.remove(uri, (Object)subscriptionManager.getSubscriptionId()));
        }
    }

    @Override
    public void setStale(SourceSubscriptionManager subscriptionManager) {
        this.unsubscribe(subscriptionManager);
    }

    @Override
    public String getDialect() {
        return "http://docs.oasis-open.org/ws-dd/ns/dpws/2009/01/Action";
    }

    protected void startUp() {
    }

    protected void shutDown() {
        this.subscriptionEndToAll(WsEventingStatus.STATUS_SOURCE_SHUTTING_DOWN);
    }

    private static List<String> parseUriList(List<Object> filters) {
        ArrayList<String> result = new ArrayList<String>();
        if (filters.size() != 1) {
            return result;
        }
        if (!String.class.isAssignableFrom(filters.get(0).getClass())) {
            return result;
        }
        String listOfAnyUri = (String)filters.get(0);
        result.addAll(Arrays.asList(listOfAnyUri.split("\\s+")));
        return result;
    }
}

