/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap.wseventing.helper;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.jspecify.annotations.Nullable;
import org.somda.sdc.dpws.device.helper.RequestResponseServerHttpHandler;
import org.somda.sdc.dpws.http.HttpServerRegistry;
import org.somda.sdc.dpws.http.HttpUriBuilder;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.SoapUtil;
import org.somda.sdc.dpws.soap.exception.SoapFaultException;
import org.somda.sdc.dpws.soap.interception.Interceptor;
import org.somda.sdc.dpws.soap.interception.RequestResponseObject;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingUtil;
import org.somda.sdc.dpws.soap.wsaddressing.model.AttributedURIType;
import org.somda.sdc.dpws.soap.wsaddressing.model.EndpointReferenceType;
import org.somda.sdc.dpws.soap.wsaddressing.model.ReferenceParametersType;
import org.somda.sdc.dpws.soap.wseventing.SourceSubscriptionManager;
import org.somda.sdc.dpws.soap.wseventing.factory.WsEventingFaultFactory;

public class EventSourceUtil {
    private final HttpServerRegistry httpServerRegistry;
    private final HttpUriBuilder httpUriBuilder;
    private final WsAddressingUtil wsaUtil;
    private final WsEventingFaultFactory faultFactory;
    private final SoapUtil soapUtil;
    private final String subscriptionManagerPath;
    private final Provider<RequestResponseServerHttpHandler> rrServerHttpHandlerProvider;
    private final Duration maxExpires;

    @Inject
    EventSourceUtil(HttpServerRegistry httpServerRegistry, HttpUriBuilder httpUriBuilder, WsAddressingUtil wsaUtil, WsEventingFaultFactory faultFactory, SoapUtil soapUtil, @Named(value="WsEventing.Source.MaxExpires") Duration maxExpires, @Named(value="WsEventing.Source.SubscriptionManagerPath") String subscriptionManagerPath, Provider<RequestResponseServerHttpHandler> rrServerHttpHandlerProvider) {
        this.httpServerRegistry = httpServerRegistry;
        this.httpUriBuilder = httpUriBuilder;
        this.wsaUtil = wsaUtil;
        this.faultFactory = faultFactory;
        this.soapUtil = soapUtil;
        this.subscriptionManagerPath = subscriptionManagerPath;
        this.rrServerHttpHandlerProvider = rrServerHttpHandlerProvider;
        this.maxExpires = maxExpires;
    }

    public EndpointReferenceType createSubscriptionManagerEprAndRegisterHttpHandler(String scheme, String address, Integer port, Interceptor interceptor) {
        String hostPart = this.httpUriBuilder.buildUri(scheme, address, port);
        String contextPath = "/" + String.valueOf(UUID.randomUUID()) + "/" + this.subscriptionManagerPath;
        String eprAddress = hostPart + contextPath;
        RequestResponseServerHttpHandler handler = (RequestResponseServerHttpHandler)this.rrServerHttpHandlerProvider.get();
        handler.register(interceptor);
        this.httpServerRegistry.registerContext(hostPart, true, contextPath, null, null, handler, null);
        return this.wsaUtil.createEprWithAddress(eprAddress);
    }

    public <T> T validateRequestBody(RequestResponseObject rrObj, Class<T> expectedType) throws SoapFaultException {
        List any = rrObj.getRequest().getOriginalEnvelope().getBody().getAny();
        if (any.isEmpty()) {
            throw new SoapFaultException(this.createInvalidMsg(rrObj, "The request body was empty"), rrObj.getRequest().getWsAddressingHeader().getMessageId().orElse(null));
        }
        return this.soapUtil.getBody(rrObj.getRequest(), expectedType).orElseThrow(() -> new SoapFaultException(this.createInvalidMsg(rrObj, String.format("Expected a request body element of type %s, found %s", expectedType.getName(), any.get(0).getClass().getName())), rrObj.getRequest().getWsAddressingHeader().getMessageId().orElse(null)));
    }

    public SoapMessage createInvalidMsg(RequestResponseObject rrObj, String reason) {
        return this.faultFactory.createInvalidMessage(reason, rrObj.getRequest().getOriginalEnvelope());
    }

    public SoapMessage createForNotifyTo(String wsaAction, Object payload, SourceSubscriptionManager subMan) {
        EndpointReferenceType notifyTo = subMan.getNotifyTo();
        String wsaTo = this.wsaUtil.getAddressUri(notifyTo).orElseThrow(() -> new RuntimeException("Could not resolve URI from NotifyTo"));
        ReferenceParametersType referenceParameters = notifyTo.getReferenceParameters();
        return this.soapUtil.createMessage(wsaAction, wsaTo, payload, referenceParameters);
    }

    public Duration grantExpires(@Nullable Duration expires) throws SoapFaultException {
        Duration validatedExpires = this.validateExpires(expires);
        if (validatedExpires != null && this.maxExpires.compareTo(expires) >= 0) {
            return validatedExpires;
        }
        return this.maxExpires;
    }

    private @Nullable Duration validateExpires(@Nullable Duration requestedExpires) throws SoapFaultException {
        if (requestedExpires == null) {
            return null;
        }
        if (requestedExpires.isZero() || requestedExpires.isNegative()) {
            throw new SoapFaultException(this.faultFactory.createInvalidExpirationTime());
        }
        return requestedExpires;
    }

    public SourceSubscriptionManager validateSubscriptionEpr(RequestResponseObject rrObj, Map<String, SourceSubscriptionManager> subscriptions) throws SoapFaultException {
        AttributedURIType toUri = rrObj.getRequest().getWsAddressingHeader().getTo().orElseThrow(() -> new SoapFaultException(this.createInvalidMsg(rrObj, "No wsa:To element found in request message"), rrObj.getRequest().getWsAddressingHeader().getMessageId().orElse(null)));
        return Optional.ofNullable(subscriptions.get(toUri.getValue())).orElseThrow(() -> new SoapFaultException(this.createInvalidMsg(rrObj, String.format("Subscription manager '%s' does not exist.", toUri.getValue())), rrObj.getRequest().getWsAddressingHeader().getMessageId().orElse(null)));
    }

    public void unregisterHttpHandler(SourceSubscriptionManager subMan) {
        URI fullUri = URI.create(subMan.getSubscriptionManagerEpr().getAddress().getValue());
        String uriWithoutPath = this.httpUriBuilder.buildUri(fullUri.getScheme(), fullUri.getHost(), fullUri.getPort());
        this.httpServerRegistry.unregisterContext(uriWithoutPath, fullUri.getPath());
    }
}

