/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.client;

import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.Service;
import com.google.common.util.concurrent.SettableFuture;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.apache.logging.log4j.kotlin.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.somda.sdc.common.event.EventBus;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.common.util.ExecutorWrapperService;
import org.somda.sdc.dpws.TransportBinding;
import org.somda.sdc.dpws.client.Client;
import org.somda.sdc.dpws.client.ClientImpl;
import org.somda.sdc.dpws.client.DiscoveredDevice;
import org.somda.sdc.dpws.client.DiscoveryFilter;
import org.somda.sdc.dpws.client.DiscoveryObserver;
import org.somda.sdc.dpws.client.EventObserver;
import org.somda.sdc.dpws.client.Subscription;
import org.somda.sdc.dpws.client.helper.DiscoveredDeviceResolver;
import org.somda.sdc.dpws.client.helper.DiscoveryClientUdpProcessor;
import org.somda.sdc.dpws.client.helper.HelloByeAndProbeMatchesObserverImpl;
import org.somda.sdc.dpws.client.helper.HostingServiceResolver;
import org.somda.sdc.dpws.client.helper.factory.ClientHelperFactory;
import org.somda.sdc.dpws.factory.TransportBindingFactory;
import org.somda.sdc.dpws.guice.ClientSpecific;
import org.somda.sdc.dpws.guice.DiscoveryUdpQueue;
import org.somda.sdc.dpws.guice.NetworkJobThreadPool;
import org.somda.sdc.dpws.helper.NotificationSourceUdpCallback;
import org.somda.sdc.dpws.helper.factory.DpwsHelperFactory;
import org.somda.sdc.dpws.service.HostingServiceProxy;
import org.somda.sdc.dpws.soap.NotificationSink;
import org.somda.sdc.dpws.soap.NotificationSource;
import org.somda.sdc.dpws.soap.RequestResponseClient;
import org.somda.sdc.dpws.soap.exception.MarshallingException;
import org.somda.sdc.dpws.soap.exception.TransportException;
import org.somda.sdc.dpws.soap.factory.NotificationSinkFactory;
import org.somda.sdc.dpws.soap.factory.NotificationSourceFactory;
import org.somda.sdc.dpws.soap.factory.RequestResponseClientFactory;
import org.somda.sdc.dpws.soap.interception.InterceptorException;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingServerInterceptor;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingUtil;
import org.somda.sdc.dpws.soap.wsdiscovery.HelloByeAndProbeMatchesObserver;
import org.somda.sdc.dpws.soap.wsdiscovery.WsDiscoveryClient;
import org.somda.sdc.dpws.soap.wsdiscovery.factory.WsDiscoveryClientFactory;
import org.somda.sdc.dpws.soap.wsdiscovery.model.ProbeMatchesType;
import org.somda.sdc.dpws.soap.wsdiscovery.model.ResolveMatchType;
import org.somda.sdc.dpws.soap.wsdiscovery.model.ResolveMatchesType;
import org.somda.sdc.dpws.soap.wsdiscovery.model.ScopesType;
import org.somda.sdc.dpws.udp.UdpMessageQueueService;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00cd\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007*\u0001&\u0018\u0000 I2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001IB\u0091\u0001\b\u0001\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0001\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u000e\b\u0001\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u0012\u0006\u0010\u001e\u001a\u00020\u001f\u0012\b\b\u0001\u0010 \u001a\u00020!\u0012\n\b\u0001\u0010\"\u001a\u0004\u0018\u00010#\u00a2\u0006\u0002\u0010$J\b\u00100\u001a\u000201H\u0002J\u0016\u00102\u001a\b\u0012\u0004\u0012\u000204032\u0006\u00105\u001a\u00020#H\u0016J\u0016\u00102\u001a\b\u0012\u0004\u0012\u000204032\u0006\u00106\u001a\u000207H\u0016J\u0016\u00108\u001a\b\u0012\u0004\u0012\u000209032\u0006\u0010:\u001a\u00020#H\u0016J\u0010\u0010;\u001a\u0002012\u0006\u0010<\u001a\u00020=H\u0016J\u0010\u0010>\u001a\u0002012\u0006\u0010?\u001a\u00020@H\u0016J\u0010\u0010A\u001a\u0002012\u0006\u0010B\u001a\u00020CH\u0016J\u0016\u0010D\u001a\b\u0012\u0004\u0012\u000207032\u0006\u00105\u001a\u00020#H\u0016J\b\u0010E\u001a\u000201H\u0014J\b\u0010F\u001a\u000201H\u0014J\u0010\u0010G\u001a\u0002012\u0006\u0010?\u001a\u00020@H\u0016J\u0010\u0010H\u001a\u0002012\u0006\u0010B\u001a\u00020CH\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010'R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lorg/somda/sdc/dpws/client/ClientImpl;", "Lcom/google/common/util/concurrent/AbstractIdleService;", "Lorg/somda/sdc/dpws/client/Client;", "Lcom/google/common/util/concurrent/Service;", "Lorg/somda/sdc/dpws/soap/wsdiscovery/HelloByeAndProbeMatchesObserver;", "maxWaitForFutures", "Ljava/time/Duration;", "discoveryClientFactory", "Lorg/somda/sdc/dpws/soap/wsdiscovery/factory/WsDiscoveryClientFactory;", "notificationSourceFactory", "Lorg/somda/sdc/dpws/soap/factory/NotificationSourceFactory;", "dpwsHelperFactory", "Lorg/somda/sdc/dpws/helper/factory/DpwsHelperFactory;", "discoveryMessageQueue", "Lorg/somda/sdc/dpws/udp/UdpMessageQueueService;", "notificationSinkFactory", "Lorg/somda/sdc/dpws/soap/factory/NotificationSinkFactory;", "clientHelperFactory", "Lorg/somda/sdc/dpws/client/helper/factory/ClientHelperFactory;", "executorService", "Lorg/somda/sdc/common/util/ExecutorWrapperService;", "Lcom/google/common/util/concurrent/ListeningExecutorService;", "wsAddressingUtil", "Lorg/somda/sdc/dpws/soap/wsaddressing/WsAddressingUtil;", "transportBindingFactory", "Lorg/somda/sdc/dpws/factory/TransportBindingFactory;", "requestResponseClientFactory", "Lorg/somda/sdc/dpws/soap/factory/RequestResponseClientFactory;", "hostingServiceResolver", "Lorg/somda/sdc/dpws/client/helper/HostingServiceResolver;", "clientEventBus", "Lorg/somda/sdc/common/event/EventBus;", "wsAddressingServerInterceptor", "Lorg/somda/sdc/dpws/soap/wsaddressing/WsAddressingServerInterceptor;", "frameworkIdentifier", "", "(Ljava/time/Duration;Lorg/somda/sdc/dpws/soap/wsdiscovery/factory/WsDiscoveryClientFactory;Lorg/somda/sdc/dpws/soap/factory/NotificationSourceFactory;Lorg/somda/sdc/dpws/helper/factory/DpwsHelperFactory;Lorg/somda/sdc/dpws/udp/UdpMessageQueueService;Lorg/somda/sdc/dpws/soap/factory/NotificationSinkFactory;Lorg/somda/sdc/dpws/client/helper/factory/ClientHelperFactory;Lorg/somda/sdc/common/util/ExecutorWrapperService;Lorg/somda/sdc/dpws/soap/wsaddressing/WsAddressingUtil;Lorg/somda/sdc/dpws/factory/TransportBindingFactory;Lorg/somda/sdc/dpws/soap/factory/RequestResponseClientFactory;Lorg/somda/sdc/dpws/client/helper/HostingServiceResolver;Lorg/somda/sdc/common/event/EventBus;Lorg/somda/sdc/dpws/soap/wsaddressing/WsAddressingServerInterceptor;Ljava/lang/String;)V", "clientEventForwarder", "org/somda/sdc/dpws/client/ClientImpl$clientEventForwarder$1", "Lorg/somda/sdc/dpws/client/ClientImpl$clientEventForwarder$1;", "helloByeAndProbeMatchesObserverImpl", "Lorg/somda/sdc/dpws/client/helper/HelloByeAndProbeMatchesObserverImpl;", "instanceLogger", "Lorg/apache/logging/log4j/kotlin/KotlinLogger;", "msgProcessor", "Lorg/somda/sdc/dpws/client/helper/DiscoveryClientUdpProcessor;", "wsDiscoveryClient", "Lorg/somda/sdc/dpws/soap/wsdiscovery/WsDiscoveryClient;", "checkRunning", "", "connect", "Lcom/google/common/util/concurrent/ListenableFuture;", "Lorg/somda/sdc/dpws/service/HostingServiceProxy;", "eprAddress", "discoveredDevice", "Lorg/somda/sdc/dpws/client/DiscoveredDevice;", "directedProbe", "Lorg/somda/sdc/dpws/soap/wsdiscovery/model/ProbeMatchesType;", "xAddr", "probe", "discoveryFilter", "Lorg/somda/sdc/dpws/client/DiscoveryFilter;", "registerDiscoveryObserver", "observer", "Lorg/somda/sdc/dpws/client/DiscoveryObserver;", "registerEventObserver", "eventObserver", "Lorg/somda/sdc/dpws/client/EventObserver;", "resolve", "shutDown", "startUp", "unregisterDiscoveryObserver", "unregisterEventObserver", "Companion", "dpws"})
public final class ClientImpl
extends AbstractIdleService
implements Client,
Service,
HelloByeAndProbeMatchesObserver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Duration maxWaitForFutures;
    @NotNull
    private final UdpMessageQueueService discoveryMessageQueue;
    @NotNull
    private final ExecutorWrapperService<ListeningExecutorService> executorService;
    @NotNull
    private final WsAddressingUtil wsAddressingUtil;
    @NotNull
    private final TransportBindingFactory transportBindingFactory;
    @NotNull
    private final RequestResponseClientFactory requestResponseClientFactory;
    @NotNull
    private final HostingServiceResolver hostingServiceResolver;
    @NotNull
    private final EventBus clientEventBus;
    @NotNull
    private final DiscoveryClientUdpProcessor msgProcessor;
    @NotNull
    private final HelloByeAndProbeMatchesObserverImpl helloByeAndProbeMatchesObserverImpl;
    @NotNull
    private final WsDiscoveryClient wsDiscoveryClient;
    @NotNull
    private final KotlinLogger instanceLogger;
    @NotNull
    private final clientEventForwarder.1 clientEventForwarder;

    @Inject
    public ClientImpl(@Named(value="Dpws.MaxWaitForFutures") @NotNull Duration maxWaitForFutures, @NotNull WsDiscoveryClientFactory discoveryClientFactory, @NotNull NotificationSourceFactory notificationSourceFactory, @NotNull DpwsHelperFactory dpwsHelperFactory, @DiscoveryUdpQueue @NotNull UdpMessageQueueService discoveryMessageQueue, @NotNull NotificationSinkFactory notificationSinkFactory, @NotNull ClientHelperFactory clientHelperFactory, @NetworkJobThreadPool @NotNull ExecutorWrapperService<ListeningExecutorService> executorService, @NotNull WsAddressingUtil wsAddressingUtil, @NotNull TransportBindingFactory transportBindingFactory, @NotNull RequestResponseClientFactory requestResponseClientFactory, @NotNull HostingServiceResolver hostingServiceResolver, @NotNull EventBus clientEventBus, @ClientSpecific @NotNull WsAddressingServerInterceptor wsAddressingServerInterceptor, @Named(value="Common.InstanceIdentifier") @Nullable String frameworkIdentifier) {
        Intrinsics.checkNotNullParameter((Object)maxWaitForFutures, (String)"maxWaitForFutures");
        Intrinsics.checkNotNullParameter((Object)discoveryClientFactory, (String)"discoveryClientFactory");
        Intrinsics.checkNotNullParameter((Object)notificationSourceFactory, (String)"notificationSourceFactory");
        Intrinsics.checkNotNullParameter((Object)dpwsHelperFactory, (String)"dpwsHelperFactory");
        Intrinsics.checkNotNullParameter((Object)discoveryMessageQueue, (String)"discoveryMessageQueue");
        Intrinsics.checkNotNullParameter((Object)notificationSinkFactory, (String)"notificationSinkFactory");
        Intrinsics.checkNotNullParameter((Object)clientHelperFactory, (String)"clientHelperFactory");
        Intrinsics.checkNotNullParameter(executorService, (String)"executorService");
        Intrinsics.checkNotNullParameter((Object)wsAddressingUtil, (String)"wsAddressingUtil");
        Intrinsics.checkNotNullParameter((Object)transportBindingFactory, (String)"transportBindingFactory");
        Intrinsics.checkNotNullParameter((Object)requestResponseClientFactory, (String)"requestResponseClientFactory");
        Intrinsics.checkNotNullParameter((Object)hostingServiceResolver, (String)"hostingServiceResolver");
        Intrinsics.checkNotNullParameter((Object)clientEventBus, (String)"clientEventBus");
        Intrinsics.checkNotNullParameter((Object)wsAddressingServerInterceptor, (String)"wsAddressingServerInterceptor");
        this.maxWaitForFutures = maxWaitForFutures;
        this.discoveryMessageQueue = discoveryMessageQueue;
        this.executorService = executorService;
        this.wsAddressingUtil = wsAddressingUtil;
        this.transportBindingFactory = transportBindingFactory;
        this.requestResponseClientFactory = requestResponseClientFactory;
        this.hostingServiceResolver = hostingServiceResolver;
        this.clientEventBus = clientEventBus;
        KotlinLogger kotlinLogger = InstanceLogger.wrapLogger((KotlinLogger)Companion.getLogger(), (String)frameworkIdentifier);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinLogger, (String)"wrapLogger(...)");
        this.instanceLogger = kotlinLogger;
        this.clientEventForwarder = new EventObserver(this){
            final /* synthetic */ ClientImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public void onSubscriptionEvent(@NotNull Subscription event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                ClientImpl.access$getClientEventBus$p(this.this$0).post((Object)event);
            }
        };
        NotificationSourceUdpCallback callback = dpwsHelperFactory.createNotificationSourceUdpCallback(this.discoveryMessageQueue);
        NotificationSource notificationSource = notificationSourceFactory.createNotificationSource(callback);
        WsDiscoveryClient wsDiscoveryClient = discoveryClientFactory.createWsDiscoveryClient(notificationSource);
        Intrinsics.checkNotNullExpressionValue((Object)wsDiscoveryClient, (String)"createWsDiscoveryClient(...)");
        this.wsDiscoveryClient = wsDiscoveryClient;
        NotificationSink notificationSink = notificationSinkFactory.createNotificationSink(wsAddressingServerInterceptor);
        DiscoveryClientUdpProcessor discoveryClientUdpProcessor = clientHelperFactory.createDiscoveryClientUdpProcessor(notificationSink);
        Intrinsics.checkNotNullExpressionValue((Object)discoveryClientUdpProcessor, (String)"createDiscoveryClientUdpProcessor(...)");
        this.msgProcessor = discoveryClientUdpProcessor;
        notificationSink.register(this.wsDiscoveryClient);
        DiscoveredDeviceResolver discoveredDeviceResolver = clientHelperFactory.createDiscoveredDeviceResolver(this.wsDiscoveryClient);
        HelloByeAndProbeMatchesObserverImpl helloByeAndProbeMatchesObserverImpl = clientHelperFactory.createDiscoveryObserver(discoveredDeviceResolver);
        Intrinsics.checkNotNullExpressionValue((Object)helloByeAndProbeMatchesObserverImpl, (String)"createDiscoveryObserver(...)");
        this.helloByeAndProbeMatchesObserverImpl = helloByeAndProbeMatchesObserverImpl;
    }

    @Override
    public void probe(@NotNull DiscoveryFilter discoveryFilter) throws TransportException, InterceptorException {
        Intrinsics.checkNotNullParameter((Object)discoveryFilter, (String)"discoveryFilter");
        this.checkRunning();
        try {
            this.wsDiscoveryClient.sendProbe(discoveryFilter.getDiscoveryId(), discoveryFilter.getTypes(), discoveryFilter.getScopes(), discoveryFilter.getMatchBy());
        }
        catch (MarshallingException e) {
            this.instanceLogger.error((CharSequence)"Marshalling failed while probing for devices", e.getCause());
        }
    }

    @Override
    @NotNull
    public ListenableFuture<ProbeMatchesType> directedProbe(@NotNull String xAddr) {
        Intrinsics.checkNotNullParameter((Object)xAddr, (String)"xAddr");
        this.checkRunning();
        TransportBinding tBinding = this.transportBindingFactory.createTransportBinding(xAddr, null);
        RequestResponseClient rrc = this.requestResponseClientFactory.createRequestResponseClient(tBinding);
        ListenableFuture<ProbeMatchesType> listenableFuture = this.wsDiscoveryClient.sendDirectedProbe(rrc, new ArrayList(), new ArrayList(), null);
        Intrinsics.checkNotNullExpressionValue(listenableFuture, (String)"sendDirectedProbe(...)");
        return listenableFuture;
    }

    @Override
    @NotNull
    public ListenableFuture<DiscoveredDevice> resolve(@NotNull String eprAddress) throws InterceptorException {
        Intrinsics.checkNotNullParameter((Object)eprAddress, (String)"eprAddress");
        this.checkRunning();
        SettableFuture settableFuture = SettableFuture.create();
        Intrinsics.checkNotNullExpressionValue((Object)settableFuture, (String)"create(...)");
        SettableFuture returnFuture = settableFuture;
        try {
            ListenableFuture<ResolveMatchesType> resolveMatchesFuture = this.wsDiscoveryClient.sendResolve(this.wsAddressingUtil.createEprWithAddress(eprAddress));
            Futures.addCallback(resolveMatchesFuture, (FutureCallback)((FutureCallback)new FutureCallback<ResolveMatchesType>(this, (SettableFuture<DiscoveredDevice>)returnFuture){
                final /* synthetic */ ClientImpl this$0;
                final /* synthetic */ SettableFuture<DiscoveredDevice> $returnFuture;
                {
                    this.this$0 = $receiver;
                    this.$returnFuture = $returnFuture;
                }

                public void onSuccess(@Nullable ResolveMatchesType resolveMatchesType) {
                    if (resolveMatchesType == null) {
                        ClientImpl.access$getInstanceLogger$p(this.this$0).warn((CharSequence)"Received ResolveMatches with empty payload");
                    } else {
                        ResolveMatchType rm = resolveMatchesType.getResolveMatch();
                        ScopesType scopesType = rm.getScopes();
                        List<E> list = scopesType != null ? scopesType.getValue() : null;
                        if (list == null) {
                            list = CollectionsKt.emptyList();
                        }
                        List<E> scopes = list;
                        this.$returnFuture.set((Object)new DiscoveredDevice(rm.getEndpointReference().getAddress().getValue(), rm.getTypes(), (List<String>)scopes, rm.getXAddrs()));
                    }
                }

                public void onFailure(@NotNull Throwable throwable) {
                    Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                    ClientImpl.access$getInstanceLogger$p(this.this$0).trace(throwable, (Function0)resolve.onFailure.1.INSTANCE);
                    this.$returnFuture.setException(throwable);
                }
            }), (Executor)this.executorService.get());
        }
        catch (MarshallingException e) {
            this.instanceLogger.warn(e.getCause(), (Function0)resolve.2.INSTANCE);
            returnFuture.setException((Throwable)e);
        }
        catch (TransportException e) {
            this.instanceLogger.warn(e.getCause(), (Function0)resolve.3.INSTANCE);
            returnFuture.setException((Throwable)e);
        }
        return (ListenableFuture)returnFuture;
    }

    @Override
    @NotNull
    public ListenableFuture<HostingServiceProxy> connect(@NotNull DiscoveredDevice discoveredDevice) {
        Intrinsics.checkNotNullParameter((Object)discoveredDevice, (String)"discoveredDevice");
        this.checkRunning();
        ListenableFuture<HostingServiceProxy> listenableFuture = this.hostingServiceResolver.resolveHostingService(discoveredDevice, this.clientEventForwarder);
        Intrinsics.checkNotNullExpressionValue(listenableFuture, (String)"resolveHostingService(...)");
        return listenableFuture;
    }

    @Override
    @NotNull
    public ListenableFuture<HostingServiceProxy> connect(@NotNull String eprAddress) throws InterceptorException {
        Intrinsics.checkNotNullParameter((Object)eprAddress, (String)"eprAddress");
        this.checkRunning();
        ListenableFuture<DiscoveredDevice> resolveFuture = this.resolve(eprAddress);
        SettableFuture settableFuture = SettableFuture.create();
        Intrinsics.checkNotNullExpressionValue((Object)settableFuture, (String)"create(...)");
        SettableFuture hspFuture = settableFuture;
        Futures.addCallback(resolveFuture, (FutureCallback)((FutureCallback)new FutureCallback<DiscoveredDevice>(this, (SettableFuture<HostingServiceProxy>)hspFuture, eprAddress){
            final /* synthetic */ ClientImpl this$0;
            final /* synthetic */ SettableFuture<HostingServiceProxy> $hspFuture;
            final /* synthetic */ String $eprAddress;
            {
                this.this$0 = $receiver;
                this.$hspFuture = $hspFuture;
                this.$eprAddress = $eprAddress;
            }

            public void onSuccess(@Nullable DiscoveredDevice discoveredDevice) {
                String string = this.$eprAddress;
                if (discoveredDevice == null) {
                    boolean $i$a$-checkNotNull-ClientImpl$connect$1$onSuccess$22 = false;
                    String $i$a$-checkNotNull-ClientImpl$connect$1$onSuccess$22 = "Resolve of " + string + " failed";
                    throw new IllegalStateException($i$a$-checkNotNull-ClientImpl$connect$1$onSuccess$22.toString());
                }
                ListenableFuture<HostingServiceProxy> connectFuture = this.this$0.connect(discoveredDevice);
                try {
                    this.$hspFuture.set(connectFuture.get(ClientImpl.access$getMaxWaitForFutures$p(this.this$0).toMillis(), TimeUnit.MILLISECONDS));
                }
                catch (TimeoutException e) {
                    connectFuture.cancel(true);
                    String errorMessage = "Connecting to " + this.$eprAddress + " timed out after " + ClientImpl.access$getMaxWaitForFutures$p(this.this$0) + ".toSeconds() seconds";
                    ClientImpl.access$getInstanceLogger$p(this.this$0).debug((Throwable)e, (Function0)new Function0<Object>(errorMessage){
                        final /* synthetic */ String $errorMessage;
                        {
                            this.$errorMessage = $errorMessage;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return this.$errorMessage;
                        }
                    });
                    throw e;
                }
                catch (InterruptedException e) {
                    ClientImpl.access$getInstanceLogger$p(this.this$0).debug((Throwable)e, (Function0)new Function0<Object>(this.$eprAddress){
                        final /* synthetic */ String $eprAddress;
                        {
                            this.$eprAddress = $eprAddress;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "Connecting to " + this.$eprAddress + " failed";
                        }
                    });
                    throw e;
                }
                catch (ExecutionException e) {
                    ClientImpl.access$getInstanceLogger$p(this.this$0).debug((Throwable)e, (Function0)new Function0<Object>(this.$eprAddress){
                        final /* synthetic */ String $eprAddress;
                        {
                            this.$eprAddress = $eprAddress;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "Connecting to " + this.$eprAddress + " failed";
                        }
                    });
                    throw e;
                }
                catch (CancellationException e) {
                    ClientImpl.access$getInstanceLogger$p(this.this$0).debug((Throwable)e, (Function0)new Function0<Object>(this.$eprAddress){
                        final /* synthetic */ String $eprAddress;
                        {
                            this.$eprAddress = $eprAddress;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "Connecting to " + this.$eprAddress + " failed";
                        }
                    });
                    throw e;
                }
            }

            public void onFailure(@NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                ClientImpl.access$getInstanceLogger$p(this.this$0).trace(throwable, (Function0)new Function0<Object>(this.$eprAddress){
                    final /* synthetic */ String $eprAddress;
                    {
                        this.$eprAddress = $eprAddress;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Connecting to endpoint " + this.$eprAddress + " failed";
                    }
                });
                this.$hspFuture.setException(throwable);
            }
        }), (Executor)this.executorService.get());
        return (ListenableFuture)hspFuture;
    }

    protected void startUp() {
        this.discoveryMessageQueue.registerUdpMessageQueueObserver(this.msgProcessor);
        this.wsDiscoveryClient.registerHelloByeAndProbeMatchesObserver(this.helloByeAndProbeMatchesObserverImpl);
    }

    protected void shutDown() {
        this.wsDiscoveryClient.unregisterHelloByeAndProbeMatchesObserver(this.helloByeAndProbeMatchesObserverImpl);
        this.discoveryMessageQueue.unregisterUdpMessageQueueObserver(this.msgProcessor);
    }

    @Override
    public void registerDiscoveryObserver(@NotNull DiscoveryObserver observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        this.helloByeAndProbeMatchesObserverImpl.registerDiscoveryObserver(observer);
    }

    @Override
    public void unregisterDiscoveryObserver(@NotNull DiscoveryObserver observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        this.helloByeAndProbeMatchesObserverImpl.unregisterDiscoveryObserver(observer);
    }

    private final void checkRunning() {
        if (!this.isRunning()) {
            boolean bl = false;
            this.instanceLogger.warn((Function0)checkRunning.1.1.INSTANCE);
            Unit unit = Unit.INSTANCE;
            throw new IllegalStateException(unit.toString());
        }
    }

    @Override
    public void registerEventObserver(@NotNull EventObserver eventObserver) {
        Intrinsics.checkNotNullParameter((Object)eventObserver, (String)"eventObserver");
        this.clientEventBus.register((Object)eventObserver);
    }

    @Override
    public void unregisterEventObserver(@NotNull EventObserver eventObserver) {
        Intrinsics.checkNotNullParameter((Object)eventObserver, (String)"eventObserver");
        this.clientEventBus.unregister((Object)eventObserver);
    }

    public static final /* synthetic */ KotlinLogger access$getInstanceLogger$p(ClientImpl $this) {
        return $this.instanceLogger;
    }

    public static final /* synthetic */ Duration access$getMaxWaitForFutures$p(ClientImpl $this) {
        return $this.maxWaitForFutures;
    }

    public static final /* synthetic */ EventBus access$getClientEventBus$p(ClientImpl $this) {
        return $this.clientEventBus;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/somda/sdc/dpws/client/ClientImpl$Companion;", "Lorg/apache/logging/log4j/kotlin/Logging;", "()V", "dpws"})
    public static final class Companion
    implements Logging {
        private Companion() {
        }

        @NotNull
        public KotlinLogger getLogger() {
            return Logging.DefaultImpls.getLogger((Logging)this);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

