/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.guice;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import org.somda.sdc.common.guice.AbstractConfigurationModule;
import org.somda.sdc.dpws.crypto.CryptoSettings;
import org.somda.sdc.dpws.http.HttpConnectionInterceptor;
import org.somda.sdc.dpws.wsdl.WsdlProvisioningMode;

public class DefaultDpwsConfigModule
extends AbstractConfigurationModule {
    public void defaultConfigure() {
        this.configureWsAddressingConfig();
        this.configureWsDiscoveryConfig();
        this.configureWsEventingConfig();
        this.configureClientConfig();
        this.configureDeviceConfig();
        this.configureCryptoConfig();
        this.configureSoapConfig();
        this.configureDpws();
    }

    private void configureDeviceConfig() {
        this.bind("Dpws.WsdlProvisioningMode", WsdlProvisioningMode.class, (Object)WsdlProvisioningMode.RESOURCE);
    }

    private void configureDpws() {
        this.bind("Dpws.MaxWaitForFutures", Duration.class, Duration.ofSeconds(10L));
        this.bind("Dpws.MaxEnvelopeSize", Integer.class, Short.MAX_VALUE);
        this.bind("Dpws.CommunicationLogSinkDirectory", File.class, new File("commlog"));
        this.bind("Dpws.CommunicationLogWithHttpHeaders", Boolean.class, true);
        this.bind("Dpws.CommunicationLogWithRequestResponseId", Boolean.class, true);
        this.bind("Dpws.CommunicationLogPrettyPrintXml", Boolean.class, false);
        this.bind("Dpws.GzipCompression", Boolean.class, true);
        this.bind("Dpws.GzipCompressionMinSize", Integer.class, 32);
        this.bind("Dpws.EnableHttps", Boolean.class, false);
        this.bind("Dpws.EnableHttp", Boolean.class, true);
        this.bind("Dpws.EnforceHttpChunked", Boolean.class, false);
        this.bind("Dpws.HttpServerConnectionTimeout", Duration.class, Duration.ofSeconds(30L));
        this.bind("Dpws.MulticastTtl", Integer.class, 1);
        this.bind("Dpws.HttpCharset", String.class, StandardCharsets.UTF_8.name());
        this.bind("Dpws.ServerCommlogInHandler", Boolean.class, false);
        this.bind("Dpws.ServerThreadPoolSize", Integer.class, 200);
        this.bind("Dpws.ServerEnableJmx", Boolean.class, false);
        this.bind("Dpws.ClientPoolSize", Integer.class, 20);
        this.bind("Dpws.ClientRetryPost", Boolean.class, false);
        this.bind("Dpws.HttpConnectionInterceptor", HttpConnectionInterceptor.class, new HttpConnectionInterceptor(){});
        this.bind("Dpws.HttpClientPoolIdleTimeout", Duration.class, Duration.ofSeconds(10L));
        this.bind("Dpws.HttpClientPoolCleanupPeriod", Duration.class, Duration.ofSeconds(5L));
    }

    private void configureCryptoConfig() {
        this.bind("Dpws.Crypto.Settings", CryptoSettings.class, null);
        this.bind("Dpws.Crypto.TlsEnabledVersions", String[].class, new String[]{"TLSv1.2", "TLSv1.3"});
        this.bind("Dpws.Crypto.TlsEnabledCiphers", String[].class, new String[]{"TLS_AES_128_GCM_SHA256", "TLS_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384"});
        HostnameVerifier defaultHostnameVerifier = new HostnameVerifier(){

            @Override
            public boolean verify(String s, SSLSession sslSession) {
                return true;
            }

            public String toString() {
                return "<accept every peer>";
            }
        };
        this.bind("Dpws.Crypto.ClientHostnameVerifier", HostnameVerifier.class, defaultHostnameVerifier);
        this.bind("Dpws.Crypto.DeviceHostnameVerifier", HostnameVerifier.class, defaultHostnameVerifier);
    }

    private void configureClientConfig() {
        this.bind("Dpws.Client.MaxWaitForResolveMatches", Duration.class, Duration.ofSeconds(10L));
        this.bind("Dpws.Client.AutoResolve", Boolean.class, false);
        this.bind("Dpws.HttpClientConnectTimeout", Duration.class, Duration.ofSeconds(5L));
        this.bind("Dpws.HttpClientReadTimeout", Duration.class, Duration.ofSeconds(5L));
    }

    private void configureWsDiscoveryConfig() {
        this.bind("WsDiscovery.MaxWaitForProbeMatches", Duration.class, Duration.ofSeconds(10L));
        this.bind("WsDiscovery.MaxWaitForResolveMatches", Duration.class, Duration.ofSeconds(10L));
        this.bind("WsDiscovery.MaxProbeMatchesBufferSize", Integer.class, 50);
        this.bind("WsDiscovery.MaxResolveMatchesBufferSize", Integer.class, 50);
    }

    private void configureWsAddressingConfig() {
        this.bind("WsAddressing.IgnoreMessageIds", Boolean.class, false);
        this.bind("WsAddressing.MessageIdCacheSize", Integer.class, 50);
    }

    private void configureWsEventingConfig() {
        this.bind("WsEventing.Source.MaxExpires", Duration.class, Duration.ofHours(1L));
        this.bind("WsEventing.Source.SubscriptionManagerPath", String.class, "SubscriptionManager");
        this.bind("SoapConfig.NotificationQueueCapacity", Integer.class, 500);
    }

    private void configureSoapConfig() {
        this.bind("SoapConfig.JaxbContextPath", String.class, "");
        this.bind("SoapConfig.NamespaceMappings", String.class, "");
        this.bind("SoapConfig.ValidateSoapMessages", Boolean.class, true);
        this.bind("SoapConfig.JaxbSchemaPath", String.class, "");
        this.bind("SoapConfig.MetadataComment", Boolean.class, true);
    }
}

