/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.helper;

import com.google.common.util.concurrent.AbstractIdleService;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.glassfish.jaxb.runtime.marshaller.NamespacePrefixMapper;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.common.util.NamespacePrefixMapperConverter;
import org.somda.sdc.common.util.PrefixNamespaceMappingParser;
import org.somda.sdc.dpws.FrameworkMetadata;
import org.somda.sdc.dpws.soap.JaxbSoapMarshalling;
import org.somda.sdc.dpws.soap.model.ObjectFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class JaxbMarshalling
extends AbstractIdleService {
    private static final Logger LOG = LogManager.getLogger(JaxbMarshalling.class);
    private static final String SAX_FEATURE_EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    private static final String SAX_FEATURE_EXTERNAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    private static final String PKG_DELIM = ":";
    private static final String SCHEMA_DELIM = ":";
    private static final String XML_PROLOG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    private final NamespacePrefixMapper namespacePrefixMapper;
    private final String schemaPath;
    private final Boolean validateSoapMessages;
    private final ObjectFactory soapFactory;
    private final Boolean metadataComment;
    private final Logger instanceLogger;
    private final String versionString;
    private String contextPackages;
    private JAXBContext jaxbContext;
    private Schema schema;

    @Inject
    JaxbMarshalling(@Named(value="SoapConfig.JaxbContextPath") String contextPackages, @Named(value="SoapConfig.NamespaceMappings") String namespaceMappings, @Named(value="SoapConfig.JaxbSchemaPath") String schemaPath, @Named(value="SoapConfig.ValidateSoapMessages") Boolean validateSoapMessages, @Named(value="SoapConfig.MetadataComment") Boolean metadataComment, PrefixNamespaceMappingParser namespaceMappingParser, NamespacePrefixMapperConverter namespacePrefixMapperConverter, ObjectFactory soapFactory, FrameworkMetadata metadata, @Named(value="Common.InstanceIdentifier") String frameworkIdentifier) {
        this.instanceLogger = InstanceLogger.wrapLogger((Logger)LOG, (String)frameworkIdentifier);
        this.contextPackages = contextPackages;
        this.schemaPath = schemaPath;
        this.validateSoapMessages = validateSoapMessages;
        this.metadataComment = metadataComment;
        this.soapFactory = soapFactory;
        String namespaceMappingsExtended = namespaceMappings + "{xsi:http://www.w3.org/2001/XMLSchema-instance}{wsa:http://www.w3.org/2005/08/addressing}{wse:http://schemas.xmlsoap.org/ws/2004/08/eventing}{wsd:http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01}{wsm:http://schemas.xmlsoap.org/ws/2004/09/mex}{wst:http://schemas.xmlsoap.org/ws/2004/09/transfer}{dpws:http://docs.oasis-open.org/ws-dd/ns/dpws/2009/01}{wsdl:http://schemas.xmlsoap.org/wsdl/}{s12:http://www.w3.org/2003/05/soap-envelope}";
        this.namespacePrefixMapper = namespacePrefixMapperConverter.convert(namespaceMappingParser.parse(namespaceMappingsExtended));
        String version = metadata.getFrameworkVersion();
        this.versionString = "<!-- Generated with SDCri " + version + " -->\n";
    }

    protected void startUp() throws Exception {
        this.instanceLogger.info("Start JAXB service");
        this.initializeJaxb();
        this.instanceLogger.info("JAXB service startup finished");
    }

    protected void shutDown() {
        this.instanceLogger.info("JAXB service stopped");
    }

    public <T> void marshal(JAXBElement<T> objectToMarshal, OutputStream outputStream) throws JAXBException {
        this.checkRunning();
        Marshaller marshaller = this.jaxbContext.createMarshaller();
        marshaller.setProperty("org.glassfish.jaxb.namespacePrefixMapper", (Object)this.namespacePrefixMapper);
        if (this.schema != null) {
            marshaller.setSchema(this.schema);
        }
        if (this.metadataComment.booleanValue()) {
            marshaller.setProperty("jaxb.fragment", (Object)true);
            this.instanceLogger.debug("Attaching metadata comment: {}", (Object)this.versionString);
            try {
                outputStream.write(XML_PROLOG.getBytes(StandardCharsets.UTF_8));
                outputStream.write(this.versionString.getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                this.instanceLogger.error("Error while writing SDCri metadata to message");
            }
        }
        marshaller.marshal(objectToMarshal, outputStream);
    }

    private void checkRunning() {
        if (!this.isRunning()) {
            throw new RuntimeException("Try to marshal, but marshalling service is not running. Please check if the DPWS framework is up and running.");
        }
    }

    public Object unmarshal(InputStream inputStream) throws JAXBException {
        this.checkRunning();
        Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
        if (this.schema != null) {
            unmarshaller.setSchema(this.schema);
        }
        return unmarshaller.unmarshal(inputStream);
    }

    public Object unmarshal(Reader reader) throws JAXBException {
        this.checkRunning();
        Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
        if (this.schema != null) {
            unmarshaller.setSchema(this.schema);
        }
        return unmarshaller.unmarshal(reader);
    }

    private void initializeJaxb() throws SAXException, IOException, ParserConfigurationException {
        if (!this.contextPackages.isEmpty()) {
            this.contextPackages = this.contextPackages + ":";
        }
        this.contextPackages = this.contextPackages + "org.somda.sdc.dpws.soap.model:org.somda.sdc.dpws.model:org.somda.sdc.dpws.soap.wsaddressing.model:org.somda.sdc.dpws.soap.wsdiscovery.model:org.somda.sdc.dpws.soap.wseventing.model:org.somda.sdc.dpws.soap.wstransfer.model:org.somda.sdc.dpws.soap.wsmetadataexchange.model:org.somda.sdc.dpws.wsdl.model";
        this.instanceLogger.info("Configure JAXB with contexts: {}", (Object)this.contextPackages);
        try {
            this.jaxbContext = JAXBContext.newInstance((String)this.contextPackages);
        }
        catch (JAXBException e) {
            this.instanceLogger.error("JAXB context for SOAP model(s) could not be created", (Throwable)e);
            throw new RuntimeException("JAXB context for SOAP model(s) could not be created");
        }
        if (this.validateSoapMessages.booleanValue()) {
            String extendedSchemaPath = "xml.xsd:wsdl-1.1-schema.xsd:soap-1.2-schema.xsd:ws-addressing-1.0-schema.xsd:ws-discovery-1.1-schema.xsd:ws-eventing-schema.xsd:ws-metadataexchange-schema.xsd:ws-transfer-schema.xsd:wsdd-dpws-1.1-schema.xsd:wsdl-1.1-schema.xsd:" + this.schemaPath;
            this.instanceLogger.info("XML validation enabled with schemas (order matters!): {}", (Object)extendedSchemaPath);
            this.schema = this.generateTopLevelSchema(extendedSchemaPath);
        } else {
            this.instanceLogger.info("XML validation validation disabled");
            this.schema = null;
        }
    }

    private Schema generateTopLevelSchema(String schemaPath) throws SAXException, IOException, ParserConfigurationException {
        String topLevelSchemaBeginning = "<xsd:schema xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" elementFormDefault=\"qualified\">";
        String importPattern = "<xsd:import namespace=\"%s\" schemaLocation=\"%s\"/>";
        String topLevelSchemaEnd = "</xsd:schema>";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<xsd:schema xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" elementFormDefault=\"qualified\">");
        for (String path : schemaPath.split(":")) {
            ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
            URL schemaUrl = classLoader.getResource(path);
            if (schemaUrl == null) {
                this.instanceLogger.error("Could not find schema for resource: {}", (Object)path);
                throw new IOException(String.format("Could not find schema for resource while loading in %s: %s", JaxbSoapMarshalling.class.getSimpleName(), path));
            }
            String targetNamespace = this.resolveTargetNamespace(schemaUrl);
            this.instanceLogger.info("Register namespace for validation: {}, read from {}", (Object)targetNamespace, (Object)schemaUrl);
            stringBuilder.append(String.format("<xsd:import namespace=\"%s\" schemaLocation=\"%s\"/>", targetNamespace, schemaUrl));
        }
        stringBuilder.append("</xsd:schema>");
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        return schemaFactory.newSchema(new StreamSource(new ByteArrayInputStream(stringBuilder.toString().getBytes(StandardCharsets.UTF_8))));
    }

    private String resolveTargetNamespace(URL url) throws IOException, ParserConfigurationException, SAXException {
        try (InputStream inputStream = url.openStream();){
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature(SAX_FEATURE_EXTERNAL_GENERAL_ENTITIES, false);
            factory.setFeature(SAX_FEATURE_EXTERNAL_PARAMETER_ENTITIES, false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(inputStream);
            String string = document.getDocumentElement().getAttribute("targetNamespace");
            return string;
        }
    }
}

