/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.helper;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.inject.name.Named;
import java.io.ByteArrayOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.dpws.soap.MarshallingService;
import org.somda.sdc.dpws.soap.SoapDebug;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.exception.MarshallingException;
import org.somda.sdc.dpws.soap.interception.NotificationCallback;
import org.somda.sdc.dpws.udp.UdpMessage;
import org.somda.sdc.dpws.udp.UdpMessageQueueService;

public class NotificationSourceUdpCallback
implements NotificationCallback {
    private static final Logger LOG = LogManager.getLogger(NotificationSourceUdpCallback.class);
    private final UdpMessageQueueService udpMessageQueue;
    private final MarshallingService marshallingService;
    private final Logger instanceLogger;

    @AssistedInject
    NotificationSourceUdpCallback(@Assisted UdpMessageQueueService udpMessageQueue, MarshallingService marshallingService, @Named(value="Common.InstanceIdentifier") String frameworkIdentifier) {
        this.instanceLogger = InstanceLogger.wrapLogger((Logger)LOG, (String)frameworkIdentifier);
        this.udpMessageQueue = udpMessageQueue;
        this.marshallingService = marshallingService;
    }

    @Override
    public void onNotification(SoapMessage notification) throws MarshallingException {
        this.instanceLogger.debug("Outgoing SOAP/UDP message: {}", new Supplier[]{() -> SoapDebug.get(notification)});
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.marshallingService.marshal(notification, bos);
        byte[] data = bos.toByteArray();
        this.udpMessageQueue.sendMessage(new UdpMessage(data, data.length));
    }
}

