/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.http.apache;

import com.google.common.io.ByteStreams;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.name.Named;
import jakarta.xml.bind.JAXBException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.Nullable;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.dpws.CommunicationLogContext;
import org.somda.sdc.dpws.TransportBinding;
import org.somda.sdc.dpws.TransportBindingException;
import org.somda.sdc.dpws.http.ContentType;
import org.somda.sdc.dpws.http.HttpException;
import org.somda.sdc.dpws.soap.SoapMarshalling;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.SoapUtil;
import org.somda.sdc.dpws.soap.exception.MarshallingException;
import org.somda.sdc.dpws.soap.exception.SoapFaultException;
import org.somda.sdc.dpws.soap.exception.TransportException;
import org.somda.sdc.dpws.soap.model.Envelope;

public class ClientTransportBinding
implements TransportBinding {
    public static final String USER_AGENT_KEY = "X-User-Agent";
    public static final String USER_AGENT_VALUE = "SDCri";
    public static final String COMMUNICATION_LOG_CONTEXT_KEY = "SDCri_Communication_Log_Context";
    private static final Logger LOG = LogManager.getLogger(ClientTransportBinding.class);
    private final SoapMarshalling marshalling;
    private final SoapUtil soapUtil;
    private final Logger instanceLogger;
    private final HttpClient client;
    private final String clientUri;
    private final boolean chunkedTransfer;
    private final String contentTypeString;
    private final @Nullable CommunicationLogContext communicationLogContext;

    @Inject
    ClientTransportBinding(@Assisted HttpClient client, @Assisted String clientUri, @Assisted SoapMarshalling marshalling, @Assisted SoapUtil soapUtil, @Assisted @Nullable CommunicationLogContext communicationLogContext, @Named(value="Common.InstanceIdentifier") String frameworkIdentifier, @Named(value="Dpws.EnforceHttpChunked") boolean chunkedTransfer, @Named(value="Dpws.HttpCharset") String charset) {
        this.instanceLogger = InstanceLogger.wrapLogger((Logger)LOG, (String)frameworkIdentifier);
        this.instanceLogger.debug("Creating ClientTransportBinding for {}", (Object)clientUri);
        this.client = client;
        this.clientUri = clientUri;
        this.marshalling = marshalling;
        this.soapUtil = soapUtil;
        this.chunkedTransfer = chunkedTransfer;
        this.contentTypeString = org.apache.http.entity.ContentType.create((String)"application/soap+xml", (String)charset).toString();
        this.communicationLogContext = communicationLogContext;
    }

    @Override
    public void onNotification(SoapMessage notification) throws TransportBindingException {
        try {
            this.onRequestResponse(notification);
        }
        catch (SoapFaultException soapFaultException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SoapMessage onRequestResponse(SoapMessage request) throws TransportBindingException, SoapFaultException {
        byte[] bytes;
        HttpResponse response;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        HttpPost post = new HttpPost(this.clientUri);
        post.setHeader("Accept", "application/soap+xml");
        post.setHeader("Content-Type", this.contentTypeString);
        post.setHeader(USER_AGENT_KEY, USER_AGENT_VALUE);
        try {
            this.marshalling.marshal(request.getEnvelopeWithMappedHeaders(), byteArrayOutputStream);
        }
        catch (JAXBException e) {
            this.instanceLogger.warn("Marshalling of a message failed: {}", (Object)e.toString());
            this.instanceLogger.trace("Marshalling of a message failed", (Throwable)e);
            throw new TransportBindingException(String.format("Sending of a request failed due to marshalling problem: %s", new Object[]{e}), new MarshallingException(e));
        }
        ByteArrayEntity requestEntity = new ByteArrayEntity(byteArrayOutputStream.toByteArray());
        if (this.chunkedTransfer) {
            requestEntity.setChunked(true);
        }
        post.setEntity((HttpEntity)requestEntity);
        BasicHttpContext httpContext = new BasicHttpContext();
        httpContext.setAttribute(COMMUNICATION_LOG_CONTEXT_KEY, (Object)this.communicationLogContext);
        this.instanceLogger.debug("Sending POST request to {}", (Object)this.clientUri);
        try {
            response = this.client.execute((HttpUriRequest)post, (HttpContext)httpContext);
        }
        catch (SocketException e) {
            this.instanceLogger.error("Unexpected SocketException on request to {}", (Object)this.clientUri, (Object)e);
            throw new TransportBindingException(e);
        }
        catch (IOException e) {
            this.instanceLogger.error("Unexpected IO exception on request to {}. {}", (Object)this.clientUri, (Object)e.getMessage());
            this.instanceLogger.trace("Unexpected IO exception on request to {}", (Object)this.clientUri, (Object)e);
            throw new TransportBindingException("No response received", e);
        }
        HttpEntity entity = response.getEntity();
        try (InputStream contentStream = entity.getContent();){
            bytes = ByteStreams.toByteArray((InputStream)contentStream);
        }
        catch (IOException e) {
            this.instanceLogger.error("Couldn't read response from {}. {}", (Object)this.clientUri, (Object)e.getMessage());
            this.instanceLogger.trace("Couldn't read response from {}", (Object)this.clientUri, (Object)e);
            throw new TransportBindingException("Error reading response", e);
        }
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);){
            if (((InputStream)inputStream).available() > 0) {
                Envelope envelope;
                Header contentTypeElements = entity.getContentType();
                ContentType contentType = ContentType.fromApache(contentTypeElements).orElseThrow(() -> {
                    this.instanceLogger.error("Could not parse content type from element {}", (Object)contentTypeElements);
                    return new TransportBindingException("Could not parse content type from element " + String.valueOf(contentTypeElements));
                });
                if (contentType.getCharset() != null) {
                    InputStreamReader reader = new InputStreamReader((InputStream)inputStream, contentType.getCharset());
                    envelope = this.marshalling.unmarshal(reader);
                } else {
                    envelope = this.marshalling.unmarshal(inputStream);
                }
                SoapMessage msg = this.soapUtil.createMessage(envelope);
                if (msg.isFault()) {
                    throw new SoapFaultException(msg, new HttpException(response.getStatusLine().getStatusCode()), request.getWsAddressingHeader().getMessageId().orElse(null));
                }
                SoapMessage soapMessage = msg;
                return soapMessage;
            }
            if (response.getStatusLine().getStatusCode() >= 300) {
                throw new TransportBindingException(String.format("Endpoint was not able to process request. HTTP status code: %s", response.getStatusLine()), new TransportException(new HttpException(response.getStatusLine().getStatusCode())));
            }
        }
        catch (JAXBException e) {
            this.instanceLogger.debug("Unmarshalling of a message failed: {}. Response payload:\n{}", (Object)e, (Object)new String(bytes, StandardCharsets.UTF_8));
            this.instanceLogger.trace("Unmarshalling of a message failed. ", (Throwable)e);
            throw new TransportBindingException(String.format("Receiving of a response failed due to unmarshalling problem: %s", e.getCause()), new MarshallingException(e));
        }
        catch (IOException e) {
            this.instanceLogger.debug("Error occurred while processing response: {}", (Object)e.getMessage());
            this.instanceLogger.trace("Error occurred while processing response", (Throwable)e);
        }
        finally {
            try {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
            catch (IOException iOException) {}
        }
        return this.soapUtil.createMessage();
    }

    @Override
    public void close() {
    }
}

