/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.http.apache;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.input.TeeInputStream;
import org.apache.commons.io.output.TeeOutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.entity.HttpEntityWrapper;

public class CommunicationLogEntity
extends HttpEntityWrapper {
    private final OutputStream communicationLogStream;
    private InputStream content;

    public CommunicationLogEntity(HttpEntity wrappedEntity, OutputStream communicationLogStream) {
        super(wrappedEntity);
        this.communicationLogStream = communicationLogStream;
    }

    public InputStream getContent() throws IOException {
        if (this.wrappedEntity.isStreaming()) {
            if (this.content == null) {
                this.content = this.getWrappedStream();
            }
            return this.content;
        }
        return this.getWrappedStream();
    }

    public void writeTo(OutputStream outStream) throws IOException {
        TeeOutputStream splitOutputStream = new TeeOutputStream(outStream, this.communicationLogStream);
        super.writeTo((OutputStream)splitOutputStream);
        this.communicationLogStream.close();
    }

    public boolean isRepeatable() {
        return false;
    }

    private InputStream getWrappedStream() throws IOException {
        return new TeeInputStream(this.wrappedEntity.getContent(), this.communicationLogStream, true);
    }
}

