/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.http.apache;

import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.NonNull;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.dpws.CommunicationLog;
import org.somda.sdc.dpws.CommunicationLogContext;
import org.somda.sdc.dpws.http.apache.CommunicationLogEntity;
import org.somda.sdc.dpws.http.apache.helper.ApacheClientHelper;
import org.somda.sdc.dpws.soap.CommunicationContext;
import org.somda.sdc.dpws.soap.HttpApplicationInfo;
import org.somda.sdc.dpws.soap.TransportInfo;

public class CommunicationLogHttpRequestInterceptor
implements HttpRequestInterceptor {
    private static final Logger LOG = LogManager.getLogger(CommunicationLogHttpRequestInterceptor.class);
    private static final String TRANSACTION_ID_PREFIX_CLIENT = "rrId:client:" + String.valueOf(UUID.randomUUID()) + ":";
    private static final AtomicLong TRANSACTION_ID = new AtomicLong(-1L);
    private final CommunicationLog commlog;
    private final Logger instanceLogger;
    private final List<X509Certificate> certificates;

    CommunicationLogHttpRequestInterceptor(CommunicationLog communicationLog, String frameworkIdentifier, List<X509Certificate> certificateList) {
        this.instanceLogger = InstanceLogger.wrapLogger((Logger)LOG, (String)frameworkIdentifier);
        this.commlog = communicationLog;
        this.certificates = certificateList;
    }

    public void process(HttpRequest request, HttpContext context) {
        this.instanceLogger.debug("Processing request: {}", (Object)request.getRequestLine());
        CommunicationContext requestCommContext = this.getCommunicationContext(request, context);
        OutputStream commlogStream = this.commlog.logMessage(CommunicationLog.Direction.OUTBOUND, CommunicationLog.TransportType.HTTP, CommunicationLog.MessageType.REQUEST, requestCommContext);
        if (!(request instanceof HttpEntityEnclosingRequest)) {
            this.instanceLogger.debug("Request doesn't have a body {}, closing stream", (Object)request.getRequestLine());
            try {
                commlogStream.close();
            }
            catch (IOException e) {
                LOG.warn("Could not close empty output stream. {}", (Object)e.getMessage());
                LOG.trace("Could not close empty output stream.", (Throwable)e);
            }
            return;
        }
        HttpEntityEnclosingRequest entityRequest = (HttpEntityEnclosingRequest)request;
        HttpEntity oldMessageEntity = entityRequest.getEntity();
        entityRequest.setEntity((HttpEntity)new CommunicationLogEntity(oldMessageEntity, commlogStream));
        this.instanceLogger.debug("Processing request done: {}", (Object)request.getRequestLine());
    }

    private @NonNull CommunicationContext getCommunicationContext(HttpRequest request, HttpContext context) {
        HttpHost target = (HttpHost)context.getAttribute("http.target_host");
        CommunicationLogContext communicationLogContext = (CommunicationLogContext)context.getAttribute("SDCri_Communication_Log_Context");
        String currentTransactionId = TRANSACTION_ID_PREFIX_CLIENT + TRANSACTION_ID.incrementAndGet();
        context.setAttribute(CommunicationLog.MessageType.REQUEST.name(), (Object)currentTransactionId);
        HttpApplicationInfo requestHttpApplicationInfo = new HttpApplicationInfo(ApacheClientHelper.allHeadersToMultimap(request.getAllHeaders()), currentTransactionId, request.getRequestLine().getUri());
        TransportInfo requestTransportInfo = new TransportInfo(target.getSchemeName(), null, null, target.getHostName(), target.getPort(), this.certificates);
        CommunicationContext requestCommContext = new CommunicationContext(requestHttpApplicationInfo, requestTransportInfo, communicationLogContext);
        return requestCommContext;
    }
}

