/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.http.apache;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.logging.Log;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.config.MessageConstraints;
import org.apache.http.entity.ContentLengthStrategy;
import org.apache.http.impl.conn.DefaultManagedHttpClientConnection;
import org.apache.http.impl.conn.Wire;
import org.apache.http.io.HttpMessageParserFactory;
import org.apache.http.io.HttpMessageWriterFactory;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.apache.logging.log4j.kotlin.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.somda.sdc.dpws.http.HttpConnectionInterceptor;
import org.somda.sdc.dpws.http.apache.MyApacheLoggingInputStream;
import org.somda.sdc.dpws.http.apache.MyApacheLoggingOutputStream;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0083\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0013\u0012\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0016\u0012\u000e\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u0019\u0012\u0006\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\u0002\u0010\u001dJ\b\u0010 \u001a\u00020!H\u0016J\u0012\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0014J\u0012\u0010&\u001a\u00020'2\b\u0010$\u001a\u0004\u0018\u00010%H\u0014J\u0012\u0010(\u001a\u00020!2\b\u0010)\u001a\u0004\u0018\u00010\u0017H\u0014J\u0012\u0010*\u001a\u00020!2\b\u0010+\u001a\u0004\u0018\u00010\u001aH\u0014J\u0010\u0010,\u001a\u00020!2\u0006\u0010-\u001a\u00020\nH\u0016J\b\u0010.\u001a\u00020!H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/somda/sdc/dpws/http/apache/MyApacheDefaultManagedHttpClientConnection;", "Lorg/apache/http/impl/conn/DefaultManagedHttpClientConnection;", "Lorg/apache/logging/log4j/kotlin/Logging;", "id", "", "headerLog", "Lorg/apache/logging/log4j/kotlin/KotlinLogger;", "wireLog", "Lorg/apache/commons/logging/Log;", "bufferSize", "", "fragmentSizeHint", "charDecoder", "Ljava/nio/charset/CharsetDecoder;", "charEncoder", "Ljava/nio/charset/CharsetEncoder;", "constraints", "Lorg/apache/http/config/MessageConstraints;", "incomingContentStrategy", "Lorg/apache/http/entity/ContentLengthStrategy;", "outgoingContentStrategy", "requestWriterFactory", "Lorg/apache/http/io/HttpMessageWriterFactory;", "Lorg/apache/http/HttpRequest;", "responseParserFactory", "Lorg/apache/http/io/HttpMessageParserFactory;", "Lorg/apache/http/HttpResponse;", "httpConnectionInterceptor", "Lorg/somda/sdc/dpws/http/HttpConnectionInterceptor;", "(Ljava/lang/String;Lorg/apache/logging/log4j/kotlin/KotlinLogger;Lorg/apache/commons/logging/Log;IILjava/nio/charset/CharsetDecoder;Ljava/nio/charset/CharsetEncoder;Lorg/apache/http/config/MessageConstraints;Lorg/apache/http/entity/ContentLengthStrategy;Lorg/apache/http/entity/ContentLengthStrategy;Lorg/apache/http/io/HttpMessageWriterFactory;Lorg/apache/http/io/HttpMessageParserFactory;Lorg/somda/sdc/dpws/http/HttpConnectionInterceptor;)V", "wire", "Lorg/apache/http/impl/conn/Wire;", "close", "", "getSocketInputStream", "Ljava/io/InputStream;", "socket", "Ljava/net/Socket;", "getSocketOutputStream", "Ljava/io/OutputStream;", "onRequestSubmitted", "request", "onResponseReceived", "response", "setSocketTimeout", "timeout", "shutdown", "dpws"})
public final class MyApacheDefaultManagedHttpClientConnection
extends DefaultManagedHttpClientConnection
implements Logging {
    @NotNull
    private final KotlinLogger headerLog;
    @NotNull
    private final HttpConnectionInterceptor httpConnectionInterceptor;
    @NotNull
    private final Wire wire;

    public MyApacheDefaultManagedHttpClientConnection(@NotNull String id, @NotNull KotlinLogger headerLog, @NotNull Log wireLog, int bufferSize, int fragmentSizeHint, @Nullable CharsetDecoder charDecoder, @Nullable CharsetEncoder charEncoder, @Nullable MessageConstraints constraints, @NotNull ContentLengthStrategy incomingContentStrategy, @NotNull ContentLengthStrategy outgoingContentStrategy, @NotNull HttpMessageWriterFactory<HttpRequest> requestWriterFactory, @NotNull HttpMessageParserFactory<HttpResponse> responseParserFactory, @NotNull HttpConnectionInterceptor httpConnectionInterceptor) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)headerLog, (String)"headerLog");
        Intrinsics.checkNotNullParameter((Object)wireLog, (String)"wireLog");
        Intrinsics.checkNotNullParameter((Object)incomingContentStrategy, (String)"incomingContentStrategy");
        Intrinsics.checkNotNullParameter((Object)outgoingContentStrategy, (String)"outgoingContentStrategy");
        Intrinsics.checkNotNullParameter(requestWriterFactory, (String)"requestWriterFactory");
        Intrinsics.checkNotNullParameter(responseParserFactory, (String)"responseParserFactory");
        Intrinsics.checkNotNullParameter((Object)httpConnectionInterceptor, (String)"httpConnectionInterceptor");
        super(id, bufferSize, fragmentSizeHint, charDecoder, charEncoder, constraints, incomingContentStrategy, outgoingContentStrategy, requestWriterFactory, responseParserFactory);
        this.headerLog = headerLog;
        this.httpConnectionInterceptor = httpConnectionInterceptor;
        this.wire = new Wire(wireLog, id);
    }

    public void close() throws IOException {
        UUID uUID = UUID.fromString(this.getId());
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(...)");
        this.httpConnectionInterceptor.onLastIntercept(uUID);
        if (super.isOpen()) {
            this.getLogger().debug((Function0)new Function0<Object>(this){
                final /* synthetic */ MyApacheDefaultManagedHttpClientConnection this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return this.this$0.getId() + ": Close connection";
                }
            });
            super.close();
        }
    }

    public void setSocketTimeout(int timeout) {
        this.getLogger().debug((Function0)new Function0<Object>(this, timeout){
            final /* synthetic */ MyApacheDefaultManagedHttpClientConnection this$0;
            final /* synthetic */ int $timeout;
            {
                this.this$0 = $receiver;
                this.$timeout = $timeout;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return this.this$0.getId() + ": set socket timeout to " + this.$timeout;
            }
        });
        super.setSocketTimeout(timeout);
    }

    public void shutdown() throws IOException {
        this.getLogger().debug((Function0)new Function0<Object>(this){
            final /* synthetic */ MyApacheDefaultManagedHttpClientConnection this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return this.this$0.getId() + ": Shutdown connection";
            }
        });
        super.shutdown();
    }

    @NotNull
    protected InputStream getSocketInputStream(@Nullable Socket socket) throws IOException {
        InputStream inputStream;
        InputStream input = super.getSocketInputStream(socket);
        if (this.wire.enabled()) {
            inputStream = input;
            Intrinsics.checkNotNull((Object)inputStream);
            input = new MyApacheLoggingInputStream(inputStream, this.wire);
        }
        inputStream = input;
        Intrinsics.checkNotNull((Object)inputStream);
        return inputStream;
    }

    @NotNull
    protected OutputStream getSocketOutputStream(@Nullable Socket socket) throws IOException {
        OutputStream outputStream;
        OutputStream out = super.getSocketOutputStream(socket);
        if (this.wire.enabled()) {
            outputStream = out;
            Intrinsics.checkNotNull((Object)outputStream);
            out = new MyApacheLoggingOutputStream(outputStream, this.wire);
        }
        outputStream = out;
        Intrinsics.checkNotNull((Object)outputStream);
        return outputStream;
    }

    protected void onResponseReceived(@Nullable HttpResponse response) {
        if (response != null && this.headerLog.getDelegate().isDebugEnabled()) {
            this.headerLog.debug((Function0)new Function0<Object>(this, response){
                final /* synthetic */ MyApacheDefaultManagedHttpClientConnection this$0;
                final /* synthetic */ HttpResponse $response;
                {
                    this.this$0 = $receiver;
                    this.$response = $response;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return this.this$0.getId() + " << " + this.$response.getStatusLine();
                }
            });
            Header[] headers = response.getAllHeaders();
            Intrinsics.checkNotNull((Object)headers);
            for (Header header : headers) {
                this.headerLog.debug((Function0)new Function0<Object>(this, header){
                    final /* synthetic */ MyApacheDefaultManagedHttpClientConnection this$0;
                    final /* synthetic */ Header $header;
                    {
                        this.this$0 = $receiver;
                        this.$header = $header;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return this.this$0.getId() + " << " + this.$header;
                    }
                });
            }
        }
    }

    protected void onRequestSubmitted(@Nullable HttpRequest request) {
        if (request != null && this.headerLog.getDelegate().isDebugEnabled()) {
            this.headerLog.debug((Function0)new Function0<Object>(this, request){
                final /* synthetic */ MyApacheDefaultManagedHttpClientConnection this$0;
                final /* synthetic */ HttpRequest $request;
                {
                    this.this$0 = $receiver;
                    this.$request = $request;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return this.this$0.getId() + " >> " + this.$request.getRequestLine();
                }
            });
            Header[] headers = request.getAllHeaders();
            Intrinsics.checkNotNull((Object)headers);
            for (Header header : headers) {
                this.headerLog.debug((Function0)new Function0<Object>(this, header){
                    final /* synthetic */ MyApacheDefaultManagedHttpClientConnection this$0;
                    final /* synthetic */ Header $header;
                    {
                        this.this$0 = $receiver;
                        this.$header = $header;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return this.this$0.getId() + " >> " + this.$header;
                    }
                });
            }
        }
    }

    @NotNull
    public KotlinLogger getLogger() {
        return Logging.DefaultImpls.getLogger((Logging)this);
    }
}

