/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.http.jetty;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.server.HttpInput;
import org.eclipse.jetty.util.component.Destroyable;
import org.somda.sdc.common.logging.InstanceLogger;

public class CommunicationLogInputInterceptor
implements HttpInput.Interceptor,
Destroyable {
    private static final Logger LOG = LogManager.getLogger(CommunicationLogInputInterceptor.class);
    private final OutputStream commlogStream;
    private final Logger instanceLogger;

    CommunicationLogInputInterceptor(OutputStream commlogStream, String frameworkIdentifier) {
        this.instanceLogger = InstanceLogger.wrapLogger((Logger)LOG, (String)frameworkIdentifier);
        this.commlogStream = commlogStream;
    }

    public HttpInput.Content readFrom(HttpInput.Content content) {
        if (content == null) {
            return null;
        }
        try {
            if (content.isSpecial()) {
                if (content.isEof()) {
                    this.commlogStream.close();
                    this.instanceLogger.trace("EOF received, commlog stream closed");
                } else if (content.getError() != null) {
                    this.commlogStream.close();
                    this.instanceLogger.debug("Commlog stream closed, jetty reported error ", content.getError());
                }
            } else {
                int oldPosition = content.getByteBuffer().position();
                WritableByteChannel writableByteChannel = Channels.newChannel(this.commlogStream);
                writableByteChannel.write(content.getByteBuffer());
                content.getByteBuffer().position(oldPosition);
            }
        }
        catch (IOException e) {
            this.instanceLogger.error("Error while writing to communication log stream", (Throwable)e);
        }
        return content;
    }

    public void destroy() {
        try {
            this.commlogStream.close();
        }
        catch (IOException e) {
            this.instanceLogger.error("Error while closing communication log stream", (Throwable)e);
        }
    }
}

