/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.http.jetty;

import com.google.common.base.Strings;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.inject.name.Named;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.jspecify.annotations.Nullable;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.dpws.CommunicationLog;
import org.somda.sdc.dpws.CommunicationLogContext;
import org.somda.sdc.dpws.http.HttpException;
import org.somda.sdc.dpws.http.HttpHandler;
import org.somda.sdc.dpws.http.jetty.JettyUtil;
import org.somda.sdc.dpws.soap.CommunicationContext;
import org.somda.sdc.dpws.soap.HttpApplicationInfo;
import org.somda.sdc.dpws.soap.TransportInfo;

public class JettyHttpServerHandler
extends AbstractHandler {
    public static final String SERVER_HEADER_KEY = "X-Server";
    public static final String SERVER_HEADER_VALUE = "SDCri";
    private static final Logger LOG = LogManager.getLogger(JettyHttpServerHandler.class);
    private final String mediaType;
    private final HttpHandler handler;
    private final Logger instanceLogger;
    private final boolean chunkedTransfer;
    private final String charset;
    private final @Nullable CommunicationLog communicationLog;
    private final String frameworkIdentifier;
    private final @Nullable CommunicationLogContext communicationLogContext;
    private final @Nullable UnaryOperator<Void> postResponseHandler;

    @AssistedInject
    JettyHttpServerHandler(@Assisted String mediaType, @Assisted HttpHandler handler, @Assisted @Nullable CommunicationLog communicationLog, @Assisted @Nullable CommunicationLogContext communicationLogContext, @Named(value="Common.InstanceIdentifier") String frameworkIdentifier, @Named(value="Dpws.EnforceHttpChunked") boolean chunkedTransfer, @Named(value="Dpws.HttpCharset") String charset) {
        this(mediaType, handler, communicationLog, communicationLogContext, null, frameworkIdentifier, chunkedTransfer, charset);
    }

    @AssistedInject
    JettyHttpServerHandler(@Assisted String mediaType, @Assisted HttpHandler handler, @Assisted @Nullable CommunicationLog communicationLog, @Assisted @Nullable CommunicationLogContext communicationLogContext, @Assisted @Nullable UnaryOperator<Void> postResponseHandler, @Named(value="Common.InstanceIdentifier") String frameworkIdentifier, @Named(value="Dpws.EnforceHttpChunked") boolean chunkedTransfer, @Named(value="Dpws.HttpCharset") String charset) {
        this.instanceLogger = InstanceLogger.wrapLogger((Logger)LOG, (String)frameworkIdentifier);
        this.mediaType = mediaType;
        this.handler = handler;
        this.chunkedTransfer = chunkedTransfer;
        this.charset = charset;
        this.communicationLog = communicationLog;
        this.frameworkIdentifier = frameworkIdentifier;
        this.communicationLogContext = communicationLogContext;
        this.postResponseHandler = postResponseHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        java.util.function.Supplier<String> remoteNodeInfo = () -> JettyHttpServerHandler.getRemoteNodeInfo(request);
        Optional<Object> transactionIdOpt = Optional.ofNullable(baseRequest.getAttribute(CommunicationLog.MessageType.REQUEST.name()));
        String transactionId = (String)transactionIdOpt.orElse("");
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = remoteNodeInfo::get;
        supplierArray[1] = () -> ((HttpServletRequest)request).getRequestURL();
        this.instanceLogger.debug("{}: Request to {}", supplierArray);
        HttpOutput out = baseRequest.getResponse().getHttpOutput();
        HttpOutput.Interceptor previousInterceptor = out.getInterceptor();
        HttpApplicationInfo requestHttpApplicationInfo = new HttpApplicationInfo(JettyUtil.getRequestHeaders(request), transactionId, baseRequest.getRequestURI());
        JettyUtil.handleCommlog(this.communicationLog, baseRequest, request, this.communicationLogContext, requestHttpApplicationInfo, this.frameworkIdentifier, previousInterceptor, out, transactionId);
        response.setStatus(200);
        response.setContentType(this.mediaType);
        response.setCharacterEncoding(this.charset);
        response.setHeader(SERVER_HEADER_KEY, SERVER_HEADER_VALUE);
        ByteArrayOutputStream tempOut = new ByteArrayOutputStream();
        ServletInputStream input = request.getInputStream();
        try {
            this.handler.handle((InputStream)input, tempOut, new CommunicationContext(requestHttpApplicationInfo, new TransportInfo(request.getScheme(), request.getLocalAddr(), request.getLocalPort(), request.getRemoteAddr(), request.getRemotePort(), JettyHttpServerHandler.getX509Certificates(request, baseRequest.isSecure())), this.communicationLogContext));
        }
        catch (HttpException e) {
            Supplier[] supplierArray2 = new Supplier[2];
            supplierArray2[0] = remoteNodeInfo::get;
            supplierArray2[1] = e::getMessage;
            this.instanceLogger.warn("{}: An HTTP exception occurred during HTTP request processing. Error message: {}", supplierArray2);
            this.instanceLogger.trace(() -> String.format("%s: An HTTP exception occurred during HTTP request processing", remoteNodeInfo.get()), (Throwable)e);
            response.setStatus(e.getStatusCode());
            String message = e.getMessage();
            if (!Strings.isNullOrEmpty((String)message)) {
                tempOut.write(message.getBytes(StandardCharsets.UTF_8));
            }
        }
        finally {
            baseRequest.setHandled(true);
        }
        byte[] tempOutValue = tempOut.toByteArray();
        if (this.chunkedTransfer) {
            response.setHeader("Transfer-Encoding", "chunked");
        } else {
            response.setHeader("Content-Length", String.valueOf(tempOutValue.length));
        }
        ServletOutputStream output = response.getOutputStream();
        output.write(tempOutValue);
        try {
            input.close();
            output.flush();
            output.close();
        }
        catch (IOException e) {
            Supplier[] supplierArray3 = new Supplier[3];
            supplierArray3[0] = remoteNodeInfo::get;
            supplierArray3[1] = () -> ((HttpServletRequest)request).getRequestURL();
            supplierArray3[2] = e::getMessage;
            this.instanceLogger.error("{}: Could not close input/output streams from incoming HTTP request to {}. Reason: {}", supplierArray3);
            this.instanceLogger.trace(() -> String.format("%s: Could not close input/output streams from incoming HTTP request to %s", remoteNodeInfo.get(), request.getRequestURL()), (Throwable)e);
        }
        finally {
            if (this.communicationLog != null) {
                out.setInterceptor(previousInterceptor);
            }
        }
        if (this.postResponseHandler != null) {
            this.postResponseHandler.apply(null);
        }
    }

    static List<X509Certificate> getX509Certificates(HttpServletRequest request, boolean expectTLS) throws IOException {
        if (!expectTLS) {
            return Collections.emptyList();
        }
        Object anonymousCertificates = request.getAttribute("jakarta.servlet.request.X509Certificate");
        if (anonymousCertificates == null) {
            LOG.error("{}: Certificate information is missing from HTTP request data", new Supplier[]{() -> JettyHttpServerHandler.getRemoteNodeInfo(request)});
            throw new IOException("Certificate information is missing from HTTP request data");
        }
        if (anonymousCertificates instanceof X509Certificate[]) {
            X509Certificate[] x509Certificates = (X509Certificate[])anonymousCertificates;
            return List.of(x509Certificates);
        }
        LOG.error("Certificate information is of an unexpected type: {}", anonymousCertificates.getClass());
        throw new IOException(String.format("Certificate information is of an unexpected type: %s", anonymousCertificates.getClass()));
    }

    private static String getRemoteNodeInfo(HttpServletRequest request) {
        return String.format("%s://%s:%s", request.getScheme(), request.getRemoteAddr(), request.getRemotePort());
    }
}

