/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.http.jetty;

import com.google.common.util.concurrent.AbstractIdleService;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.time.Duration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.UnaryOperator;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.eclipse.jetty.http.HttpCompliance;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.RetainableByteBufferPool;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.io.ssl.SslHandshakeListener;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.DetectorConnectionFactory;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.jspecify.annotations.Nullable;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.dpws.CommunicationLog;
import org.somda.sdc.dpws.CommunicationLogContext;
import org.somda.sdc.dpws.crypto.CryptoConfigurator;
import org.somda.sdc.dpws.crypto.CryptoSettings;
import org.somda.sdc.dpws.factory.CommunicationLogFactory;
import org.somda.sdc.dpws.http.HttpConnectionInterceptor;
import org.somda.sdc.dpws.http.HttpHandler;
import org.somda.sdc.dpws.http.HttpServerRegistry;
import org.somda.sdc.dpws.http.HttpUriBuilder;
import org.somda.sdc.dpws.http.jetty.CommunicationLogHandlerWrapper;
import org.somda.sdc.dpws.http.jetty.JettyHttpServerHandler;
import org.somda.sdc.dpws.http.jetty.JettyServerData;
import org.somda.sdc.dpws.http.jetty.MyJettySslConnection;
import org.somda.sdc.dpws.http.jetty.factory.JettyHttpServerHandlerFactory;

public class JettyHttpServerRegistry
extends AbstractIdleService
implements HttpServerRegistry {
    private static final Logger LOG = LogManager.getLogger(JettyHttpServerRegistry.class);
    private static final String URI_CONVERSION_ERROR_MSG = "Unexpected URI conversion error";
    private final JettyHttpServerHandlerFactory jettyHttpServerHandlerFactory;
    private final String frameworkIdentifier;
    private final Logger instanceLogger;
    private final CommunicationLog defaultCommunicationLog;
    private final Map<String, Server> serverRegistry;
    private final Map<Server, JettyServerData> serverData;
    private final Lock registryLock;
    private final HttpUriBuilder uriBuilder;
    private final boolean enableGzipCompression;
    private final int minCompressionSize;
    private final String[] tlsProtocols;
    private final String[] enabledCiphers;
    private final HostnameVerifier hostnameVerifier;
    private final boolean enableHttp;
    private final boolean enableHttps;
    private final Duration connectionTimeout;
    private SSLContext sslContext;
    private final boolean commlogInHandler;
    private final int threadPoolSize;
    private final boolean enableJmx;
    private final HttpConnectionInterceptor httpConnectionInterceptor;

    @Inject
    JettyHttpServerRegistry(HttpUriBuilder uriBuilder, CryptoConfigurator cryptoConfigurator, @Named(value="Dpws.Crypto.Settings") @Nullable CryptoSettings cryptoSettings, JettyHttpServerHandlerFactory jettyHttpServerHandlerFactory, @Named(value="Dpws.GzipCompression") boolean enableGzipCompression, @Named(value="Dpws.GzipCompressionMinSize") int minCompressionSize, @Named(value="Dpws.Crypto.TlsEnabledVersions") String[] tlsProtocols, @Named(value="Dpws.Crypto.TlsEnabledCiphers") String[] enabledCiphers, @Named(value="Dpws.Crypto.DeviceHostnameVerifier") HostnameVerifier hostnameVerifier, @Named(value="Dpws.EnableHttps") boolean enableHttps, @Named(value="Dpws.EnableHttp") boolean enableHttp, @Named(value="Dpws.HttpServerConnectionTimeout") Duration connectionTimeout, @Named(value="Dpws.ServerCommlogInHandler") boolean commlogInHandler, @Named(value="Dpws.ServerThreadPoolSize") int threadPoolSize, @Named(value="Dpws.ServerEnableJmx") boolean enableJmx, CommunicationLogFactory communicationLogFactory, @Named(value="Common.InstanceIdentifier") String frameworkIdentifier, @Named(value="Dpws.HttpConnectionInterceptor") HttpConnectionInterceptor httpConnectionInterceptor) {
        this.instanceLogger = InstanceLogger.wrapLogger((Logger)LOG, (String)frameworkIdentifier);
        this.frameworkIdentifier = frameworkIdentifier;
        this.uriBuilder = uriBuilder;
        this.jettyHttpServerHandlerFactory = jettyHttpServerHandlerFactory;
        this.enableGzipCompression = enableGzipCompression;
        this.minCompressionSize = minCompressionSize;
        this.tlsProtocols = tlsProtocols;
        this.enabledCiphers = enabledCiphers;
        this.hostnameVerifier = hostnameVerifier;
        this.defaultCommunicationLog = communicationLogFactory.createCommunicationLog();
        this.enableHttps = enableHttps;
        this.enableHttp = enableHttp;
        this.connectionTimeout = connectionTimeout;
        this.commlogInHandler = commlogInHandler;
        this.threadPoolSize = threadPoolSize;
        this.enableJmx = enableJmx;
        this.httpConnectionInterceptor = httpConnectionInterceptor;
        this.serverRegistry = new HashMap<String, Server>();
        this.serverData = new HashMap<Server, JettyServerData>();
        this.registryLock = new ReentrantLock();
        this.configureSsl(cryptoConfigurator, cryptoSettings);
        if (!this.enableHttp && !this.enableHttps) {
            throw new RuntimeException("Http and https are disabled, cannot continue");
        }
    }

    protected void startUp() throws Exception {
        this.instanceLogger.info("{} is running", (Object)this.getClass().getSimpleName());
    }

    protected void shutDown() throws Exception {
        this.instanceLogger.info("Shut down running HTTP servers");
        this.registryLock.lock();
        try {
            this.serverRegistry.forEach((uri, server) -> {
                try {
                    server.stop();
                    this.instanceLogger.info("Shut down HTTP server at {}", uri);
                    JettyServerData data = this.serverData.remove(server);
                    if (data != null) {
                        data.getContextHandlerCollection().stop();
                        this.instanceLogger.info("Shut down HTTP context handler collection at {}", uri);
                        data.getHandlerRegistry().forEach((handlerUri, handler) -> {
                            try {
                                handler.stop();
                            }
                            catch (Exception e) {
                                this.instanceLogger.warn("HTTP handler could not be stopped properly", (Throwable)e);
                            }
                        });
                        data.getContextWrapperRegistry().forEach((contextPath, wrapper) -> {
                            try {
                                wrapper.stop();
                            }
                            catch (Exception e) {
                                this.instanceLogger.warn("HTTP handler wrapper could not be stopped properly", (Throwable)e);
                            }
                        });
                    }
                }
                catch (Exception e) {
                    this.instanceLogger.warn("HTTP server could not be stopped properly", (Throwable)e);
                }
            });
            this.serverRegistry.clear();
        }
        finally {
            this.registryLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String initHttpServer(String schemeAndAuthority, boolean allowReuse) {
        this.registryLock.lock();
        try {
            CommunicationLog commlogToUse = this.commlogInHandler ? null : this.defaultCommunicationLog;
            Server server = this.makeHttpServer(schemeAndAuthority, commlogToUse, allowReuse);
            String uriString = server.getURI().toString();
            if (uriString.endsWith("/")) {
                uriString = uriString.substring(0, uriString.length() - 1);
            }
            URI serverUri = URI.create(uriString);
            URI requestedUri = URI.create(schemeAndAuthority);
            if (!serverUri.getScheme().equals(requestedUri.getScheme())) {
                try {
                    serverUri = this.replaceScheme(serverUri, requestedUri.getScheme());
                }
                catch (URISyntaxException e) {
                    this.instanceLogger.error("Unexpected error while creating server uri value with uri {} and new scheme {} value: {}", (Object)serverUri, (Object)requestedUri.getScheme(), (Object)e.getMessage());
                    this.instanceLogger.trace("Unexpected error while creating server uri value with uri {} and new scheme {} value", (Object)serverUri, (Object)requestedUri.getScheme(), (Object)e);
                }
            }
            String string = serverUri.toString();
            return string;
        }
        finally {
            this.registryLock.unlock();
        }
    }

    @Override
    @Deprecated(forRemoval=true)
    public String registerContext(String schemeAndAuthority, boolean allowReuse, String contextPath, @Nullable String mediaType, @Nullable CommunicationLogContext communicationLogContext, HttpHandler handler) {
        return this.registerContext(schemeAndAuthority, allowReuse, contextPath, mediaType, communicationLogContext, handler, null);
    }

    @Override
    public String registerContext(String schemeAndAuthority, boolean allowReuse, String contextPath, @Nullable String mediaType, @Nullable CommunicationLogContext communicationLogContext, HttpHandler requestHandler, @Nullable UnaryOperator<Void> postResponseHandler) {
        String mediaTypeToUse;
        CommunicationLog commLogToUse = this.defaultCommunicationLog;
        String string = mediaTypeToUse = mediaType != null ? mediaType : "application/soap+xml";
        if (!contextPath.startsWith("/")) {
            throw new RuntimeException(String.format("Context path needs to start with a slash, but is %s", contextPath));
        }
        this.registryLock.lock();
        try {
            ImmutablePair<String, Integer> mapKey;
            CommunicationLog serverCommlog = this.commlogInHandler ? null : commLogToUse;
            Server server = this.makeHttpServer(schemeAndAuthority, serverCommlog, allowReuse);
            try {
                mapKey = this.makeMapKey(server.getURI().toString(), contextPath);
            }
            catch (UnknownHostException e) {
                this.instanceLogger.error(URI_CONVERSION_ERROR_MSG, (Throwable)e);
                throw new RuntimeException(URI_CONVERSION_ERROR_MSG, e);
            }
            URI mapKeyUri = URI.create((String)mapKey.left);
            CommunicationLog endpointCommlog = this.commlogInHandler ? commLogToUse : null;
            JettyHttpServerHandler endpointHandler = this.jettyHttpServerHandlerFactory.create(mediaTypeToUse, requestHandler, endpointCommlog, communicationLogContext, postResponseHandler);
            ContextHandler context = new ContextHandler(contextPath);
            context.setHandler((Handler)endpointHandler);
            context.setAllowNullPathInfo(true);
            JettyServerData jettyServerData = this.serverData.get(server);
            jettyServerData.getHandlerRegistry().put(mapKeyUri.toString(), endpointHandler);
            jettyServerData.getContextWrapperRegistry().put(contextPath, context);
            jettyServerData.getContextHandlerCollection().addHandler((Handler)context);
            context.start();
            URI contextUri = this.replaceScheme(mapKeyUri, URI.create(schemeAndAuthority).getScheme());
            String string2 = contextUri.toString();
            return string2;
        }
        catch (Exception e) {
            this.instanceLogger.error("Registering context {} failed.", (Object)contextPath, (Object)e);
            throw new RuntimeException(e);
        }
        finally {
            this.registryLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterContext(String schemeAndAuthority, String contextPath) {
        this.registryLock.lock();
        try {
            ImmutablePair<String, Integer> httpHandlerRegistryPair;
            ImmutablePair<String, Integer> serverRegistryPair;
            try {
                serverRegistryPair = this.makeMapKey(schemeAndAuthority);
                httpHandlerRegistryPair = this.makeMapKey(schemeAndAuthority, contextPath);
            }
            catch (UnknownHostException e) {
                this.instanceLogger.error(URI_CONVERSION_ERROR_MSG, (Throwable)e);
                throw new RuntimeException(URI_CONVERSION_ERROR_MSG, e);
            }
            Optional.ofNullable(this.serverRegistry.get(serverRegistryPair.left)).ifPresent(httpServer -> {
                JettyServerData jettyServerData = this.serverData.get(httpServer);
                if (jettyServerData != null) {
                    JettyHttpServerHandler handler = jettyServerData.getHandlerRegistry().remove(httpHandlerRegistryPair.left);
                    Optional.ofNullable(handler).ifPresent(handlerWrapper -> {
                        this.instanceLogger.info("Unregister context path '{}'", (Object)contextPath);
                        ContextHandler removedHandler = jettyServerData.getContextWrapperRegistry().remove(contextPath);
                        jettyServerData.getContextHandlerCollection().removeHandler((Handler)removedHandler);
                    });
                }
                if (jettyServerData == null || jettyServerData.getHandlerRegistry().isEmpty()) {
                    this.instanceLogger.info("No further HTTP handlers active. Shutdown HTTP server at '{}'", (Object)schemeAndAuthority);
                    this.stopServer(this.serverRegistry.remove(serverRegistryPair.left));
                }
            });
        }
        finally {
            this.registryLock.unlock();
        }
    }

    private void stopServer(Server server) {
        try {
            server.stop();
        }
        catch (Exception e) {
            this.instanceLogger.error("Could not stop HTTP server", (Throwable)e);
        }
        JettyServerData jettyServerData = this.serverData.remove(server);
        if (jettyServerData != null) {
            if (jettyServerData.getHandlerRegistry().size() != 0) {
                LOG.warn("Lingering handlers in shut down server");
            }
            try {
                jettyServerData.getContextHandlerCollection().stop();
            }
            catch (Exception e) {
                this.instanceLogger.error("Could not stop HTTP ContextHandlerCollection", (Throwable)e);
            }
            for (ContextHandler x : jettyServerData.getContextWrapperRegistry().values()) {
                try {
                    x.stop();
                }
                catch (Exception e) {
                    this.instanceLogger.error("Could not stop HTTP ContextHandler", (Throwable)e);
                }
            }
        }
    }

    private void configureSsl(CryptoConfigurator cryptoConfigurator, @Nullable CryptoSettings cryptoSettings) {
        if (cryptoSettings == null) {
            this.sslContext = null;
            return;
        }
        try {
            this.sslContext = cryptoConfigurator.createSslContextFromCryptoConfig(cryptoSettings);
        }
        catch (IOException | IllegalArgumentException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            this.instanceLogger.warn("Could not read server crypto config, fallback to system properties");
            this.sslContext = cryptoConfigurator.createSslContextFromSystemProperties();
        }
    }

    private Server makeHttpServer(String uri, @Nullable CommunicationLog communicationLog, boolean allowReuse) {
        ImmutablePair<String, Integer> mapKeyPair;
        try {
            mapKeyPair = this.makeMapKey(uri);
        }
        catch (UnknownHostException e) {
            this.instanceLogger.error(URI_CONVERSION_ERROR_MSG, (Throwable)e);
            throw new RuntimeException(URI_CONVERSION_ERROR_MSG, e);
        }
        Optional<Server> oldServer = allowReuse && (Integer)mapKeyPair.getRight() == 0 ? this.serverRegistry.values().stream().findFirst() : Optional.ofNullable(this.serverRegistry.get(mapKeyPair.getLeft()));
        if (oldServer.isPresent()) {
            this.instanceLogger.debug("Re-use running HTTP server from URI: {}", (Object)oldServer.get().getURI().getHost());
            return oldServer.get();
        }
        this.instanceLogger.debug("Init new HTTP server from URI: {}", (Object)uri);
        Server httpServer = this.createHttpServer(URI.create(uri), communicationLog);
        try {
            httpServer.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String serverUri = httpServer.getURI().toString();
        try {
            this.serverRegistry.put((String)this.makeMapKey((String)serverUri).left, httpServer);
        }
        catch (UnknownHostException e) {
            this.instanceLogger.error(URI_CONVERSION_ERROR_MSG, (Throwable)e);
            throw new RuntimeException(URI_CONVERSION_ERROR_MSG, e);
        }
        this.instanceLogger.debug("New HTTP server initialized: {}", (Object)uri);
        return httpServer;
    }

    private Server createHttpServer(URI uri, @Nullable CommunicationLog communicationLog) {
        this.instanceLogger.info("Setup HTTP server for address '{}'", (Object)uri);
        if (!this.isSupportedScheme(uri)) {
            throw new RuntimeException(String.format("HTTP server setup failed. Unsupported scheme: %s", uri.getScheme()));
        }
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSecureScheme(HttpScheme.HTTPS.asString());
        httpConfig.setHttpCompliance(HttpCompliance.RFC2616);
        Server server = new Server((ThreadPool)new QueuedThreadPool(this.threadPoolSize));
        if (this.enableJmx) {
            MBeanContainer mbeanContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
            server.addBean((Object)mbeanContainer);
        }
        ContextHandlerCollection context = new ContextHandlerCollection();
        server.setHandler((Handler)context);
        JettyServerData jettyServerData = new JettyServerData(context);
        this.serverData.put(server, jettyServerData);
        CommunicationLogHandlerWrapper commlogHandler = new CommunicationLogHandlerWrapper(communicationLog, this.frameworkIdentifier);
        commlogHandler.setHandler(server.getHandler());
        server.setHandler((Handler)commlogHandler);
        if (this.enableGzipCompression) {
            GzipHandler gzipHandler = new GzipHandler();
            gzipHandler.setIncludedMethods(new String[]{HttpMethod.PUT.asString(), HttpMethod.POST.asString(), HttpMethod.GET.asString()});
            gzipHandler.setInflateBufferSize(2048);
            gzipHandler.setHandler(server.getHandler());
            gzipHandler.setMinGzipSize(this.minCompressionSize);
            gzipHandler.setIncludedMimeTypes(new String[]{"text/plain", "text/html", "application/soap+xml", "text/xml"});
            server.setHandler((Handler)gzipHandler);
        }
        if (this.sslContext != null && this.enableHttps) {
            SslContextFactory.Server contextFactory = new SslContextFactory.Server();
            contextFactory.setSslContext(this.sslContext);
            contextFactory.setNeedClientAuth(true);
            this.instanceLogger.debug("Enabled protocols: {}", new Supplier[]{() -> List.of(this.tlsProtocols)});
            contextFactory.setExcludeProtocols(new String[0]);
            contextFactory.setIncludeProtocols(this.tlsProtocols);
            contextFactory.setExcludeCipherSuites(new String[0]);
            contextFactory.setIncludeCipherSuites(this.enabledCiphers);
            HttpConfiguration httpsConfig = new HttpConfiguration(httpConfig);
            httpsConfig.addCustomizer((connector, channelConfig, request) -> {
                long numRequest = request.getHttpChannel().getRequests();
                if (numRequest != 1L) {
                    this.instanceLogger.debug("Connection already verified");
                    return;
                }
                EndPoint endp = request.getHttpChannel().getEndPoint();
                if (endp instanceof SslConnection.DecryptedEndPoint) {
                    SslConnection.DecryptedEndPoint sslEndp = (SslConnection.DecryptedEndPoint)endp;
                    SslConnection sslConnection = sslEndp.getSslConnection();
                    SSLEngine sslEngine = sslConnection.getSSLEngine();
                    SSLSession session = sslEngine.getSession();
                    if (!this.hostnameVerifier.verify(sslEndp.getLocalAddress().getHostString(), session)) {
                        this.instanceLogger.debug("HostnameVerifier has filtered request, marking request as handled and aborting request");
                        request.setHandled(true);
                        request.getHttpChannel().abort((Throwable)new Exception("HostnameVerifier has rejected request"));
                    }
                }
            });
            httpsConfig.addCustomizer((connector, channelConfig, request) -> {
                EndPoint endPoint = request.getHttpChannel().getEndPoint();
                if (!(endPoint instanceof SslConnection.DecryptedEndPoint)) {
                    return;
                }
                SslConnection.DecryptedEndPoint decryptedEndPoint = (SslConnection.DecryptedEndPoint)endPoint;
                SslConnection sslConnection = decryptedEndPoint.getSslConnection();
                if (!(sslConnection instanceof MyJettySslConnection)) {
                    return;
                }
                final MyJettySslConnection myConnection = (MyJettySslConnection)sslConnection;
                SSLSession sslSession = myConnection.getSSLEngine().getSession();
                if (sslSession != null && request.getHttpChannel().getRequests() == 1L) {
                    this.httpConnectionInterceptor.onFirstIntercept(myConnection.getConnectionId(), sslSession, HttpConnectionInterceptor.Source.SERVER);
                    myConnection.addEventListener((EventListener)new Connection.Listener(){

                        public void onOpened(Connection connection) {
                        }

                        public void onClosed(Connection connection) {
                            JettyHttpServerRegistry.this.httpConnectionInterceptor.onLastIntercept(myConnection.getConnectionId());
                        }
                    });
                }
                this.httpConnectionInterceptor.onIntercept(myConnection.getConnectionId());
            });
            SecureRequestCustomizer src = new SecureRequestCustomizer();
            src.setSniHostCheck(false);
            httpsConfig.addCustomizer((HttpConfiguration.Customizer)src);
            SslConnectionFactory connectionFactory = new SslConnectionFactory(contextFactory, HttpVersion.HTTP_1_1.asString()){

                protected SslConnection newSslConnection(Connector connector, EndPoint endPoint, SSLEngine engine) {
                    ByteBufferPool byteBufferPool = connector.getByteBufferPool();
                    RetainableByteBufferPool retainableByteBufferPool = byteBufferPool.asRetainableByteBufferPool();
                    return new MyJettySslConnection(retainableByteBufferPool, byteBufferPool, connector.getExecutor(), endPoint, engine, this.isDirectBuffersForEncryption(), this.isDirectBuffersForDecryption());
                }
            };
            HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory(httpsConfig);
            ServerConnector httpsConnector = this.enableHttp ? new ServerConnector(server, new ConnectionFactory[]{new DetectorConnectionFactory(new ConnectionFactory.Detecting[]{connectionFactory}), connectionFactory, httpConnectionFactory}) : new ServerConnector(server, new ConnectionFactory[]{connectionFactory, httpConnectionFactory});
            httpsConnector.setIdleTimeout(this.connectionTimeout.toMillis());
            httpsConnector.setHost(uri.getHost());
            httpsConnector.setPort(uri.getPort());
            httpsConnector.addBean((Object)new SslHandshakeListener(){

                public void handshakeSucceeded(SslHandshakeListener.Event event) {
                }

                public void handshakeFailed(SslHandshakeListener.Event event, Throwable failure) {
                    List<Certificate> peerCertificates;
                    SSLSession session = event.getSSLEngine().getSession();
                    InetSocketAddress peerAddress = InetSocketAddress.createUnresolved(session.getPeerHost(), session.getPeerPort());
                    try {
                        peerCertificates = List.of(session.getPeerCertificates());
                    }
                    catch (SSLPeerUnverifiedException e) {
                        JettyHttpServerRegistry.this.instanceLogger.debug("Cannot get peer certificates for failed SSL handshake", (Throwable)e);
                        peerCertificates = List.of();
                    }
                    JettyHttpServerRegistry.this.httpConnectionInterceptor.onServerSslHandshakeFailure(failure, peerAddress, peerCertificates);
                }
            });
            server.setConnectors(new Connector[]{httpsConnector});
        } else {
            HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory();
            ServerConnector httpConnector = new ServerConnector(server, new ConnectionFactory[]{httpConnectionFactory});
            httpConnector.setIdleTimeout(this.connectionTimeout.toMillis());
            httpConnector.setHost(uri.getHost());
            httpConnector.setPort(uri.getPort());
            server.setConnectors(new Connector[]{httpConnector});
        }
        return server;
    }

    private ImmutablePair<String, Integer> makeMapKey(String uri) throws UnknownHostException {
        URI parsedUri = URI.create(uri);
        InetAddress address = InetAddress.getByName(parsedUri.getHost());
        return new ImmutablePair((Object)this.uriBuilder.buildUri("httpx", address.getHostAddress(), parsedUri.getPort()), (Object)parsedUri.getPort());
    }

    private ImmutablePair<String, Integer> makeMapKey(String uri, String contextPath) throws UnknownHostException {
        ImmutablePair<String, Integer> pair = this.makeMapKey(uri);
        return new ImmutablePair((Object)((String)pair.getLeft() + contextPath), (Object)((Integer)pair.getRight()));
    }

    private URI replaceScheme(URI baseUri, String scheme) throws URISyntaxException {
        return new URI(scheme, baseUri.getUserInfo(), baseUri.getHost(), baseUri.getPort(), baseUri.getPath(), baseUri.getQuery(), baseUri.getFragment());
    }

    private boolean isSupportedScheme(URI address) {
        return this.enableHttp && HttpScheme.HTTP.asString().equalsIgnoreCase(address.getScheme()) || this.enableHttps && HttpScheme.HTTPS.asString().equalsIgnoreCase(address.getScheme());
    }
}

