/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.service;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.inject.name.Named;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import java.io.ByteArrayInputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.dpws.device.helper.ByteResourceHandler;
import org.somda.sdc.dpws.http.HttpServerRegistry;
import org.somda.sdc.dpws.service.HostedService;
import org.somda.sdc.dpws.service.helper.MetadataSectionUtil;
import org.somda.sdc.dpws.soap.SoapUtil;
import org.somda.sdc.dpws.soap.interception.Direction;
import org.somda.sdc.dpws.soap.interception.Interceptor;
import org.somda.sdc.dpws.soap.interception.MessageInterceptor;
import org.somda.sdc.dpws.soap.interception.RequestResponseObject;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingUtil;
import org.somda.sdc.dpws.soap.wsaddressing.model.EndpointReferenceType;
import org.somda.sdc.dpws.soap.wsdiscovery.WsDiscoveryTargetService;
import org.somda.sdc.dpws.soap.wsmetadataexchange.model.GetMetadata;
import org.somda.sdc.dpws.soap.wsmetadataexchange.model.Metadata;
import org.somda.sdc.dpws.soap.wsmetadataexchange.model.MetadataSection;
import org.somda.sdc.dpws.soap.wsmetadataexchange.model.ObjectFactory;
import org.somda.sdc.dpws.wsdl.WsdlMarshalling;
import org.somda.sdc.dpws.wsdl.WsdlProvisioningMode;
import org.somda.sdc.dpws.wsdl.model.TDefinitions;

public class HostedServiceInterceptor
implements Interceptor {
    private static final Logger LOG = LogManager.getLogger(HostedServiceInterceptor.class);
    private final HostedService hostedService;
    private final WsDiscoveryTargetService targetService;
    private final SoapUtil soapUtil;
    private final ObjectFactory mexFactory;
    private final org.somda.sdc.dpws.wsdl.model.ObjectFactory wsdlFactory;
    private final WsAddressingUtil wsaUtil;
    private final MetadataSectionUtil metadataSectionUtil;
    private final WsdlMarshalling wsdlMarshalling;
    private final HttpServerRegistry httpServerRegistry;
    private String wsdlUri;
    private JAXBElement<TDefinitions> wsdlDefinition;
    private WsdlProvisioningMode provisioningMode;

    @AssistedInject
    HostedServiceInterceptor(@Assisted HostedService hostedService, @Assisted WsDiscoveryTargetService targetService, @Named(value="Dpws.WsdlProvisioningMode") WsdlProvisioningMode provisioningMode, SoapUtil soapUtil, ObjectFactory mexFactory, org.somda.sdc.dpws.wsdl.model.ObjectFactory wsdlFactory, WsAddressingUtil wsaUtil, MetadataSectionUtil metadataSectionUtil, WsdlMarshalling wsdlMarshalling, HttpServerRegistry httpServerRegistry) {
        this.hostedService = hostedService;
        this.targetService = targetService;
        this.soapUtil = soapUtil;
        this.mexFactory = mexFactory;
        this.wsdlFactory = wsdlFactory;
        this.wsaUtil = wsaUtil;
        this.metadataSectionUtil = metadataSectionUtil;
        this.provisioningMode = provisioningMode;
        this.wsdlMarshalling = wsdlMarshalling;
        this.httpServerRegistry = httpServerRegistry;
        this.wsdlUri = null;
        this.wsdlDefinition = null;
        this.setupInlineDefinition();
        this.setupWsdlResource();
    }

    @MessageInterceptor(value="http://schemas.xmlsoap.org/ws/2004/09/mex/GetMetadata/Request", direction=Direction.REQUEST)
    void processGetMetadata(RequestResponseObject rrObj) {
        GetMetadata body = this.soapUtil.getBody(rrObj.getRequest(), GetMetadata.class).orElse(null);
        Metadata metadata = this.mexFactory.createMetadata();
        List metadataSection = metadata.getMetadataSection();
        metadataSection.add(this.metadataSectionUtil.createRelationship(this.targetService.getEndpointReference(), this.targetService.getTypes(), List.of(this.hostedService)));
        if (body == null || body.getDialect() == null || body.getDialect().isEmpty() || body.getDialect().equals("http://schemas.xmlsoap.org/wsdl/")) {
            switch (this.provisioningMode) {
                case INLINE: {
                    metadataSection.add(this.createWsdlMetadataSection());
                    break;
                }
                case RESOURCE: {
                    metadataSection.add(this.createWsdlMetadataSectionAsResource());
                    break;
                }
                default: {
                    LOG.warn("Unsupported WSDL provisioning mode detected: {}", (Object)this.provisioningMode);
                }
            }
        }
        rrObj.getResponse().getWsAddressingHeader().setAction(this.wsaUtil.createAttributedURIType("http://schemas.xmlsoap.org/ws/2004/09/mex/GetMetadata/Response"));
        metadata.setMetadataSection(metadataSection);
        this.soapUtil.setBody(metadata, rrObj.getResponse());
    }

    private MetadataSection createWsdlMetadataSection() {
        MetadataSection metadataSection = this.mexFactory.createMetadataSection();
        metadataSection.setDialect("http://schemas.xmlsoap.org/wsdl/");
        metadataSection.setAny(this.wsdlDefinition);
        return metadataSection;
    }

    private MetadataSection createWsdlMetadataSectionAsResource() {
        MetadataSection metadataSection = this.mexFactory.createMetadataSection();
        metadataSection.setDialect("http://schemas.xmlsoap.org/wsdl/");
        if (this.wsdlUri == null) {
            LOG.warn("No resource link for WSDL provisioning found. Metadata section will be left empty.");
        } else {
            metadataSection.setAny((Object)this.mexFactory.createLocation(this.wsdlUri));
        }
        return metadataSection;
    }

    private void setupInlineDefinition() {
        if (WsdlProvisioningMode.INLINE != this.provisioningMode) {
            return;
        }
        try {
            this.wsdlDefinition = this.wsdlFactory.createDefinitions(this.wsdlMarshalling.unmarshal(new ByteArrayInputStream(this.hostedService.getWsdlDocument())));
        }
        catch (JAXBException e) {
            LOG.warn("Unmarshalling of WSDL failed. Fallback to resource provisioning. Error message: {}", (Object)e.getMessage());
            LOG.trace("Unmarshalling of WSDL failed", (Throwable)e);
            this.provisioningMode = WsdlProvisioningMode.RESOURCE;
        }
    }

    private void setupWsdlResource() {
        if (WsdlProvisioningMode.RESOURCE != this.provisioningMode) {
            return;
        }
        byte[] wsdlDocBytes = this.hostedService.getWsdlDocument();
        for (EndpointReferenceType epr : this.hostedService.getType().getEndpointReference()) {
            URI uri;
            if (wsdlDocBytes.length == 0) {
                throw new RuntimeException(String.format("Could not register WSDL resource for %s. WSDL is empty.", epr));
            }
            Optional<String> uriFromEpr = this.wsaUtil.getAddressUri(epr);
            if (uriFromEpr.isEmpty()) {
                throw new RuntimeException("Invalid EPR detected while trying to create WSDL resource. " + String.format("Skip EPR %s.", epr));
            }
            try {
                uri = new URI(uriFromEpr.get());
            }
            catch (URISyntaxException e) {
                LOG.warn("Invalid URI detected while trying to create WSDL resource. Skip EPR {}.", (Object)epr);
                continue;
            }
            String wsdlContextPath = uri.getPath() + "/wsdl";
            this.wsdlUri = this.httpServerRegistry.registerContext(uriFromEpr.get(), true, wsdlContextPath, "text/xml", null, new ByteResourceHandler(wsdlDocBytes), null);
            break;
        }
    }
}

