/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap.factory;

import com.google.inject.Inject;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.somda.sdc.dpws.soap.model.Body;
import org.somda.sdc.dpws.soap.model.Envelope;
import org.somda.sdc.dpws.soap.model.ObjectFactory;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingUtil;
import org.somda.sdc.dpws.soap.wsaddressing.model.AttributedURIType;

public class EnvelopeFactory {
    private final org.somda.sdc.dpws.soap.wsaddressing.model.ObjectFactory wsaFactory;
    private final ObjectFactory soapFactory;
    private final WsAddressingUtil wsaUtil;

    @Inject
    EnvelopeFactory(org.somda.sdc.dpws.soap.wsaddressing.model.ObjectFactory wsaFactory, ObjectFactory soapFactory, WsAddressingUtil wsaUtil) {
        this.wsaFactory = wsaFactory;
        this.soapFactory = soapFactory;
        this.wsaUtil = wsaUtil;
    }

    public Envelope createEnvelope(String wsaAction, @Nullable Object firstBodyChild) {
        Envelope envelope = this.createEnvelope(firstBodyChild);
        envelope.getHeader().getAny().add(this.wsaFactory.createAction(this.createUri(wsaAction)));
        return envelope;
    }

    public Envelope createEnvelope(String wsaAction, String wsaTo, @Nullable Object firstBodyChild) {
        Envelope envelope = this.createEnvelope(firstBodyChild);
        envelope.getHeader().getAny().add(this.wsaFactory.createAction(this.createUri(wsaAction)));
        envelope.getHeader().getAny().add(this.wsaFactory.createTo(this.createUri(wsaTo)));
        return envelope;
    }

    public Envelope createEnvelope(@Nullable Object firstBodyChild) {
        Envelope envelope = this.soapFactory.createEnvelope();
        envelope.setHeader(this.soapFactory.createHeader());
        envelope.setBody(this.soapFactory.createBody());
        Optional.ofNullable(firstBodyChild).ifPresent(jaxbElement -> envelope.getBody().getAny().add(jaxbElement));
        return envelope;
    }

    public Envelope createEnvelope() {
        return this.createEnvelope(null);
    }

    public Envelope createEnvelopeFromBody(Body body) {
        Envelope envelope = this.createEnvelope(null);
        envelope.setBody(body);
        return envelope;
    }

    private AttributedURIType createUri(String uri) {
        return this.wsaUtil.createAttributedURIType(uri);
    }
}

