/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap.interception;

import com.google.inject.Inject;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.somda.sdc.dpws.soap.interception.Direction;
import org.somda.sdc.dpws.soap.interception.Interceptor;
import org.somda.sdc.dpws.soap.interception.InterceptorCallbackType;
import org.somda.sdc.dpws.soap.interception.InterceptorInfo;
import org.somda.sdc.dpws.soap.interception.MessageInterceptor;

public class InterceptorRegistry {
    private final Map<Direction, Map<String, List<InterceptorInfo>>> interceptorChains = new EnumMap<Direction, Map<String, List<InterceptorInfo>>>(Direction.class);

    @Inject
    InterceptorRegistry() {
        Arrays.stream(Direction.values()).forEach(direction -> this.interceptorChains.put((Direction)((Object)direction), new ConcurrentHashMap()));
    }

    public void addInterceptor(Interceptor interceptor) {
        List<Method> actionCallbackMethods = this.getCallbackMethods(interceptor);
        for (Method method : actionCallbackMethods) {
            List<InterceptorInfo> interceptorInfoList;
            MessageInterceptor annotation = method.getAnnotation(MessageInterceptor.class);
            InterceptorInfo interceptorInfo = new InterceptorInfo(interceptor, method, annotation.sequenceNumber());
            Direction direction = annotation.direction();
            String action = annotation.value();
            if (direction != Direction.ANY) {
                interceptorInfoList = this.getInterceptorInfoList(Direction.ANY, action);
                interceptorInfoList.add(interceptorInfo);
                Collections.sort(interceptorInfoList);
            }
            interceptorInfoList = this.getInterceptorInfoList(direction, action);
            interceptorInfoList.add(interceptorInfo);
            Collections.sort(interceptorInfoList);
        }
    }

    public List<InterceptorInfo> getDefaultInterceptors() {
        return Collections.unmodifiableList(this.getInterceptors(""));
    }

    public List<InterceptorInfo> getDefaultInterceptors(Direction direction) {
        return Collections.unmodifiableList(this.getInterceptors(direction, ""));
    }

    public List<InterceptorInfo> getInterceptors(Direction direction, String action) {
        return Collections.unmodifiableList(this.getInterceptorInfoList(direction, action));
    }

    public List<InterceptorInfo> getInterceptors(String action) {
        return Collections.unmodifiableList(this.getInterceptorInfoList(Direction.ANY, action));
    }

    private List<Method> getCallbackMethods(Object obj) {
        Method[] declaredMethods = obj.getClass().getDeclaredMethods();
        return Arrays.stream(declaredMethods).filter(m -> Arrays.stream(m.getAnnotations()).anyMatch(a -> a.annotationType().equals(MessageInterceptor.class))).filter(m -> m.getParameterCount() == 1 && InterceptorCallbackType.class.isAssignableFrom(m.getParameterTypes()[0])).filter(m -> m.getReturnType().equals(Void.TYPE)).peek(method -> method.setAccessible(true)).collect(Collectors.toList());
    }

    private List<InterceptorInfo> getInterceptorInfoList(Direction direction, String action) {
        Map<String, List<InterceptorInfo>> actionMap = this.interceptorChains.get((Object)direction);
        return actionMap.computeIfAbsent(action, k -> new ArrayList());
    }
}

