/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap.wsaddressing;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import jakarta.xml.bind.JAXBElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.common.util.JaxbUtil;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingConstants;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingHeader;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingUtil;
import org.somda.sdc.dpws.soap.wsaddressing.model.AttributedURIType;
import org.somda.sdc.dpws.soap.wsaddressing.model.ObjectFactory;
import org.somda.sdc.dpws.soap.wsaddressing.model.RelatesToType;
import org.w3c.dom.Element;

public class WsAddressingMapper {
    private static final Logger LOG = LogManager.getLogger(WsAddressingMapper.class);
    private final JaxbUtil jaxbUtil;
    private final ObjectFactory wsaFactory;
    private final WsAddressingUtil wsaUtil;
    private final Logger instanceLogger;

    @Inject
    WsAddressingMapper(JaxbUtil jaxbUtil, ObjectFactory wsaFactory, WsAddressingUtil wsaUtil, @Named(value="Common.InstanceIdentifier") String frameworkIdentifier) {
        this.instanceLogger = InstanceLogger.wrapLogger((Logger)LOG, (String)frameworkIdentifier);
        this.jaxbUtil = jaxbUtil;
        this.wsaFactory = wsaFactory;
        this.wsaUtil = wsaUtil;
    }

    public void mapToJaxbSoapHeader(WsAddressingHeader src, List<Object> dest) {
        src.getAction().ifPresent(attributedURIType -> this.addWithDuplicateCheck(this.wsaFactory.createAction(attributedURIType), dest));
        src.getMessageId().ifPresent(attributedURIType -> this.addWithDuplicateCheck(this.wsaFactory.createMessageID(attributedURIType), dest));
        src.getTo().ifPresent(attributedURIType -> this.addWithDuplicateCheck(this.wsaFactory.createTo(attributedURIType), dest));
        src.getRelatesTo().ifPresent(attributedURIType -> {
            RelatesToType relatesToType = this.wsaFactory.createRelatesToType();
            relatesToType.setValue(attributedURIType.getValue());
            this.addWithDuplicateCheck(this.wsaFactory.createRelatesTo(relatesToType), dest);
        });
        src.getMappedReferenceParameters().ifPresent(referenceParameters -> referenceParameters.forEach(param -> {
            param.setAttributeNS("http://www.w3.org/2005/08/addressing", "wsa:" + WsAddressingConstants.IS_REFERENCE_PARAMETER.getLocalPart(), "true");
            this.addWithDuplicateCheck(param, dest);
        }));
    }

    private void addWithDuplicateCheck(Object obj, List<Object> dest) {
        if (obj instanceof JAXBElement) {
            JAXBElement jaxbObj = (JAXBElement)obj;
            for (Object element : dest) {
                if (!(element instanceof JAXBElement)) continue;
                JAXBElement jaxbElement = (JAXBElement)element;
                if (!jaxbObj.getName().equals(jaxbElement.getName()) || !jaxbObj.getDeclaredType().equals(jaxbElement.getDeclaredType()) || !jaxbObj.getScope().equals(jaxbElement.getScope())) continue;
                this.instanceLogger.warn("Envelope header already contains entry for JAXBElement {}.Removing previously set element with value {} and replacing it with {}", obj, jaxbElement.getValue(), jaxbObj.getValue());
                dest.remove(jaxbElement);
                break;
            }
        }
        dest.add(obj);
    }

    public void mapFromJaxbSoapHeader(List<Object> src, WsAddressingHeader dest) {
        ArrayList<Element> referenceParameters = new ArrayList<Element>();
        src.forEach(jaxbObject -> {
            Element elem;
            boolean isRefParm;
            Optional rt;
            Optional uri = this.jaxbUtil.extractElement(jaxbObject, WsAddressingConstants.ACTION);
            if (uri.isPresent() && dest.getAction().isEmpty()) {
                dest.setAction((AttributedURIType)uri.get());
            }
            if ((uri = this.jaxbUtil.extractElement(jaxbObject, WsAddressingConstants.MESSAGE_ID)).isPresent() && dest.getMessageId().isEmpty()) {
                dest.setMessageId((AttributedURIType)uri.get());
            }
            if ((uri = this.jaxbUtil.extractElement(jaxbObject, WsAddressingConstants.TO)).isPresent() && dest.getTo().isEmpty()) {
                dest.setTo((AttributedURIType)uri.get());
            }
            if ((rt = this.jaxbUtil.extractElement(jaxbObject, WsAddressingConstants.RELATES_TO)).isPresent() && dest.getRelatesTo().isEmpty()) {
                RelatesToType rtt = this.wsaUtil.createRelatesToType(((RelatesToType)rt.get()).getValue());
                rtt.setRelationshipType(((RelatesToType)rt.get()).getRelationshipType());
                dest.setRelatesTo(rtt);
            }
            if (jaxbObject instanceof Element && (isRefParm = (elem = (Element)jaxbObject).hasAttributeNS(WsAddressingConstants.IS_REFERENCE_PARAMETER.getNamespaceURI(), WsAddressingConstants.IS_REFERENCE_PARAMETER.getLocalPart()))) {
                this.instanceLogger.debug("Incoming message contained reference parameter element ({}:{})", (Object)elem.getNamespaceURI(), (Object)elem.getTagName());
                referenceParameters.add(elem);
            }
        });
        if (!referenceParameters.isEmpty()) {
            dest.setMappedReferenceParameters(referenceParameters);
        }
    }
}

