/*
 * Decompiled with CFR 0.152.
 */
package com.example;

import com.example.CustomCryptoSettings;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.somda.sdc.dpws.crypto.CryptoSettings;

public class BaseUtil {
    private static final String OPT_EPR = "epr";
    private static final String OPT_ADDRESS = "address";
    private static final String OPT_IFACE = "iface";
    private static final String OPT_NO_TLS = "no_tls";
    private static final String OPT_KEYSTORE_PATH = "keystore";
    private static final String OPT_TRUSTSTORE_PATH = "truststore";
    private static final String OPT_KEYSTORE_PASSWORD = "keystore_password";
    private static final String OPT_TRUSTSTORE_PASSWORD = "truststore_password";
    private final CommandLine parsedArgs;
    private String epr;
    private String iface;
    private boolean useTls;
    private String address;

    public BaseUtil(String[] args) {
        this.parsedArgs = this.parseCommandLineArgs(args, this.configureOptions());
        this.epr = this.parsedArgs.getOptionValue(OPT_EPR);
        this.iface = this.parsedArgs.getOptionValue(OPT_IFACE);
        this.useTls = !this.parsedArgs.hasOption(OPT_NO_TLS);
        this.address = this.parsedArgs.getOptionValue(OPT_ADDRESS);
    }

    protected Options configureOptions() {
        Options options = new Options();
        Option epr = new Option("e", OPT_EPR, true, "epr address of provider");
        epr.setRequired(false);
        options.addOption(epr);
        Option networkInterface = new Option("i", OPT_IFACE, true, "network interface to use");
        networkInterface.setRequired(false);
        options.addOption(networkInterface);
        Option ipAddress = new Option("a", OPT_ADDRESS, true, "ip address to bind to. if an adapter has been selected, this will be ignored");
        ipAddress.setRequired(false);
        options.addOption(ipAddress);
        Option tls = new Option("u", OPT_NO_TLS, false, "disable tls");
        tls.setRequired(false);
        options.addOption(tls);
        Option keyStorePath = new Option(null, OPT_KEYSTORE_PATH, true, "keystore path");
        keyStorePath.setRequired(false);
        options.addOption(keyStorePath);
        Option trustStorePath = new Option(null, OPT_TRUSTSTORE_PATH, true, "truststore path");
        trustStorePath.setRequired(false);
        options.addOption(trustStorePath);
        Option keyStorePassword = new Option(null, OPT_KEYSTORE_PASSWORD, true, "keystore password");
        keyStorePassword.setRequired(false);
        options.addOption(keyStorePassword);
        Option keystorePath = new Option(null, OPT_TRUSTSTORE_PASSWORD, true, "truststore password");
        keystorePath.setRequired(false);
        options.addOption(keystorePath);
        return options;
    }

    private CommandLine parseCommandLineArgs(String[] args, Options options) {
        DefaultParser parser = new DefaultParser();
        HelpFormatter formatter = new HelpFormatter();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            formatter.printHelp("COMMAND", options);
            System.exit(1);
        }
        return cmd;
    }

    public CryptoSettings createCustomCryptoSettings() {
        String keyPath = this.parsedArgs.getOptionValue(OPT_KEYSTORE_PATH);
        String trustPath = this.parsedArgs.getOptionValue(OPT_KEYSTORE_PATH);
        String keyPass = this.parsedArgs.getOptionValue(OPT_KEYSTORE_PASSWORD);
        String trustPass = this.parsedArgs.getOptionValue(OPT_TRUSTSTORE_PASSWORD);
        if (keyPath != null && trustPath != null && keyPass != null && trustPass != null) {
            return new CustomCryptoSettings(keyPath, trustPath, keyPass, trustPass);
        }
        return new CustomCryptoSettings();
    }

    public CommandLine getParsedArgs() {
        return this.parsedArgs;
    }

    public String getEpr() {
        return this.epr;
    }

    public String getIface() {
        return this.iface;
    }

    public boolean isUseTls() {
        return this.useTls;
    }

    public String getAddress() {
        if (this.address == null || this.address.isBlank()) {
            return System.getenv().getOrDefault("ref_ip", "127.0.0.1");
        }
        return this.address;
    }

    public void setEpr(String epr) {
        this.epr = epr;
    }

    public void setIface(String iface) {
        this.iface = iface;
    }

    public void setUseTls(boolean useTls) {
        this.useTls = useTls;
    }

    public void setAddress(String address) {
        this.address = address;
    }
}

