/*
 * Decompiled with CFR 0.152.
 */
package com.example;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.somda.sdc.dpws.crypto.CryptoSettings;

public class CustomCryptoSettings
implements CryptoSettings {
    private static final Logger LOG = LoggerFactory.getLogger(CustomCryptoSettings.class);
    private static final String DEFAULT_KEYSTORE = "crypto/sdcparticipant.jks";
    private static final String DEFAULT_TRUSTSTORE = "crypto/root.jks";
    private static final String DEFAULT_KEYSTORE_PASSWORD = "whatever";
    private static final String DEFAULT_TRUSTSTORE_PASSWORD = "whatever";
    private File keyStorePath = null;
    private File trustStorePath = null;
    private String keyStorePassword = null;
    private String trustStorePassword = null;

    public CustomCryptoSettings(String keyStorePath, String trustStorePath, String keyStorePassword, String trustStorePassword) {
        this.keyStorePath = new File(keyStorePath);
        this.trustStorePath = new File(trustStorePath);
        this.keyStorePassword = keyStorePassword;
        this.trustStorePassword = trustStorePassword;
    }

    public CustomCryptoSettings() {
    }

    public Optional<File> getKeyStoreFile() {
        return Optional.empty();
    }

    public Optional<InputStream> getKeyStoreStream() {
        if (this.keyStorePath != null) {
            try {
                return Optional.of(new FileInputStream(this.keyStorePath.getPath()));
            }
            catch (FileNotFoundException e) {
                LOG.error("Specified keystore file could not be found", (Throwable)e);
                throw new RuntimeException("Specified keystore file could not be found", e);
            }
        }
        return Optional.ofNullable(this.getClass().getClassLoader().getResourceAsStream(DEFAULT_KEYSTORE));
    }

    public String getKeyStorePassword() {
        return Objects.requireNonNullElse(this.keyStorePassword, "whatever");
    }

    public Optional<File> getTrustStoreFile() {
        return Optional.empty();
    }

    public Optional<InputStream> getTrustStoreStream() {
        if (this.trustStorePath != null) {
            try {
                return Optional.of(new FileInputStream(this.trustStorePath.getPath()));
            }
            catch (FileNotFoundException e) {
                LOG.error("Specified truststore file could not be found", (Throwable)e);
                throw new RuntimeException("Specified truststore file could not be found", e);
            }
        }
        return Optional.ofNullable(this.getClass().getClassLoader().getResourceAsStream(DEFAULT_TRUSTSTORE));
    }

    public String getTrustStorePassword() {
        return Objects.requireNonNullElse(this.trustStorePassword, "whatever");
    }
}

