/*
 * Decompiled with CFR 0.152.
 */
package com.example.consumer1;

import com.example.consumer1.ConsumerReportProcessor;
import com.example.consumer1.ConsumerUtil;
import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.inject.Injector;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.somda.sdc.biceps.common.access.MdibAccessObserver;
import org.somda.sdc.biceps.model.message.AbstractSet;
import org.somda.sdc.biceps.model.message.Activate;
import org.somda.sdc.biceps.model.message.ActivateResponse;
import org.somda.sdc.biceps.model.message.InvocationState;
import org.somda.sdc.biceps.model.message.OperationInvokedReport;
import org.somda.sdc.biceps.model.message.SetString;
import org.somda.sdc.biceps.model.message.SetStringResponse;
import org.somda.sdc.biceps.model.message.SetValue;
import org.somda.sdc.biceps.model.message.SetValueResponse;
import org.somda.sdc.biceps.model.participant.LocationContextState;
import org.somda.sdc.biceps.model.participant.PatientContextState;
import org.somda.sdc.dpws.DpwsFramework;
import org.somda.sdc.dpws.client.Client;
import org.somda.sdc.dpws.client.DiscoveredDevice;
import org.somda.sdc.dpws.client.DiscoveryObserver;
import org.somda.sdc.dpws.client.event.ProbedDeviceFoundMessage;
import org.somda.sdc.dpws.service.HostingServiceProxy;
import org.somda.sdc.dpws.soap.exception.TransportException;
import org.somda.sdc.dpws.soap.interception.InterceptorException;
import org.somda.sdc.glue.consumer.ConnectConfiguration;
import org.somda.sdc.glue.consumer.PrerequisitesException;
import org.somda.sdc.glue.consumer.SdcDiscoveryFilterBuilder;
import org.somda.sdc.glue.consumer.SdcRemoteDevice;
import org.somda.sdc.glue.consumer.SdcRemoteDevicesConnector;
import org.somda.sdc.glue.consumer.SetServiceAccess;
import org.somda.sdc.glue.consumer.sco.ScoTransaction;

public class Consumer {
    private static final Logger LOG = LoggerFactory.getLogger(Consumer.class);
    private static final Duration MAX_WAIT = Duration.ofSeconds(11L);
    private static final long MAX_WAIT_SEC = MAX_WAIT.getSeconds();
    private static final long REPORT_TIMEOUT = Duration.ofSeconds(30L).toMillis();
    private final ConsumerUtil consumerUtil;
    private final Client client;
    private final SdcRemoteDevicesConnector connector;
    private DpwsFramework dpwsFramework;
    private final Injector injector;
    private NetworkInterface networkInterface;

    public Consumer(ConsumerUtil consumerUtil) throws SocketException, UnknownHostException {
        this.consumerUtil = consumerUtil;
        this.injector = consumerUtil.getInjector();
        this.client = (Client)this.injector.getInstance(Client.class);
        this.connector = (SdcRemoteDevicesConnector)this.injector.getInstance(SdcRemoteDevicesConnector.class);
        if (consumerUtil.getIface() != null && !consumerUtil.getIface().isBlank()) {
            LOG.info("Starting with interface {}", (Object)consumerUtil.getIface());
            this.networkInterface = NetworkInterface.getByName(consumerUtil.getIface());
        } else if (consumerUtil.getAddress() != null && !consumerUtil.getAddress().isBlank()) {
            LOG.info("Starting with address {}", (Object)consumerUtil.getAddress());
            this.networkInterface = NetworkInterface.getByInetAddress(InetAddress.getByName(consumerUtil.getAddress()));
        } else {
            this.networkInterface = NetworkInterface.getByInetAddress(InetAddress.getLoopbackAddress());
            LOG.info("Starting with fallback default adapter {}", (Object)this.networkInterface);
        }
    }

    public Client getClient() {
        return this.client;
    }

    public SdcRemoteDevicesConnector getConnector() {
        return this.connector;
    }

    protected void startUp() throws SocketException {
        this.dpwsFramework = (DpwsFramework)this.injector.getInstance(DpwsFramework.class);
        this.dpwsFramework.setNetworkInterface(this.networkInterface);
        this.dpwsFramework.startAsync().awaitRunning();
        this.client.startAsync().awaitRunning();
    }

    protected void shutDown() {
        this.client.stopAsync().awaitTerminated();
        this.dpwsFramework.stopAsync().awaitTerminated();
    }

    static InvocationState invokeActivate(SetServiceAccess setServiceAccess, String handle, List<String> args) throws ExecutionException, InterruptedException, TimeoutException {
        LOG.info("Invoking Activate for handle {} with arguments {}", (Object)handle, args);
        Activate activate = new Activate();
        List argumentList = args.stream().map(x -> {
            Activate.Argument arg = new Activate.Argument();
            arg.setArgValue(x);
            return arg;
        }).collect(Collectors.toList());
        activate.setArgument(argumentList);
        activate.setOperationHandleRef(handle);
        ListenableFuture activateFuture = setServiceAccess.invoke((AbstractSet)activate, ActivateResponse.class);
        ScoTransaction activateResponse = (ScoTransaction)activateFuture.get(MAX_WAIT_SEC, TimeUnit.SECONDS);
        List reportParts = activateResponse.waitForFinalReport(Duration.ofSeconds(5L));
        return ((OperationInvokedReport.ReportPart)reportParts.get(reportParts.size() - 1)).getInvocationInfo().getInvocationState();
    }

    static InvocationState invokeSetValue(SetServiceAccess setServiceAccess, String handle, BigDecimal value) throws ExecutionException, InterruptedException, TimeoutException {
        LOG.info("Invoking SetValue for handle {} with value {}", (Object)handle, (Object)value);
        SetValue setValue = new SetValue();
        setValue.setOperationHandleRef(handle);
        setValue.setRequestedNumericValue(value);
        ListenableFuture setValueFuture = setServiceAccess.invoke((AbstractSet)setValue, SetValueResponse.class);
        ScoTransaction setValueResponse = (ScoTransaction)setValueFuture.get(MAX_WAIT_SEC, TimeUnit.SECONDS);
        List reportParts = setValueResponse.waitForFinalReport(Duration.ofSeconds(5L));
        return ((OperationInvokedReport.ReportPart)reportParts.get(reportParts.size() - 1)).getInvocationInfo().getInvocationState();
    }

    static InvocationState invokeSetString(SetServiceAccess setServiceAccess, String handle, String value) throws ExecutionException, InterruptedException, TimeoutException {
        LOG.info("Invoking SetString for handle {} with value {}", (Object)handle, (Object)value);
        SetString setString = new SetString();
        setString.setOperationHandleRef(handle);
        setString.setRequestedStringValue(value);
        ListenableFuture setStringFuture = setServiceAccess.invoke((AbstractSet)setString, SetStringResponse.class);
        ScoTransaction setStringResponse = (ScoTransaction)setStringFuture.get(MAX_WAIT_SEC, TimeUnit.SECONDS);
        List reportParts = setStringResponse.waitForFinalReport(Duration.ofSeconds(5L));
        if (!reportParts.isEmpty()) {
            return ((OperationInvokedReport.ReportPart)reportParts.get(reportParts.size() - 1)).getInvocationInfo().getInvocationState();
        }
        throw new InterruptedException("No report parts received, help.");
    }

    public Injector getInjector() {
        return this.injector;
    }

    public static void main(String[] args) throws SocketException, UnknownHostException, InterceptorException, TransportException, InterruptedException {
        ConsumerUtil settings = new ConsumerUtil(args);
        final String targetEpr = settings.getEpr();
        Consumer consumer = new Consumer(settings);
        consumer.startUp();
        HashMap<Integer, Boolean> resultMap = new HashMap<Integer, Boolean>(Map.of(1, false, 2, false, 3, false, 4, false, 5, false, 6, false, 7, false, 8, false, 9, false));
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            ArrayList keys = new ArrayList(resultMap.keySet());
            Collections.sort(keys);
            keys.forEach(key -> System.out.println(String.format("### Test %s ### %s", key, (Boolean)resultMap.get(key) != false ? "passed" : "failed")));
        }));
        LOG.info("Starting discovery for {}", (Object)targetEpr);
        final SettableFuture xAddrs = SettableFuture.create();
        DiscoveryObserver obs = new DiscoveryObserver(){

            @Subscribe
            void deviceFound(ProbedDeviceFoundMessage message) {
                DiscoveredDevice payload = (DiscoveredDevice)message.getPayload();
                if (payload.getEprAddress().equals(targetEpr)) {
                    LOG.info("Found device with epr {}", (Object)payload.getEprAddress());
                    xAddrs.set((Object)payload.getXAddrs());
                } else {
                    LOG.info("Found non-matching device with epr {}", (Object)payload.getEprAddress());
                }
            }
        };
        consumer.getClient().registerDiscoveryObserver(obs);
        SdcDiscoveryFilterBuilder discoveryFilterBuilder = SdcDiscoveryFilterBuilder.create();
        consumer.getClient().probe(discoveryFilterBuilder.get());
        try {
            List targetXAddrs = (List)xAddrs.get(MAX_WAIT_SEC, TimeUnit.SECONDS);
            resultMap.put(1, true);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LOG.error("Couldn't find target with EPR {}", (Object)targetEpr, (Object)e);
            System.exit(1);
        }
        consumer.getClient().unregisterDiscoveryObserver(obs);
        String deviceUri = targetEpr;
        LOG.info("Connecting to {}", (Object)targetEpr);
        ListenableFuture hostingServiceFuture = consumer.getClient().connect(deviceUri);
        HostingServiceProxy hostingServiceProxy = null;
        try {
            hostingServiceProxy = (HostingServiceProxy)hostingServiceFuture.get(MAX_WAIT_SEC, TimeUnit.SECONDS);
            resultMap.put(2, true);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LOG.error("Couldn't connect to EPR {}", (Object)targetEpr, (Object)e);
            System.exit(1);
        }
        LOG.info("Attaching to remote mdib and subscriptions for {}", (Object)targetEpr);
        SdcRemoteDevice sdcRemoteDevice = null;
        try {
            ListenableFuture remoteDeviceFuture = consumer.getConnector().connect(hostingServiceProxy, ConnectConfiguration.create((Collection)ConnectConfiguration.ALL_EPISODIC_AND_WAVEFORM_REPORTS));
            sdcRemoteDevice = (SdcRemoteDevice)remoteDeviceFuture.get(MAX_WAIT_SEC, TimeUnit.SECONDS);
            resultMap.put(3, true);
            resultMap.put(4, true);
        }
        catch (InterruptedException | ExecutionException | TimeoutException | PrerequisitesException e) {
            LOG.error("Couldn't attach to remote mdib and subscriptions for {}", (Object)targetEpr, (Object)e);
            System.exit(1);
        }
        ConsumerReportProcessor reportObs = new ConsumerReportProcessor();
        sdcRemoteDevice.getMdibAccessObservable().registerObserver((MdibAccessObserver)reportObs);
        List contextStates = sdcRemoteDevice.getMdibAccess().getContextStates();
        long numPatientContexts = contextStates.stream().filter(x -> PatientContextState.class.isAssignableFrom(x.getClass())).count();
        resultMap.put(5, numPatientContexts >= 1L);
        long numLocationContexts = contextStates.stream().filter(x -> LocationContextState.class.isAssignableFrom(x.getClass())).count();
        resultMap.put(6, numLocationContexts >= 1L);
        Thread.sleep(REPORT_TIMEOUT);
        int minNumberReports = (int)(REPORT_TIMEOUT / Duration.ofSeconds(5L).toMillis()) - 1;
        boolean metricChangesOk = reportObs.numMetricChanges >= minNumberReports;
        resultMap.put(7, metricChangesOk);
        boolean conditionChangesOk = reportObs.numConditionChanges >= minNumberReports;
        resultMap.put(8, conditionChangesOk);
        SetServiceAccess setServiceAccess = sdcRemoteDevice.getSetServiceAccess();
        boolean operationFailed = false;
        try {
            Consumer.invokeSetString(setServiceAccess, "string.ch0.vmd1_sco_0", "SDCri was here");
        }
        catch (ExecutionException | TimeoutException e) {
            operationFailed = true;
            LOG.error("Could not invoke {}", (Object)"string.ch0.vmd1_sco_0", (Object)e);
        }
        try {
            Consumer.invokeSetString(setServiceAccess, "enumstring.ch0.vmd1_sco_0", "OFF");
        }
        catch (ExecutionException | TimeoutException e) {
            operationFailed = true;
            LOG.error("Could not invoke {}", (Object)"enumstring.ch0.vmd1_sco_0", (Object)e);
        }
        try {
            Consumer.invokeSetValue(setServiceAccess, "numeric.ch0.vmd1_sco_0", BigDecimal.valueOf(20L));
        }
        catch (ExecutionException | TimeoutException e) {
            operationFailed = true;
            LOG.error("Could not invoke {}", (Object)"numeric.ch0.vmd1_sco_0", (Object)e);
        }
        try {
            Consumer.invokeActivate(setServiceAccess, "actop.vmd1_sco_0", Collections.emptyList());
        }
        catch (ExecutionException | TimeoutException e) {
            operationFailed = true;
            LOG.error("Could not invoke {}", (Object)"actop.vmd1_sco_0", (Object)e);
        }
        resultMap.put(9, !operationFailed);
        LOG.info("Done, quitting");
        sdcRemoteDevice.getMdibAccessObservable().unregisterObserver((MdibAccessObserver)reportObs);
        sdcRemoteDevice.stopAsync().awaitTerminated();
        consumer.getConnector().disconnect(deviceUri);
        consumer.shutDown();
    }
}

